/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchRecorder;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XDispatchRecorder
extends MultiMethodTest {
    public static XDispatchRecorder oObj = null;
    XFrame xFrame = null;
    URL dispURL = null;
    PropertyValue[] dispArgs = new PropertyValue[0];

    @Override
    protected void before() {
        this.xFrame = (XFrame)this.tEnv.getObjRelation("XDispatchRecorder.Frame");
        if (this.xFrame == null) {
            throw new StatusException(Status.failed("Relation not found"));
        }
    }

    public void _startRecording() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        this.tRes.tested("startRecording()", true);
    }

    public void _getRecordedMacro() {
        boolean res;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.log.println("dispatch calles via API must be recorded");
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue prop = new PropertyValue();
        prop.Name = "Text";
        prop.Value = "XDispatchRecorder.endRecording()";
        this.dispArgs = new PropertyValue[]{prop};
        this.log.println("Dispatching event for frame ...");
        XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)this.xFrame);
        XDispatch xDisp = xDispProv.queryDispatch(this.dispURL, "", 0);
        xDisp.dispatch(this.dispURL, this.dispArgs);
        this.shortWait();
        this.log.println("Getting macro ... :");
        String macro = oObj.getRecordedMacro();
        this.log.println(macro);
        this.log.println("Ending record ...");
        oObj.endRecording();
        boolean bl = res = macro != null && macro.indexOf(this.dispURL.Complete) > -1;
        if (!res) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' was NOT found in macro - FAILED");
        }
        this.tRes.tested("getRecordedMacro()", res);
    }

    public void _endRecording() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        String macro = oObj.getRecordedMacro();
        boolean res = true;
        if (macro.length() != 0) {
            this.log.println("'endRecording()' was called but macro buffer is not cleared: FALSE");
            this.log.println(macro);
            res = false;
        }
        this.tRes.tested("endRecording()", res);
    }

    public void _recordDispatch() {
        boolean res;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue prop = new PropertyValue();
        prop.Name = "Text";
        prop.Value = "XDispatchRecorder.recordDispatch()";
        this.dispArgs = new PropertyValue[]{prop};
        this.log.println("Recording dispatch ...");
        oObj.recordDispatch(this.dispURL, this.dispArgs);
        this.log.println("Getting macro ... :");
        String macro = oObj.getRecordedMacro();
        this.log.println(macro);
        oObj.endRecording();
        boolean bl = res = macro != null && macro.indexOf(this.dispURL.Complete) > -1 && macro.indexOf((String)this.dispArgs[0].Value) > -1;
        if (!res) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' or its argument '" + this.dispArgs[0].Value + "' was not found in macro returned - FAILED");
        }
        this.tRes.tested("recordDispatch()", res);
    }

    public void _recordDispatchAsComment() {
        boolean res;
        this.clearBuffer();
        oObj.startRecording(this.xFrame);
        this.dispURL = utils.parseURL((XMultiServiceFactory)this.tParam.getMSF(), ".uno:InsertText");
        PropertyValue prop = new PropertyValue();
        prop.Name = "Text";
        prop.Value = "XDispatchRecorder.recordDispatchAsComment()";
        this.dispArgs = new PropertyValue[]{prop};
        this.log.println("Recording dispatch ...");
        oObj.recordDispatchAsComment(this.dispURL, this.dispArgs);
        this.log.println("Getting macro ... :");
        String macro = oObj.getRecordedMacro();
        this.log.println(macro);
        oObj.endRecording();
        boolean bl = res = macro != null && macro.indexOf(this.dispURL.Complete) > -1 && macro.indexOf((String)this.dispArgs[0].Value) > -1;
        if (!res) {
            this.log.println("Dispatch URL '" + this.dispURL.Complete + "' or its argument '" + this.dispArgs[0].Value + "' was not found in macro returned - FAILED");
        }
        this.log.println("Checking if macro is commented ...");
        int idx = macro.indexOf((String)this.dispArgs[0].Value);
        int lineStartIdx = macro.lastIndexOf("\n", idx);
        String lineStart = macro.substring(lineStartIdx + 1, idx).toLowerCase();
        this.log.println("Line start is '" + lineStart + "'");
        if (lineStart.startsWith("'") || lineStart.startsWith("rem")) {
            this.log.println("Line is commented : OK");
        } else {
            this.log.println("Line is not commented : FAILED");
            res = false;
        }
        this.tRes.tested("recordDispatchAsComment()", res);
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void clearBuffer() {
        oObj.startRecording(this.xFrame);
        oObj.endRecording();
        String macro = oObj.getRecordedMacro();
        if (macro.length() != 0) {
            this.log.println("ERROR: 'endRecording()' was called but macro buffer is not cleared!");
            this.log.println(macro);
        }
    }
}

