/*
 * Decompiled with CFR 0.152.
 */
package ifc.frame;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchResultEvent;
import com.sun.star.frame.FeatureStateEvent;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchResultListener;
import com.sun.star.frame.XNotifyingDispatch;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDispatch
extends MultiMethodTest {
    public XDispatch oObj = null;
    TestStatusListener listener = null;
    TestNotificationListener notificationListener = null;
    URL url = null;

    private boolean checkXDispatchWithNotification() {
        XNotifyingDispatch xND = UnoRuntime.queryInterface(XNotifyingDispatch.class, (Object)this.oObj);
        if (xND != null) {
            this.log.println("   XNotifyingDispatch found:");
            PropertyValue[] arguments = (PropertyValue[])this.tEnv.getObjRelation("XNotifyingDispatchArgument");
            this.notificationListener = new TestNotificationListener(this.log);
            xND.dispatchWithNotification(this.url, arguments, this.notificationListener);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.println("   Listener called: " + this.notificationListener.finishedDispatch);
            return this.notificationListener.finishedDispatch;
        }
        return false;
    }

    @Override
    public void before() {
        this.listener = new TestStatusListener(this.log);
        this.url = (URL)this.tEnv.getObjRelation("XDispatch.URL");
        if (this.url == null) {
            throw new StatusException(Status.failed("Relation not found."));
        }
    }

    public void _dispatch() {
        this.requiredMethod("addStatusListener()");
        boolean result = true;
        this.oObj.dispatch(this.url, new PropertyValue[0]);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.println("Listener called: " + this.listener.statusChangedCalled);
        result = this.listener.statusChangedCalled;
        if (!result) {
            result = this.checkXDispatchWithNotification();
        }
        this.tRes.tested("dispatch()", result);
    }

    public void _addStatusListener() {
        boolean result = true;
        this.oObj.addStatusListener(this.listener, this.url);
        this.tRes.tested("addStatusListener()", result);
    }

    public void _removeStatusListener() {
        this.requiredMethod("dispatch()");
        this.listener.statusChangedCalled = false;
        boolean result = true;
        this.oObj.removeStatusListener(this.listener, this.url);
        this.oObj.dispatch(this.url, new PropertyValue[0]);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Listener called: " + this.listener.statusChangedCalled);
        result = !this.listener.statusChangedCalled;
        this.tRes.tested("removeStatusListener()", result);
    }

    protected class TestNotificationListener
    implements XDispatchResultListener {
        public boolean disposingCalled = false;
        public boolean finishedDispatch = false;
        private PrintWriter log = null;

        public TestNotificationListener(PrintWriter log) {
            this.log = log;
        }

        @Override
        public void disposing(EventObject e) {
            this.disposingCalled = true;
            this.log.println("   disposing was called.");
        }

        @Override
        public void dispatchFinished(DispatchResultEvent e) {
            this.finishedDispatch = true;
            this.log.println("   dispatchFinished was called.");
        }
    }

    protected class TestStatusListener
    implements XStatusListener {
        public boolean disposingCalled = false;
        public boolean statusChangedCalled = false;
        private PrintWriter log = null;

        public TestStatusListener(PrintWriter log) {
            this.log = log;
        }

        @Override
        public void disposing(EventObject e) {
            this.disposingCalled = true;
            this.log.println(" disposing was called.");
        }

        @Override
        public void statusChanged(FeatureStateEvent e) {
            this.statusChangedCalled = true;
            this.log.println(" statusChanged was called.");
            this.log.println("  FeatureURL = '" + e.FeatureURL + "'");
            this.log.println("  FeatureDescriptor = '" + e.FeatureDescriptor + "'");
            this.log.println("  IsEnabled = " + e.IsEnabled);
            this.log.println("  Requery = " + e.Requery);
            this.log.println("  State = '" + e.State.toString() + "'");
        }
    }
}

