/*
 * Decompiled with CFR 0.152.
 */
package ifc.form;

import com.sun.star.form.XLoadListener;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.EventObject;
import java.io.PrintWriter;
import lib.MultiMethodTest;

public class _XLoadable
extends MultiMethodTest {
    public XLoadable oObj = null;
    TestLoadListener loadListener = null;

    @Override
    public void before() {
        this.loadListener = new TestLoadListener(this.log);
    }

    private void shortWait() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void _load() {
        this.requiredMethod("isLoaded()");
        this.requiredMethod("addLoadListener()");
        boolean result = true;
        this.oObj.load();
        this.shortWait();
        result = this.oObj.isLoaded() && this.loadListener.loadedCalled;
        this.tRes.tested("load()", result);
    }

    public void _unload() {
        this.requiredMethod("reload()");
        this.requiredMethod("addLoadListener()");
        boolean result = true;
        this.oObj.unload();
        this.shortWait();
        result = !this.oObj.isLoaded() && this.loadListener.unloadedCalled;
        this.tRes.tested("unload()", result);
    }

    public void _reload() {
        this.requiredMethod("load()");
        this.requiredMethod("addLoadListener()");
        boolean result = true;
        this.oObj.reload();
        this.shortWait();
        result = this.oObj.isLoaded() && this.loadListener.reloadedCalled;
        this.tRes.tested("reload()", result);
    }

    public void _isLoaded() {
        boolean isLoaded = this.oObj.isLoaded();
        if (isLoaded) {
            this.oObj.unload();
        }
        this.tRes.tested("isLoaded()", !(isLoaded = this.oObj.isLoaded()));
    }

    public void _addLoadListener() {
        boolean result = true;
        this.oObj.addLoadListener(this.loadListener);
        this.tRes.tested("addLoadListener()", result);
    }

    public void _removeLoadListener() {
        this.requiredMethod("unload()");
        boolean result = true;
        this.oObj.removeLoadListener(this.loadListener);
        this.loadListener.loadedCalled = false;
        this.oObj.load();
        result = !this.loadListener.loadedCalled;
        this.tRes.tested("removeLoadListener()", result);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    protected class TestLoadListener
    implements XLoadListener {
        public boolean disposingCalled = false;
        public boolean loadedCalled = false;
        public boolean reloadedCalled = false;
        public boolean reloadingCalled = false;
        public boolean unloadedCalled = false;
        public boolean unloadingCalled = false;
        private PrintWriter log = null;

        public TestLoadListener(PrintWriter log) {
            this.log = log;
        }

        @Override
        public void disposing(EventObject e) {
            this.disposingCalled = true;
            this.log.println(" disposing was called.");
        }

        @Override
        public void loaded(EventObject e) {
            this.loadedCalled = true;
            this.log.println(" loaded was called.");
        }

        @Override
        public void reloaded(EventObject e) {
            this.reloadedCalled = true;
            this.log.println(" reloaded was called.");
        }

        @Override
        public void reloading(EventObject e) {
            this.reloadingCalled = true;
            this.log.println(" reloading was called.");
        }

        @Override
        public void unloaded(EventObject e) {
            this.unloadedCalled = true;
            this.log.println(" unloaded was called.");
        }

        @Override
        public void unloading(EventObject e) {
            this.unloadingCalled = true;
            this.log.println(" unloading was called.");
        }
    }
}

