/*
 * Decompiled with CFR 0.152.
 */
package ifc.document;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XDocumentInsertable
extends MultiMethodTest {
    public XDocumentInsertable oObj = null;
    protected XTextRange range = null;
    protected static final String defaultFileName = "XDocumentInsertable.sxw";
    protected InsertChecker checker = null;
    protected String fileName = "XDocumentInsertable.sxw";

    @Override
    public void before() {
        this.checker = (InsertChecker)this.tEnv.getObjRelation("XDocumentInsertable.Checker");
        if (this.checker == null) {
            this.log.println("Relaion not found, trying to query for XTextRange ...");
            this.range = UnoRuntime.queryInterface(XTextRange.class, (Object)this.oObj);
            if (this.range == null) {
                this.log.println("XTextRange isn't supported by the component.");
                throw new StatusException(Status.failed("XTextRange isn't supported and relation not found"));
            }
        } else {
            this.fileName = this.checker.getFileNameToInsert();
        }
    }

    public void _insertDocumentFromURL() {
        String docURL;
        PropertyValue[] szEmptyArgs;
        boolean result = true;
        try {
            szEmptyArgs = new PropertyValue[]{};
            docURL = utils.getFullTestURL(this.fileName);
            this.log.println("Inserting document from URL '" + docURL + "'");
            this.oObj.insertDocumentFromURL(docURL, szEmptyArgs);
            if (this.checker == null) {
                this.log.println("Checker is not specified, testing through XTextRange ...");
                String text = this.range.getString();
                this.log.println("Document text :\n" + text);
                this.log.println("---");
                result &= text.indexOf("XDocumentInsertable test.") >= 0;
            } else {
                result &= this.checker.isInserted();
            }
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured while testing insertDocumentFromURL()");
            ex.printStackTrace(this.log);
            result = false;
        }
        catch (IOException ex) {
            this.log.println("Exception occured while testing insertDocumentFromURL()");
            ex.printStackTrace(this.log);
            result = false;
        }
        try {
            szEmptyArgs = new PropertyValue[]{};
            docURL = "file:///c:/ThisIsAnInvaldURL";
            this.log.println("Inserting document from URL '" + docURL + "'");
            this.oObj.insertDocumentFromURL(docURL, szEmptyArgs);
            result = false;
        }
        catch (IOException ex) {
            this.log.println("expected exception was thrown -> ok");
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected exception was thrown -> ok");
        }
        this.tRes.tested("insertDocumentFromURL()", result);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public static abstract class InsertChecker {
        public abstract boolean isInserted();

        public String getFileNameToInsert() {
            return _XDocumentInsertable.defaultFileName;
        }
    }
}

