/*
 * Decompiled with CFR 0.152.
 */
package ifc.document;

import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.i18n.XForbiddenCharacters;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lib.MultiPropertyTest;
import lib.Status;
import lib.StatusException;

public class _Settings
extends MultiPropertyTest {
    public void _PrinterIndependentLayout() {
        try {
            Short oldVal = (Short)this.oObj.getPropertyValue("PrinterIndependentLayout");
            Short newVal = oldVal.intValue() == 1 ? new Short("3") : new Short("1");
            this.testProperty("PrinterIndependentLayout", oldVal, newVal);
        }
        catch (UnknownPropertyException e) {
            throw new StatusException(Status.failed("the property 'PrinterIndependentLayout' is unkown."));
        }
        catch (WrappedTargetException e) {
            throw new StatusException(Status.failed("the property 'PrinterIndependentLayout' could not be tested."));
        }
    }

    public void _PrinterName() {
        Object[] oServices = null;
        ReflectiveOperationException ex = null;
        try {
            Class<?> cPrinterJob = Class.forName("java.awt.print.PrinterJob");
            Method lookupMethod = cPrinterJob.getDeclaredMethod("lookupPrintServices", new Class[0]);
            Object retValue = lookupMethod.invoke(cPrinterJob, new Object[0]);
            oServices = (Object[])retValue;
        }
        catch (ClassNotFoundException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        if (ex != null) {
            String javaVersion = System.getProperty("java.version");
            throw new StatusException(Status.failed("Cannot execute test with current Java version (Java 1.4 required) " + javaVersion + ": " + ex.getMessage()));
        }
        if (oServices.length <= 1) {
            this.log.println("checking this property needs at least two printers to be installed on your system");
            throw new StatusException(Status.failed("only one printer installed so I can't change it"));
        }
        this.testProperty("PrinterName", this.getPrinterNameWithReflection(oServices[0]), this.getPrinterNameWithReflection(oServices[1]));
    }

    public void _ForbiddenCharacters() {
        boolean res = true;
        try {
            Object pValue;
            XForbiddenCharacters fc;
            res &= this.isReadOnly("ForbiddenCharacters");
            if (!this.isReadOnly("ForbiddenCharacters")) {
                this.log.println("The Property 'ForbiddenCharacters' isn't readOnly as specified");
            }
            res &= (fc = UnoRuntime.queryInterface(XForbiddenCharacters.class, pValue = this.oObj.getPropertyValue("ForbiddenCharacters"))) != null;
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception while checking property 'ForbiddenCharacters' " + e.getMessage());
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception while checking property 'ForbiddenCharacters' " + e.getMessage());
        }
        this.tRes.tested("ForbiddenCharacters", res);
    }

    protected boolean isReadOnly(String PropertyName2) {
        boolean res = false;
        Property[] props = this.oObj.getPropertySetInfo().getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].Name.equals(PropertyName2)) continue;
            res = (props[i].Attributes & 0x10) != 0;
        }
        return res;
    }

    private String getPrinterNameWithReflection(Object pService) {
        String pName = null;
        try {
            Class<?> cPrintService = Class.forName("javax.print.PrintService");
            Method getNameMethod = cPrintService.getDeclaredMethod("getName", new Class[0]);
            Object retValue = getNameMethod.invoke(pService, new Object[0]);
            pName = (String)retValue;
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return pName;
    }
}

