/*
 * Decompiled with CFR 0.152.
 */
package ifc.datatransfer.clipboard;

import com.sun.star.datatransfer.DataFlavor;
import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.clipboard.ClipboardEvent;
import com.sun.star.datatransfer.clipboard.XClipboard;
import com.sun.star.datatransfer.clipboard.XClipboardListener;
import com.sun.star.datatransfer.clipboard.XClipboardNotifier;
import com.sun.star.datatransfer.clipboard.XClipboardOwner;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XClipboardNotifier
extends MultiMethodTest {
    public XClipboardNotifier oObj;
    MyClipboardListener myListener;

    public void _addClipboardListener() {
        this.myListener = new MyClipboardListener();
        this.oObj.addClipboardListener(this.myListener);
        XClipboard board = UnoRuntime.queryInterface(XClipboard.class, (Object)this.tEnv.getTestObject());
        board.setContents(new MyTransferable(), new MyOwner());
        this.log.println("sleeping for 1 second");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("interrupted");
            e.printStackTrace(this.log);
            throw new StatusException("Operation interrupted", e);
        }
        this.tRes.tested("addClipboardListener()", this.myListener.called);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _removeClipboardListener() {
        try {
            this.requiredMethod("addClipboardListener()");
            this.myListener.called = false;
        }
        finally {
            this.oObj.removeClipboardListener(this.myListener);
        }
        XClipboard board = UnoRuntime.queryInterface(XClipboard.class, (Object)this.oObj);
        board.setContents(new MyTransferable(), new MyOwner());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("interrupted");
            e.printStackTrace(this.log);
            throw new StatusException("Operation interrupted", e);
        }
        this.tRes.tested("removeClipboardListener()", !this.myListener.called);
    }

    class MyClipboardListener
    implements XClipboardListener {
        boolean called = false;

        MyClipboardListener() {
        }

        @Override
        public void changedContents(ClipboardEvent evt) {
            this.called = true;
        }

        @Override
        public void disposing(EventObject wvt) {
            _XClipboardNotifier.this.log.println("");
        }
    }

    class MyTransferable
    implements XTransferable {
        DataFlavor[] supportedFlavors = new DataFlavor[]{new DataFlavor("text/plain", "Plain text", new Type(String.class))};

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            return "";
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.supportedFlavors[0].MimeType.equals(dataFlavor.MimeType);
        }
    }

    class MyOwner
    implements XClipboardOwner {
        XClipboard board;
        XTransferable contents;

        MyOwner() {
        }

        @Override
        public void lostOwnership(XClipboard board, XTransferable contents) {
            this.board = board;
            this.contents = contents;
        }
    }
}

