/*
 * Decompiled with CFR 0.152.
 */
package ifc.container;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import util.ValueComparer;

public class _XNameReplace
extends MultiMethodTest {
    public XNameReplace oObj = null;

    public void _replaceByName() {
        boolean result = true;
        String[] oNames = null;
        int Index = 0;
        this.log.println("get ObjRelation(\"XNameReplaceINDEX\")");
        String sIndex = (String)this.tEnv.getObjRelation("XNameReplaceINDEX");
        System.out.println("Index: " + sIndex);
        if (sIndex == null) {
            this.log.println("No XNameReplaceINDEX - so set it to 1.");
            this.tEnv.addObjRelation("XNameReplaceINDEX", Integer.toString(1));
            Index = 1;
        } else {
            Index = Integer.parseInt(sIndex);
            this.tEnv.addObjRelation("XNameReplaceINDEX", Integer.toString(++Index));
        }
        this.log.println("get ObjRelation(\"INSTANCE" + Index + "\")");
        Object oInstance = this.tEnv.getObjRelation("INSTANCE" + Index);
        if (oInstance == null) {
            this.log.println("ObjRelation(\"INSTANCE" + Index + "\") Object n.a.");
        }
        this.log.println("getting the existant object's name");
        XNameAccess oNameAccess = UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oObj);
        oNames = oNameAccess.getElementNames();
        this.log.println("get ObjRelation(\"NAMEREPLACE\")");
        Object oNameReplace = this.tEnv.getObjRelation("NAMEREPLACE");
        if (oNameReplace != null) {
            oNames[0] = oNameReplace.toString();
        }
        this.log.println("replaceByName()");
        try {
            this.log.println("get current object '" + oNames[0] + "'");
            Object old = this.oObj.getByName(oNames[0]);
            this.log.println("replace object '" + oNames[0] + "' with another instance");
            this.oObj.replaceByName(oNames[0], oInstance);
            Object newEl = this.oObj.getByName(oNames[0]);
            boolean ok = this.tEnv.getTestCase().getObjectName().equals("ScCellRangesObj") ? this.compareRanges(old, newEl) : !ValueComparer.equalValue(old, newEl);
            result &= ok;
            this.log.println("result of replace: " + ok);
            this.log.println("replace back the old object");
            this.oObj.replaceByName(oNames[0], old);
            Object origEl = this.oObj.getByName(oNames[0]);
            ok = this.tEnv.getTestCase().getObjectName().equals("ScCellRangesObj") ? !this.compareRanges(old, origEl) : ValueComparer.equalValue(old, origEl);
            result &= ok;
            this.log.println("result of replace back: " + ok);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (NoSuchElementException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (WrappedTargetException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        this.tRes.tested("replaceByName()", result);
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }

    private boolean compareRanges(Object old, Object newEl) {
        XCellRangeAddressable xCRA = UnoRuntime.queryInterface(XCellRangeAddressable.class, old);
        XCellRangeAddressable xCRA2 = UnoRuntime.queryInterface(XCellRangeAddressable.class, newEl);
        int orgStartCol = xCRA.getRangeAddress().StartColumn;
        int orgEndCol = xCRA.getRangeAddress().EndColumn;
        int orgStartRow = xCRA.getRangeAddress().StartRow;
        int orgEndRow = xCRA.getRangeAddress().EndRow;
        int newStartCol = xCRA2.getRangeAddress().StartColumn;
        int newEndCol = xCRA2.getRangeAddress().EndColumn;
        int newStartRow = xCRA2.getRangeAddress().StartRow;
        int newEndRow = xCRA2.getRangeAddress().EndRow;
        boolean ret = true;
        if (orgStartCol == newStartCol) {
            this.log.println("\t StartColumn is the same");
            ret = false;
        }
        if (orgEndCol == newEndCol) {
            this.log.println("\t EndColumn is the same");
            ret = false;
        }
        if (orgStartRow == newStartRow) {
            this.log.println("\t StartRow is the same");
            ret = false;
        }
        if (orgEndRow == newEndRow) {
            this.log.println("\t EndRow is the same");
            ret = false;
        }
        return ret;
    }
}

