/*
 * Decompiled with CFR 0.152.
 */
package ifc.container;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.container.ContainerEvent;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContainer;
import com.sun.star.container.XContainerListener;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XNamingService;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XContainer
extends MultiMethodTest {
    public XContainer oObj = null;
    private boolean bElementInserted = false;
    private boolean bElementRemoved = false;
    private boolean bElementReplaced = false;
    private PrintWriter _log = null;
    private XNameContainer NC = null;
    private XControlContainer CC = null;
    private XNamingService NV = null;
    private XNameReplace NR = null;
    private Object inst = null;
    private Object inst2 = null;
    MyListener listener = new MyListener();

    @Override
    public void before() throws StatusException {
        this._log = this.log;
        Object altObj = this.tEnv.getObjRelation("XContainer.AlternateObject");
        if (altObj != null) {
            this.oObj = UnoRuntime.queryInterface(XContainer.class, altObj);
        }
        this.NC = UnoRuntime.queryInterface(XNameContainer.class, (Object)this.oObj);
        Object container = null;
        if (this.NC == null) {
            container = this.tEnv.getObjRelation("XContainer.Container");
        }
        if (container != null) {
            if (container instanceof XControlContainer) {
                this.CC = (XControlContainer)container;
            } else if (container instanceof XNamingService) {
                this.NV = (XNamingService)container;
            } else if (container instanceof XNameReplace) {
                this.NR = (XNameReplace)container;
                this.inst2 = this.tEnv.getObjRelation("XContainer.NewValue");
                this.inst = this.tEnv.getObjRelation("XContainer.ElementName");
            } else if (container instanceof XNameContainer) {
                this.NC = (XNameContainer)container;
            }
        }
        if (this.NC == null && this.CC == null && this.NV == null && this.NR == null) {
            throw new StatusException(Status.failed("Neither object implements XNameContainer nor relation 'XContainer.Container' found."));
        }
        if (this.inst == null) {
            this.inst = this.tEnv.getObjRelation("INSTANCE");
        }
        if (this.inst == null) {
            this.log.println("No INSTANCE ObjRelation!!! ");
            throw new StatusException(Status.failed("No INSTANCE ObjRelation!!!"));
        }
        if (this.inst2 == null) {
            this.inst2 = this.tEnv.getObjRelation("INSTANCE2");
        }
    }

    public void _addContainerListener() {
        boolean bResult = true;
        this.oObj.addContainerListener(this.listener);
        bResult &= this.performChanges();
        if (this.NC != null) {
            bResult &= this.bElementReplaced;
        }
        if (this.NR == null) {
            bResult &= this.bElementRemoved;
        }
        if (this.NR == null) {
            bResult &= this.bElementInserted;
        }
        if (!bResult) {
            this.log.println("inserted was " + (this.bElementInserted ? "" : "NOT") + " called.");
            if (this.NC != null) {
                this.log.println("replaced was " + (this.bElementReplaced ? "" : "NOT") + " called.");
            }
            this.log.println("removed was " + (this.bElementRemoved ? "" : "NOT") + " called.");
        }
        this.tRes.tested("addContainerListener()", bResult);
    }

    public void _removeContainerListener() {
        this.requiredMethod("addContainerListener()");
        boolean bResult = true;
        this.bElementInserted = false;
        this.bElementRemoved = false;
        this.bElementReplaced = false;
        this.oObj.removeContainerListener(this.listener);
        bResult &= this.performChanges();
        bResult &= !this.bElementReplaced;
        bResult &= !this.bElementRemoved;
        this.tRes.tested("removeContainerListener()", bResult &= !this.bElementInserted);
    }

    protected boolean performChanges() {
        if (this.CC != null) {
            return this.performChanges2();
        }
        if (this.NV != null) {
            return this.performChanges3();
        }
        if (this.NR != null) {
            return this.performChanges4();
        }
        boolean bResult = true;
        try {
            String[] names = this.NC.getElementNames();
            this.log.println("Elements count = " + names.length);
            this.NC.insertByName("XContainer_dummy", this.inst);
            names = this.NC.getElementNames();
            this.log.println("Elements count = " + names.length);
            if (this.inst2 == null) {
                this.NC.replaceByName("XContainer_dummy", this.inst);
            } else {
                this.NC.replaceByName("XContainer_dummy", this.inst2);
            }
            this.NC.removeByName("XContainer_dummy");
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured ");
            ex.printStackTrace(this.log);
            bResult = false;
        }
        catch (WrappedTargetException ex) {
            this.log.println("Exception occured ");
            ex.printStackTrace(this.log);
            bResult = false;
        }
        catch (NoSuchElementException ex) {
            this.log.println("Exception occured ");
            ex.printStackTrace(this.log);
            bResult = false;
        }
        catch (ElementExistException ex) {
            this.log.println("Exception occured ");
            ex.printStackTrace(this.log);
            bResult = false;
        }
        return bResult;
    }

    protected boolean performChanges2() {
        int precount = this.CC.getControls().length;
        this.CC.addControl("NewControl", (XControl)this.inst);
        this.shortWait();
        int count = this.CC.getControls().length;
        this.CC.removeControl(this.CC.getControl("NewControl"));
        this.shortWait();
        return count > precount;
    }

    protected boolean performChanges3() {
        boolean res = true;
        Object reg = null;
        try {
            reg = this.NV.getRegisteredObject("MyFactory");
            this.NV.revokeObject("MyFactory");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.NV.registerObject("MyFactory", this.inst);
            reg = this.NV.getRegisteredObject("MyFactory");
            res &= reg != null;
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
            this.log.println("registerObject failed");
            res &= false;
        }
        try {
            this.NV.revokeObject("MyFactory");
            reg = this.NV.getRegisteredObject("MyFactory");
            this.log.println("revokeObject failed");
            res &= false;
        }
        catch (Exception e) {
            res &= true;
        }
        return res;
    }

    protected boolean performChanges4() {
        boolean res = true;
        Object newValue = this.inst2;
        Object originalValue = null;
        String name = null;
        try {
            name = (String)this.inst;
        }
        catch (ClassCastException e) {
            this.log.write("Expected String as object relations 'XContainer.ElementName'.");
            e.printStackTrace(this.log);
            return false;
        }
        try {
            originalValue = this.NR.getByName(name);
            this.NR.replaceByName(name, newValue);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
            res = false;
        }
        try {
            this.NR.replaceByName(name, originalValue);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
            res = false;
        }
        return res;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class MyListener
    implements XContainerListener {
        @Override
        public void elementInserted(ContainerEvent e) {
            _XContainer.this.bElementInserted = true;
        }

        @Override
        public void elementRemoved(ContainerEvent e) {
            _XContainer.this.bElementRemoved = true;
        }

        @Override
        public void elementReplaced(ContainerEvent e) {
            _XContainer.this.bElementReplaced = true;
        }

        @Override
        public void disposing(EventObject obj) {
        }
    }
}

