/*
 * Decompiled with CFR 0.152.
 */
package ifc.connection;

import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XConnector
extends MultiMethodTest {
    public XConnector oObj = null;
    protected String connectString = null;

    @Override
    public void before() throws StatusException {
        this.connectString = (String)this.tEnv.getObjRelation("XConnector.connectStr");
        if (this.connectString == null) {
            throw new StatusException("No object relation found", new NullPointerException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _connect() {
        boolean result = true;
        AcceptorThread acceptorThread = null;
        XAcceptor xAcceptor = null;
        XConnection aCon = null;
        XInterface x = null;
        try {
            x = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Acceptor");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't create service", e);
        }
        xAcceptor = UnoRuntime.queryInterface(XAcceptor.class, (Object)x);
        acceptorThread = new AcceptorThread(xAcceptor);
        acceptorThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            aCon = this.oObj.connect(this.connectString);
            if (aCon == null) {
                this.log.println("Connector returned: null");
            } else {
                this.log.println("Connector returned: " + aCon.getDescription());
            }
            try {
                acceptorThread.join(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (acceptorThread.isAlive()) {
                result = false;
                this.log.println("Method call hasn't returned");
                if (acceptorThread.acceptedCall == null) {
                    this.log.println("Acceptor returned : null");
                } else {
                    this.log.println("Acceptor returned : " + acceptorThread.acceptedCall.getDescription());
                }
            } else {
                if (acceptorThread.ex != null) {
                    this.log.println("Exception occured in accept() thread :");
                    acceptorThread.ex.printStackTrace(this.log);
                }
                if (acceptorThread.acceptedCall == null) {
                    this.log.println("Method returned : null");
                } else {
                    this.log.println("Method returned : " + acceptorThread.acceptedCall.getDescription());
                }
                result &= acceptorThread.acceptedCall != null;
            }
        }
        catch (ConnectionSetupException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (NoConnectException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        finally {
            acceptorThread.acc.stopAccepting();
            if (acceptorThread.isAlive()) {
                acceptorThread.interrupt();
            }
        }
        this.tRes.tested("connect()", result);
    }

    protected class AcceptorThread
    extends Thread {
        private XAcceptor acc = null;
        public Exception ex = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor acc) {
            this.acc = acc;
        }

        @Override
        public void run() {
            try {
                this.acceptedCall = this.acc.accept(_XConnector.this.connectString);
            }
            catch (IllegalArgumentException e) {
                this.ex = e;
            }
            catch (ConnectionSetupException e) {
                this.ex = e;
            }
            catch (AlreadyAcceptingException e) {
                this.ex = e;
            }
        }
    }
}

