/*
 * Decompiled with CFR 0.152.
 */
package ifc.connection;

import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XAcceptor
extends MultiMethodTest {
    protected PrintWriter log_;
    public XAcceptor oObj = null;
    protected String connectString = null;

    @Override
    public void before() throws StatusException {
        this.connectString = (String)this.tEnv.getObjRelation("XAcceptor.connectStr");
        this.log_ = this.log;
        if (this.connectString == null) {
            throw new StatusException("No object relation found", new NullPointerException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _accept() {
        boolean result;
        block38: {
            result = true;
            AcceptorThread acception = null;
            AcceptorThread dupAcception = null;
            XAcceptor dupAcceptor = null;
            XConnector xConnector = null;
            try {
                Object oConnector = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Connector");
                xConnector = UnoRuntime.queryInterface(XConnector.class, oConnector);
                XInterface acceptor = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Acceptor");
                dupAcceptor = UnoRuntime.queryInterface(XAcceptor.class, (Object)acceptor);
            }
            catch (com.sun.star.uno.Exception e) {
                e.printStackTrace(this.log);
                throw new StatusException("Can't create service", e);
            }
            try {
                acception = new AcceptorThread(this.oObj);
                acception.start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                XConnection con = xConnector.connect(this.connectString);
                if (con == null) {
                    this.log.println("Connector returned : null");
                } else {
                    this.log.println("Connector returned : " + con.getDescription());
                }
                try {
                    acception.join(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (acception.isAlive()) {
                    result = false;
                    this.log.println("Method call haven't returned");
                    if (acception.acceptedCall == null) {
                        this.log.println("Acceptor returned : null");
                    } else {
                        this.log.println("Acceptor returned : " + acception.acceptedCall.getDescription());
                    }
                } else {
                    if (acception.ex != null) {
                        this.log.println("Exception occured in accept() thread :");
                        acception.ex.printStackTrace(this.log);
                    }
                    if (acception.acceptedCall == null) {
                        this.log.println("Method returned : null");
                    } else {
                        this.log.println("Method returned : " + acception.acceptedCall.getDescription());
                    }
                    result &= acception.acceptedCall != null;
                }
            }
            catch (ConnectionSetupException e) {
                e.printStackTrace(this.log);
                result = false;
            }
            catch (NoConnectException e) {
                e.printStackTrace(this.log);
                result = false;
            }
            finally {
                this.oObj.stopAccepting();
                if (acception.isAlive()) {
                    acception.interrupt();
                }
            }
            this.log.println("___ Testing for accepting on the same port ...");
            try {
                dupAcception = new AcceptorThread(dupAcceptor);
                dupAcception.start();
                try {
                    dupAcception.join(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!dupAcception.isAlive()) break block38;
                this.log.println("Duplicate acceptor is listening ...");
                acception = new AcceptorThread(this.oObj);
                acception.start();
                try {
                    acception.join(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (acception.isAlive()) {
                    this.oObj.stopAccepting();
                    acception.interrupt();
                    this.log.println("Acceptor with the same port must cause an error but didn't");
                    result = false;
                } else {
                    this.log.println("Accepted call = " + acception.acceptedCall);
                    if (acception.ex == null) {
                        this.log.println("No exception was thrown when trying to listen on the same port");
                    } else if (acception.ex instanceof AlreadyAcceptingException || acception.ex instanceof ConnectionSetupException) {
                        this.log.println("Rigth exception was thrown when trying to listen on the same port");
                    } else {
                        result = false;
                        this.log.println("Wrong exception was thrown when trying to listen on the same port :");
                        acception.ex.printStackTrace(this.log);
                    }
                }
            }
            finally {
                dupAcceptor.stopAccepting();
                if (dupAcception.isAlive()) {
                    dupAcception.interrupt();
                }
            }
        }
        this.tRes.tested("accept()", result);
    }

    public void _stopAccepting() {
        boolean result = true;
        AcceptorThread acception = new AcceptorThread(this.oObj);
        acception.start();
        this.oObj.stopAccepting();
        try {
            acception.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (acception.isAlive()) {
            acception.interrupt();
            result = false;
            this.log.println("Method call haven't returned");
        } else {
            if (acception.ex != null) {
                this.log.println("Exception occured in accept() thread :");
                acception.ex.printStackTrace(this.log);
                result = false;
            } else {
                result = true;
            }
            if (acception.acceptedCall == null) {
                this.log.println("accept() returned : null");
            } else {
                this.log.println("accept() returned : " + acception.acceptedCall.getDescription());
            }
        }
        this.tRes.tested("stopAccepting()", result);
    }

    protected class AcceptorThread
    extends Thread {
        public Exception ex = null;
        private XAcceptor acc = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor acc) {
            this.acc = acc;
        }

        @Override
        public void run() {
            try {
                this.acceptedCall = this.acc.accept(_XAcceptor.this.connectString);
            }
            catch (IllegalArgumentException e) {
                this.ex = e;
            }
            catch (ConnectionSetupException e) {
                this.ex = e;
            }
            catch (AlreadyAcceptingException e) {
                this.ex = e;
            }
        }
    }
}

