/*
 * Decompiled with CFR 0.152.
 */
package ifc.configuration.backend;

import com.sun.star.configuration.backend.BackendAccessException;
import com.sun.star.configuration.backend.MalformedDataException;
import com.sun.star.configuration.backend.XLayer;
import com.sun.star.configuration.backend.XSingleLayerStratum;
import com.sun.star.configuration.backend.XUpdatableLayer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import util.XLayerHandlerImpl;

public class _XSingleLayerStratum
extends MultiMethodTest {
    public XSingleLayerStratum oObj;

    public void _getLayer() {
        XLayer aLayer;
        String aLayerID = "org.openoffice.Office.Common";
        boolean res = true;
        try {
            aLayer = this.oObj.getLayer("", "");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("expected Exception -- OK");
        }
        try {
            aLayer = this.oObj.getLayer(aLayerID, "");
            res &= aLayer != null;
            if (aLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            res &= this.checkLayer(aLayer);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getLayer()", res);
    }

    public void _getUpdatableLayer() {
        XUpdatableLayer aLayer;
        String aLayerID = "org.openoffice.Office.Common";
        boolean res = true;
        try {
            aLayer = this.oObj.getUpdatableLayer("");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("expected Exception -- OK");
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        try {
            aLayer = this.oObj.getUpdatableLayer(aLayerID);
            res &= aLayer != null;
            if (aLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            res &= this.checkLayer(aLayer);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getUpdatableLayer()", res);
    }

    protected boolean checkLayer(XLayer aLayer) {
        boolean res = false;
        this.log.println("Checking for Exception in case of null argument");
        try {
            aLayer.readData(null);
        }
        catch (NullPointerException e) {
            this.log.println("Expected Exception -- OK");
            res = true;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        this.log.println("checking read data with own XLayerHandler implementation");
        try {
            XLayerHandlerImpl xLayerHandler = new XLayerHandlerImpl();
            aLayer.readData(xLayerHandler);
            String implCalled = xLayerHandler.getCalls();
            this.log.println(implCalled);
            int sl = implCalled.indexOf("startLayer");
            if (sl < 0) {
                this.log.println("startLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("startLayer was called -- OK");
                res &= true;
            }
            int el = implCalled.indexOf("endLayer");
            if (el < 0) {
                this.log.println("endLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("endLayer was called -- OK");
                res &= true;
            }
        }
        catch (NullPointerException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        return res;
    }
}

