/*
 * Decompiled with CFR 0.152.
 */
package ifc.configuration.backend;

import com.sun.star.configuration.backend.BackendAccessException;
import com.sun.star.configuration.backend.MalformedDataException;
import com.sun.star.configuration.backend.XSchema;
import com.sun.star.configuration.backend.XSchemaSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import util.XSchemaHandlerImpl;

public class _XSchemaSupplier
extends MultiMethodTest {
    public XSchemaSupplier oObj;

    public void _getComponentSchema() {
        boolean res = true;
        XSchema aSchema = null;
        try {
            aSchema = this.oObj.getComponentSchema("org.openoffice.Office.Linguistic");
            res &= aSchema != null;
            if (aSchema == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            res &= this.checkSchema(aSchema);
        }
        catch (BackendAccessException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        this.tRes.tested("getComponentSchema()", res);
    }

    protected boolean checkSchema(XSchema aSchema) {
        boolean res = false;
        XSchemaHandlerImpl xSchemaHandlerImpl = new XSchemaHandlerImpl();
        this.log.println("Checking for Exception in case of null argument");
        try {
            aSchema.readTemplates(null);
            this.log.println("NoException thrown for null argument -- FAILED");
        }
        catch (NullPointerException e) {
            this.log.println("Expected Exception -- OK");
            res = true;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        this.log.println("checking readComponent with own XSchemaHandler implementation");
        try {
            aSchema.readComponent(xSchemaHandlerImpl);
            String implCalled = xSchemaHandlerImpl.getCalls();
            int sc = implCalled.indexOf("startComponent");
            if (sc < 0) {
                this.log.println("startComponent wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("startComponent was called -- OK");
                res &= true;
            }
            int ec = implCalled.indexOf("endComponent");
            if (ec < 0) {
                this.log.println("endComponent wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("endComponent was called -- OK");
                res &= true;
            }
        }
        catch (NullPointerException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        return res;
    }
}

