/*
 * Decompiled with CFR 0.152.
 */
package ifc.configuration.backend;

import com.sun.star.configuration.backend.BackendAccessException;
import com.sun.star.configuration.backend.MalformedDataException;
import com.sun.star.configuration.backend.XLayer;
import com.sun.star.configuration.backend.XMultiLayerStratum;
import com.sun.star.configuration.backend.XUpdatableLayer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import lib.MultiMethodTest;
import util.XLayerHandlerImpl;
import util.utils;

public class _XMultiLayerStratum
extends MultiMethodTest {
    public XMultiLayerStratum oObj;
    protected String aLayerID;

    public void _getLayer() {
        XLayer aLayer;
        boolean res = true;
        try {
            aLayer = this.oObj.getLayer("", "");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("expected Exception -- OK");
        }
        try {
            aLayer = this.oObj.getLayer(this.aLayerID, "");
            res &= aLayer != null;
            if (aLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            res &= this.checkLayer(aLayer);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getLayer()", res);
    }

    public void _getLayers() {
        boolean res = true;
        try {
            String[] LayerIds = new String[]{"1 /org/openoffice/Office/Jobs.xcu", "2 /org/openoffice/Office/Linguistic.xcu"};
            XLayer[] Layers = this.oObj.getLayers(LayerIds, "");
            res = Layers.length == 2;
            this.log.println("Getting two XLayers -- OK");
            this.log.println("Checking first on " + LayerIds[0]);
            res &= this.checkLayer(Layers[0]);
            this.log.println("Checking second on " + LayerIds[1]);
            res &= this.checkLayer(Layers[1]);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getLayers()", res);
    }

    public void _getMultipleLayers() {
        boolean res = true;
        try {
            String[] LayerIds = new String[]{"1 /org/openoffice/Office/Jobs.xcu", "2 /org/openoffice/Office/Linguistic.xcu"};
            String[] Times = new String[]{"", ""};
            XLayer[] Layers = this.oObj.getMultipleLayers(LayerIds, Times);
            res = Layers.length == 2;
            this.log.println("Getting two XLayers -- OK");
            this.log.println("Checking first on " + LayerIds[0]);
            res &= this.checkLayer(Layers[0]);
            this.log.println("Checking second on " + LayerIds[1]);
            res &= this.checkLayer(Layers[1]);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getMultipleLayers()", res);
    }

    public void _getUpdatableLayer() {
        XUpdatableLayer aLayer;
        boolean res = true;
        try {
            aLayer = this.oObj.getUpdatableLayer("");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("expected Exception -- OK");
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        try {
            aLayer = this.oObj.getUpdatableLayer(this.aLayerID);
            res &= aLayer != null;
            if (aLayer == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
            res &= this.checkLayer(aLayer);
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getUpdatableLayer()", res);
    }

    public void _getUpdateLayerId() {
        boolean res = true;
        try {
            String UpdateLayerID = this.oObj.getUpdateLayerId("org.openoffice.Office.TypeDetection", "illegal");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("expected Exception -- OK");
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        try {
            String ent = utils.getOfficeURL((XMultiServiceFactory)this.tParam.getMSF()) + "/../share/registry";
            String UpdateLayerID = this.oObj.getUpdateLayerId("org.openoffice.Office.Linguistic", ent);
            res &= UpdateLayerID.endsWith("Linguistic.xcu");
            if (!UpdateLayerID.endsWith("Linguistic.xcu")) {
                this.log.println("\tExpected the id to end with Linguistic.xcu");
                this.log.println("\tBut got " + UpdateLayerID);
                this.log.println("\t=> FAILED");
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("getUpdateLayerId()", res);
    }

    public void _listLayerIds() {
        boolean res = true;
        try {
            String[] LayerIDs = this.oObj.listLayerIds("org.openoffice.Office.TypeDetection", "illegal");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("expected Exception -- OK");
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        try {
            String ent = utils.getOfficeURL((XMultiServiceFactory)this.tParam.getMSF()) + "/../share/registry";
            String[] LayerIDs = this.oObj.listLayerIds("org.openoffice.Office.Jobs", ent);
            res &= LayerIDs[0].endsWith("Jobs.xcu");
            this.aLayerID = LayerIDs[0];
            if (!LayerIDs[0].endsWith("Jobs.xcu")) {
                this.log.println("\tExpected the id to end with Jobs.xcu");
                this.log.println("\tBut got " + LayerIDs[0]);
                this.log.println("\t=> FAILED");
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        this.tRes.tested("listLayerIds()", res);
    }

    protected boolean checkLayer(XLayer aLayer) {
        boolean res = false;
        this.log.println("Checking for Exception in case of null argument");
        try {
            aLayer.readData(null);
        }
        catch (NullPointerException e) {
            this.log.println("Expected Exception -- OK");
            res = true;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        this.log.println("checking read data with own XLayerHandler implementation");
        try {
            XLayerHandlerImpl xLayerHandler = new XLayerHandlerImpl();
            aLayer.readData(xLayerHandler);
            String implCalled = xLayerHandler.getCalls();
            this.log.println(implCalled);
            int sl = implCalled.indexOf("startLayer");
            if (sl < 0) {
                this.log.println("startLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("startLayer was called -- OK");
                res &= true;
            }
            int el = implCalled.indexOf("endLayer");
            if (el < 0) {
                this.log.println("endLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("endLayer was called -- OK");
                res &= true;
            }
        }
        catch (NullPointerException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        return res;
    }
}

