/*
 * Decompiled with CFR 0.152.
 */
package ifc.configuration.backend;

import com.sun.star.configuration.backend.BackendAccessException;
import com.sun.star.configuration.backend.MalformedDataException;
import com.sun.star.configuration.backend.XBackend;
import com.sun.star.configuration.backend.XLayer;
import com.sun.star.configuration.backend.XUpdateHandler;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XStringSubstitution;
import lib.MultiMethodTest;
import util.XLayerHandlerImpl;

public class _XBackend
extends MultiMethodTest {
    public XBackend oObj;

    public void _getOwnUpdateHandler() {
        boolean res = true;
        String noUpdate = (String)this.tEnv.getObjRelation("noUpdate");
        if (noUpdate != null) {
            this.log.println(noUpdate);
            this.tRes.tested("getOwnUpdateHandler()", res);
            return;
        }
        try {
            XUpdateHandler aHandler = this.oObj.getOwnUpdateHandler("org.openoffice.Office.Linguistic");
            res &= aHandler != null;
            if (aHandler == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        this.tRes.tested("getOwnUpdateHandler()", res);
    }

    public void _getUpdateHandler() {
        boolean res = true;
        String noUpdate = (String)this.tEnv.getObjRelation("noUpdate");
        if (noUpdate != null) {
            this.log.println(noUpdate);
            this.tRes.tested("getUpdateHandler()", res);
            return;
        }
        try {
            XUpdateHandler aHandler = this.oObj.getUpdateHandler("org.openoffice.Office.TypeDetection", "illegal");
            this.log.println("Exception expected -- FAILED");
            res = false;
        }
        catch (BackendAccessException e) {
            this.log.println("expected Exception -- OK");
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        try {
            XStringSubstitution sts = _XBackend.createStringSubstitution((XMultiServiceFactory)this.tParam.getMSF());
            String ent = sts.getSubstituteVariableValue("$(inst)") + "/share/registry";
            XUpdateHandler aHandler = this.oObj.getUpdateHandler("org.openoffice.Office.Jobs", ent);
            if (aHandler == null) {
                this.log.println("\treturned Layer is NULL -- FAILED");
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception -- FAILED");
            res = false;
        }
        catch (NoSupportException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (NoSuchElementException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        this.tRes.tested("getUpdateHandler()", res);
    }

    public void _listLayers() {
        boolean res = true;
        try {
            XStringSubstitution sts = _XBackend.createStringSubstitution((XMultiServiceFactory)this.tParam.getMSF());
            String ent = sts.getSubstituteVariableValue("$(inst)") + "/share/registry";
            XLayer[] Layers = this.oObj.listLayers("org.openoffice.Office.Linguistic", ent);
            for (int i = 0; i < Layers.length; ++i) {
                this.log.println("Checking Layer " + i);
                res &= this.checkLayer(Layers[i]);
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (NoSuchElementException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        this.tRes.tested("listLayers()", res);
    }

    public void _listOwnLayers() {
        boolean res = true;
        try {
            XLayer[] Layers = this.oObj.listOwnLayers("org.openoffice.Office.Common");
            for (int i = 0; i < Layers.length; ++i) {
                this.log.println("Checking Layer " + i);
                res &= this.checkLayer(Layers[i]);
            }
            if (Layers.length == 0) {
                System.out.println("No Layers found -- FAILED");
                res &= false;
            }
        }
        catch (BackendAccessException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("unexpected Exception " + e + " -- FAILED");
            res = false;
        }
        this.tRes.tested("listOwnLayers()", res);
    }

    protected boolean checkLayer(XLayer aLayer) {
        boolean res = false;
        this.log.println("Checking for Exception in case of null argument");
        try {
            aLayer.readData(null);
        }
        catch (NullPointerException e) {
            this.log.println("Expected Exception -- OK");
            res = true;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
        }
        this.log.println("checking read data with own XLayerHandler implementation");
        try {
            XLayerHandlerImpl xLayerHandler = new XLayerHandlerImpl();
            aLayer.readData(xLayerHandler);
            String implCalled = xLayerHandler.getCalls();
            this.log.println(implCalled);
            int sl = implCalled.indexOf("startLayer");
            if (sl < 0) {
                this.log.println("startLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("startLayer was called -- OK");
                res &= true;
            }
            int el = implCalled.indexOf("endLayer");
            if (el < 0) {
                this.log.println("endLayer wasn't called -- FAILED");
                res &= false;
            } else {
                this.log.println("endLayer was called -- OK");
                res &= true;
            }
        }
        catch (NullPointerException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        catch (MalformedDataException e) {
            this.log.println("Unexpected Exception (" + e + ") -- FAILED");
            res &= false;
        }
        return res;
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMSF) {
        Object xPathSubst = null;
        try {
            xPathSubst = xMSF.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (xPathSubst != null) {
            return UnoRuntime.queryInterface(XStringSubstitution.class, xPathSubst);
        }
        return null;
    }
}

