/*
 * Decompiled with CFR 0.152.
 */
package ifc.bridge;

import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;
import util.utils;

public class _XUnoUrlResolver
extends MultiMethodTest {
    static int basePort = 0;
    int curPort = 0;
    public XUnoUrlResolver oObj;

    public void _resolve() {
        String connectStr = (String)this.tParam.get("CNCSTR");
        int pIndex = connectStr.indexOf("port=") + 5;
        connectStr = connectStr.substring(0, pIndex);
        System.out.println("ConnectString: " + connectStr);
        basePort = (Integer)this.tEnv.getObjRelation("PORT");
        this.curPort = utils.getNextFreePort(basePort);
        this.log.println("Choose Port nr: " + this.curPort);
        connectStr = connectStr + this.curPort;
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)this.tParam.getMSF();
            XBridgeFactory xBrdgFctr = UnoRuntime.queryInterface(XBridgeFactory.class, this.tEnv.getObjRelation("BRIDGEFACTORY"));
            XAcceptor xAcc = UnoRuntime.queryInterface(XAcceptor.class, this.tEnv.getObjRelation("ACCEPTOR"));
            MyInstanceProvider xInstProv = new MyInstanceProvider(xMSF);
            BridgeThread brThread = new BridgeThread(xAcc, xBrdgFctr, xInstProv, connectStr);
            brThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Object obj = this.oObj.resolve("uno:" + connectStr + ";urp;com.sun.star.lang.ServiceManager");
            XMultiServiceFactory oMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, obj);
            if (brThread.isAlive()) {
                brThread.interrupt();
            }
            this.tRes.tested("resolve()", oMSF != null);
        }
        catch (NoConnectException e) {
            this.log.println("Unexpected exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        catch (ConnectionSetupException e) {
            this.log.println("Unexpected exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        catch (IllegalArgumentException e) {
            this.log.println("Unexpected exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
    }

    class BridgeThread
    extends Thread {
        private XBridgeFactory xBrdgFctr = null;
        private XInstanceProvider xInstProv = null;
        private XAcceptor xAcc = null;
        private String connectString = null;
        public XBridge xBridge = null;

        public BridgeThread(XAcceptor xAcc, XBridgeFactory xBrdgFctr, XInstanceProvider xInstProv, String connectString) {
            this.xInstProv = xInstProv;
            this.xBrdgFctr = xBrdgFctr;
            this.xAcc = xAcc;
            this.connectString = connectString;
        }

        @Override
        public void run() {
            try {
                XConnection xCon = this.xAcc.accept(this.connectString);
                this.xBridge = this.xBrdgFctr.createBridge("MyBridge", "urp", xCon, this.xInstProv);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (ConnectionSetupException e) {
                e.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (AlreadyAcceptingException e) {
                e.printStackTrace(_XUnoUrlResolver.this.log);
            }
            catch (BridgeExistsException e) {
                e.printStackTrace(_XUnoUrlResolver.this.log);
            }
        }
    }

    class MyInstanceProvider
    implements XInstanceProvider {
        private XMultiServiceFactory xMSF = null;

        public MyInstanceProvider(XMultiServiceFactory xMSF) {
            this.xMSF = xMSF;
        }

        @Override
        public Object getInstance(String aInstanceName) throws NoSuchElementException {
            try {
                return this.xMSF.createInstance(aInstanceName);
            }
            catch (Exception e) {
                throw new StatusException("Unexpected exception", e);
            }
        }
    }
}

