/*
 * Decompiled with CFR 0.152.
 */
package ifc.bridge;

import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XBridgeFactory
extends MultiMethodTest {
    public XBridgeFactory oObj = null;
    private String bridgeName = null;
    AcceptorThread acceptorThread = null;
    public static int uniqueSuffix = 0;
    public static Object synchFlag = new Object();
    public String connectString;

    @Override
    protected void after() {
        this.acceptorThread.acc.stopAccepting();
        if (this.acceptorThread.isAlive()) {
            this.acceptorThread.interrupt();
        }
    }

    public void _getExistingBridges() {
        XBridge[] bridges = this.oObj.getExistingBridges();
        this.log.println("Existing bridges :");
        for (int i = 0; i < bridges.length; ++i) {
            this.log.println("  " + bridges[i].getDescription());
        }
        if (bridges.length > 0) {
            this.bridgeName = bridges[0].getName();
        }
        this.tRes.tested("getExistingBridges()", bridges != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _createBridge() {
        XBridge bridge = null;
        XConnection conn = null;
        boolean result = false;
        try {
            XInterface x = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Connector");
            XConnector xCntr = UnoRuntime.queryInterface(XConnector.class, (Object)x);
            x = (XInterface)((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.connection.Acceptor");
            XAcceptor xAccptr = UnoRuntime.queryInterface(XAcceptor.class, (Object)x);
            this.connectString = (String)this.tEnv.getObjRelation("CNNCTSTR");
            this.acceptorThread = new AcceptorThread(xAccptr);
            this.acceptorThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            conn = xCntr.connect(this.connectString);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't create connection", e);
        }
        try {
            String brName;
            String protocol = (String)this.tParam.get("PROTOCOL");
            if (protocol == null) {
                protocol = "urp";
            }
            Object object = synchFlag;
            synchronized (object) {
                brName = "MyBridge" + uniqueSuffix++;
            }
            this.log.println("Creating bridge with name " + brName);
            bridge = this.oObj.createBridge(brName, protocol, conn, null);
            result = bridge != null;
        }
        catch (BridgeExistsException e) {
            this.log.println("Exception while bridge creating :" + e);
        }
        catch (IllegalArgumentException e) {
            this.log.println("Exception while bridge creating :" + e);
        }
        this.tRes.tested("createBridge()", result);
    }

    public void _getBridge() {
        this.executeMethod("getExistingBridges()");
        if (this.bridgeName == null) {
            this.log.println("No name for getting the bridge");
            return;
        }
        XBridge br = this.oObj.getBridge(this.bridgeName);
        this.tRes.tested("getBridge()", br != null && this.bridgeName.equals(br.getName()));
    }

    protected class AcceptorThread
    extends Thread {
        private XAcceptor acc = null;
        public Exception ex = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor acc) {
            this.acc = acc;
        }

        @Override
        public void run() {
            try {
                this.acceptedCall = this.acc.accept(_XBridgeFactory.this.connectString);
            }
            catch (IllegalArgumentException e) {
                this.ex = e;
            }
            catch (ConnectionSetupException e) {
                this.ex = e;
            }
            catch (AlreadyAcceptingException e) {
                this.ex = e;
            }
        }
    }
}

