/*
 * Decompiled with CFR 0.152.
 */
package ifc.bridge;

import com.sun.star.bridge.XBridge;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.XInitialization;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XBridge
extends MultiMethodTest {
    public XBridge oObj;
    protected Object[] args;

    @Override
    public void before() {
        this.args = (Object[])this.tEnv.getObjRelation("XInitialization.args");
        if (this.args == null) {
            throw new StatusException(Status.failed("Relation 'XInitialization.args' not found"));
        }
        XInitialization xInit = UnoRuntime.queryInterface(XInitialization.class, (Object)this.oObj);
        try {
            xInit.initialize(this.args);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
            throw new StatusException("Can't initialize the bridge", e);
        }
    }

    public void _getInstance() {
        XInterface xInt = (XInterface)this.oObj.getInstance("com.sun.star.lang.ServiceManager");
        this.tRes.tested("getInstance()", xInt != null);
    }

    public void _getName() {
        String expectedName = (String)this.args[0];
        String name = this.oObj.getName();
        if (!this.tRes.tested("getName()", name.equals(expectedName))) {
            this.log.println("getName() returns wrong result : \"" + name + "\"");
            this.log.println("expected = \"" + expectedName + "\"");
        }
    }

    public void _getDescription() {
        String protocol = (String)this.args[1];
        XConnection xConnection = (XConnection)this.args[2];
        String expectedDescription = protocol + ":" + xConnection.getDescription();
        String description = this.oObj.getDescription();
        if (!this.tRes.tested("getDescription()", description.equals(expectedDescription))) {
            this.log.println("getDescription() returns wrong result : \"" + description + "\"");
            this.log.println("expected = \"" + expectedDescription + "\"");
        }
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

