/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.GetDirectPropertyTolerantResult;
import com.sun.star.beans.GetPropertyTolerantResult;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.SetPropertyTolerantFailed;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.beans.XTolerantMultiPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.Collections;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueChanger;
import util.ValueComparer;

public class _XTolerantMultiPropertySet
extends MultiMethodTest {
    public XTolerantMultiPropertySet oObj;
    protected String[] namesOfDirectProperties = null;
    protected String[] namesOfProperties = null;
    protected Object[] valuesOfProperties = null;
    protected Property[] properties = null;
    protected XPropertyState pState = null;
    protected XPropertySet PS = null;

    @Override
    public void before() {
        this.PS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.tEnv.getTestObject());
        if (this.PS == null) {
            throw new StatusException(Status.failed("Component doesn't provide the needed XPropertySet"));
        }
        this.pState = UnoRuntime.queryInterface(XPropertyState.class, (Object)this.tEnv.getTestObject());
        if (this.pState == null) {
            throw new StatusException(Status.failed("Component doesn't provide the needed XPropertyState"));
        }
        this.properties = this.PS.getPropertySetInfo().getProperties();
        this.namesOfProperties = this.getProperties();
        this.valuesOfProperties = this.getPropertyValues(this.namesOfProperties);
    }

    public void _getDirectPropertyValuesTolerant() {
        boolean res;
        this.namesOfDirectProperties = this.getDirectProperties(this.properties);
        GetDirectPropertyTolerantResult[] GDPR = this.oObj.getDirectPropertyValuesTolerant(this.namesOfProperties);
        boolean bl = res = GDPR.length == this.namesOfDirectProperties.length;
        if (!res) {
            int i;
            this.log.println("Found: ");
            for (i = 0; i < GDPR.length; ++i) {
                this.log.println("\t" + GDPR[i].Name);
            }
            this.log.println("Expected: ");
            for (i = 0; i < this.namesOfDirectProperties.length; ++i) {
                this.log.println("\t" + this.namesOfDirectProperties[i]);
            }
        } else {
            for (int i = 0; i < GDPR.length; ++i) {
                boolean localres = GDPR[i].Name.equals(this.namesOfDirectProperties[i]);
                if (!localres) {
                    this.log.println("Found: ");
                    this.log.println("\t" + GDPR[i].Name);
                    this.log.println("Expected: ");
                    this.log.println("\t" + this.namesOfDirectProperties[i]);
                }
                res &= localres;
            }
        }
        this.tRes.tested("getDirectPropertyValuesTolerant()", res);
    }

    public void _getPropertyValuesTolerant() {
        boolean res;
        this.requiredMethod("getDirectPropertyValuesTolerant()");
        GetPropertyTolerantResult[] GPR = this.oObj.getPropertyValuesTolerant(this.namesOfProperties);
        boolean bl = res = GPR.length == this.namesOfProperties.length;
        if (!res) {
            this.log.println("Length of sequences differs");
            this.log.println("Found: " + GPR.length);
            this.log.println("Expected: " + this.namesOfProperties.length);
        } else {
            for (int i = 0; i < GPR.length; ++i) {
                boolean localres = true;
                if (!(GPR[i].Value instanceof Any)) {
                    localres = ValueComparer.equalValue(GPR[i].Value, this.valuesOfProperties[i]);
                }
                if (!localres) {
                    this.log.println("Values differ for : " + this.namesOfProperties[i]);
                    this.log.println("\t" + GPR[i].Value);
                    this.log.println("Expected: ");
                    this.log.println("\t" + this.valuesOfProperties[i]);
                }
                res &= localres;
            }
        }
        this.tRes.tested("getPropertyValuesTolerant()", res);
    }

    public void _setPropertyValuesTolerant() {
        boolean res;
        this.requiredMethod("getPropertyValuesTolerant()");
        SetPropertyTolerantFailed[] SPTF = null;
        try {
            SPTF = this.oObj.setPropertyValuesTolerant(this.namesOfProperties, this.getNewValues(this.valuesOfProperties));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(this.log);
        }
        int failures = 0;
        for (int k = 0; k < SPTF.length; ++k) {
            if (SPTF[k].Result != 3) continue;
            ++failures;
        }
        int roProps = this.getCountOfReadOnlyProperties();
        boolean bl = res = failures == roProps;
        if (!res) {
            this.log.println("Failures: " + failures);
            this.log.println("Count of R/O properties: " + roProps);
            for (int i = 0; i < SPTF.length; ++i) {
                if (SPTF[i].Result != 3) continue;
                ++failures;
                this.log.println("Failed for " + SPTF[i].Name);
                this.log.println("\t Result: " + SPTF[i].Result);
            }
        } else {
            for (int i = 0; i < SPTF.length; ++i) {
                boolean localres = true;
                GetPropertyTolerantResult[] GPR = this.oObj.getPropertyValuesTolerant(this.namesOfProperties);
                if (!(GPR[i].Value instanceof Any) && SPTF[i].Result == 0) {
                    localres = ValueComparer.equalValue(GPR[i].Value, this.valuesOfProperties[i]);
                }
                if (!localres) {
                    this.log.println("Values differ for : " + this.namesOfProperties[i]);
                    this.log.println("\t" + GPR[i].Value);
                    this.log.println("Expected: ");
                    this.log.println("\t" + this.valuesOfProperties[i]);
                }
                res &= localres;
            }
        }
        this.tRes.tested("setPropertyValuesTolerant()", res);
    }

    protected String[] getDirectProperties(Property[] props) {
        ArrayList<String> direct = new ArrayList<String>();
        for (int i = 0; i < props.length; ++i) {
            String pName = props[i].Name;
            try {
                PropertyState state = this.pState.getPropertyState(pName);
                if (!state.equals(PropertyState.DIRECT_VALUE) || !this.isUsable(pName)) continue;
                direct.add(pName);
                continue;
            }
            catch (UnknownPropertyException e) {
                this.log.println("Property '" + pName + "'");
            }
        }
        Collections.sort(direct);
        Object[] obj = direct.toArray();
        String[] ret = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = (String)obj[i];
        }
        return ret;
    }

    private boolean isUsable(String name) {
        boolean isUsable = true;
        if (name.startsWith("TextWriting")) {
            isUsable = false;
        }
        if (name.startsWith("MetaFile")) {
            isUsable = false;
        }
        return isUsable;
    }

    protected String[] getProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.properties.length; ++i) {
            String pName = this.properties[i].Name;
            if (!this.isUsable(pName)) continue;
            names.add(pName);
        }
        Collections.sort(names);
        Object[] obj = names.toArray();
        String[] ret = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ret[i] = (String)obj[i];
        }
        return ret;
    }

    protected Object[] getPropertyValues(String[] propertyNames) {
        Object[] values = new Object[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            try {
                values[i] = this.PS.getPropertyValue(propertyNames[i]);
                continue;
            }
            catch (UnknownPropertyException e) {
                e.printStackTrace(this.log);
                continue;
            }
            catch (WrappedTargetException e) {
                e.printStackTrace(this.log);
            }
        }
        return values;
    }

    protected int getCountOfReadOnlyProperties() {
        int ro = 0;
        for (int i = 0; i < this.properties.length; ++i) {
            boolean isWritable;
            Property property = this.properties[i];
            boolean bl = isWritable = (property.Attributes & 0x10) == 0;
            if (isWritable) continue;
            ++ro;
        }
        return ro;
    }

    protected Object[] getNewValues(Object[] oldValues) {
        Object[] newValues = new Object[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            newValues[i] = oldValues[i] instanceof Any ? oldValues[i] : ValueChanger.changePValue(oldValues[i]);
        }
        return newValues;
    }
}

