/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XPropertyState;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XPropertyState
extends MultiMethodTest {
    public XPropertyState oObj = null;
    private XPropertySet oPS = null;
    private XPropertySetInfo propertySetInfo = null;
    private Property[] properties = null;
    private String pName = null;
    private Object propDef = null;

    @Override
    public void before() throws StatusException {
        this.oPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
        if (this.oPS == null) {
            throw new StatusException("XPropertySet interface isn't implemented.", new NullPointerException("XPropertySet interface isn't implemented."));
        }
        this.propertySetInfo = this.oPS.getPropertySetInfo();
        this.properties = this.propertySetInfo.getProperties();
        Property prop = null;
        for (int i = 0; i < this.properties.length; ++i) {
            boolean maybeDefault;
            try {
                prop = this.propertySetInfo.getPropertyByName(this.properties[i].Name);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Unknown Property " + prop.Name);
            }
            boolean readOnly = (prop.Attributes & 0x10) != 0;
            boolean bl = maybeDefault = (prop.Attributes & 0x40) != 0;
            if (!readOnly && maybeDefault) {
                this.pName = this.properties[i].Name;
                this.log.println("Property '" + this.pName + "' has attributes " + prop.Attributes);
                break;
            }
            if (!readOnly) {
                this.pName = this.properties[i].Name;
                this.log.println("Property '" + this.pName + "' is not readonly, may be used ...");
                continue;
            }
            this.log.println("Skipping property '" + this.properties[i].Name + "' Readonly: " + readOnly + ", MaybeDefault: " + maybeDefault);
        }
    }

    public void _getPropertyDefault() {
        boolean result = true;
        String localName = this.pName;
        if (localName == null) {
            localName = this.propertySetInfo.getProperties()[0].Name;
        }
        try {
            this.propDef = this.oObj.getPropertyDefault(localName);
            this.log.println("Default property value is : '" + this.propDef + "'");
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception " + e + "occured while getting Property default");
            result = false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception " + e + "occured while getting Property default");
            result = false;
        }
        this.tRes.tested("getPropertyDefault()", result);
    }

    public void _getPropertyState() {
        boolean result = true;
        String localName = this.pName;
        if (localName == null) {
            localName = this.propertySetInfo.getProperties()[0].Name;
        }
        try {
            PropertyState ps = this.oObj.getPropertyState(localName);
            if (ps == null) {
                this.log.println("!!! Returned value == null");
                result = false;
            }
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception " + e + "occured while getting Property state");
            result = false;
        }
        this.tRes.tested("getPropertyState()", result);
    }

    public void _getPropertyStates() {
        boolean result = true;
        String localName = this.pName;
        if (localName == null) {
            localName = this.propertySetInfo.getProperties()[0].Name;
        }
        try {
            PropertyState[] ps = this.oObj.getPropertyStates(new String[]{localName});
            if (ps == null) {
                this.log.println("!!! Returned value == null");
                result = false;
            } else if (ps.length != 1) {
                this.log.println("!!! Array lebgth returned is invalid - " + ps.length);
                result = false;
            }
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception " + e + "occured while getting Property state");
            result = false;
        }
        this.tRes.tested("getPropertyStates()", result);
    }

    public void _setPropertyToDefault() {
        this.requiredMethod("getPropertyDefault()");
        if (this.pName == null) {
            this.log.println("all found properties are read only");
            this.tRes.tested("setPropertyToDefault()", Status.skipped(true));
            return;
        }
        boolean result = true;
        try {
            try {
                this.oObj.setPropertyToDefault(this.pName);
            }
            catch (RuntimeException e) {
                System.out.println("Ignoring RuntimeException: " + e.getMessage());
            }
            if ((this.properties[0].Attributes & 0x40) != 0) {
                Object actualVal;
                Object actualDef = this.propDef;
                if (this.propDef instanceof Any) {
                    actualDef = ((Any)this.propDef).getObject();
                }
                if ((actualVal = this.oPS.getPropertyValue(this.pName)) instanceof Any) {
                    actualVal = ((Any)actualVal).getObject();
                }
                result = ValueComparer.equalValue(actualDef, actualVal);
                this.log.println("Default value = '" + actualDef + "', returned value = '" + actualVal + "' for property " + this.pName);
            }
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception " + e + "occured while setting Property to default");
            result = false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception " + e + "occured while testing property value");
            result = false;
        }
        this.tRes.tested("setPropertyToDefault()", result);
    }

    @Override
    public void after() {
        this.disposeEnvironment();
    }
}

