/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.RuntimeException;
import java.util.Random;
import java.util.StringTokenizer;
import lib.MultiMethodTest;
import util.ValueChanger;
import util.utils;

public class _XPropertySet
extends MultiMethodTest {
    public XPropertySet oObj = null;
    boolean propertyChanged = false;
    XPropertyChangeListener PClistener = new MyChangeListener();
    boolean vetoableChanged = false;
    XVetoableChangeListener VClistener = new MyVetoListener();
    PropsToTest PTT = new PropsToTest();

    public void _getPropertySetInfo() {
        XPropertySetInfo propertySetInfo = this.oObj.getPropertySetInfo();
        if (propertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            this.tRes.tested("getPropertySetInfo()", true);
            String[] ptt = (String[])this.tEnv.getObjRelation("PTT");
            this.PTT.normal = ptt[0];
            this.PTT.bound = ptt[1];
            this.PTT.constrained = ptt[2];
        } else {
            this.tRes.tested("getPropertySetInfo()", true);
            this.getPropsToTest(propertySetInfo);
        }
    }

    public void _addPropertyChangeListener() {
        this.requiredMethod("getPropertySetInfo()");
        this.propertyChanged = false;
        if (this.PTT.bound.equals("none")) {
            this.log.println("*** No bound properties found ***");
            this.tRes.tested("addPropertyChangeListener()", true);
        } else {
            try {
                this.oObj.addPropertyChangeListener(this.PTT.bound, this.PClistener);
                Object gValue = this.oObj.getPropertyValue(this.PTT.bound);
                this.oObj.setPropertyValue(this.PTT.bound, ValueChanger.changePValue(gValue));
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            this.tRes.tested("addPropertyChangeListener()", this.propertyChanged);
            if (!this.propertyChanged) {
                this.log.println("propertyChangeListener wasn't called for '" + this.PTT.bound + "'");
            }
        }
    }

    public void _addVetoableChangeListener() {
        this.requiredMethod("getPropertySetInfo()");
        this.vetoableChanged = false;
        if (this.PTT.constrained.equals("none")) {
            this.log.println("*** No constrained properties found ***");
            this.tRes.tested("addVetoableChangeListener()", true);
        } else {
            try {
                this.oObj.addVetoableChangeListener(this.PTT.constrained, this.VClistener);
                Object gValue = this.oObj.getPropertyValue(this.PTT.constrained);
                this.oObj.setPropertyValue(this.PTT.constrained, ValueChanger.changePValue(gValue));
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            this.tRes.tested("addVetoableChangeListener()", this.vetoableChanged);
            if (!this.vetoableChanged) {
                this.log.println("vetoableChangeListener wasn't called for '" + this.PTT.constrained + "'");
            }
        }
    }

    public void _setPropertyValue() {
        this.requiredMethod("getPropertySetInfo()");
        Object gValue = null;
        Object sValue = null;
        if (this.PTT.normal.equals("none")) {
            this.log.println("*** No changeable properties found ***");
            this.tRes.tested("setPropertyValue()", true);
        } else {
            try {
                this.log.println("try to cheange value of property '" + this.PTT.normal + "'");
                gValue = this.oObj.getPropertyValue(this.PTT.normal);
                sValue = ValueChanger.changePValue(gValue);
                this.oObj.setPropertyValue(this.PTT.normal, sValue);
                sValue = this.oObj.getPropertyValue(this.PTT.normal);
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.normal + "'");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.normal + "'");
                e.printStackTrace(this.log);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.normal + "'");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.normal + "'");
                e.printStackTrace(this.log);
            }
            this.tRes.tested("setPropertyValue()", !gValue.equals(sValue));
        }
    }

    public void _getPropertyValue() {
        this.requiredMethod("getPropertySetInfo()");
        String toCheck = this.PTT.normal;
        if (this.PTT.normal.equals("none")) {
            toCheck = this.oObj.getPropertySetInfo().getProperties()[0].Name;
            this.log.println("All properties are Read Only");
            this.log.println("Using: " + toCheck);
        }
        try {
            this.oObj.getPropertyValue(toCheck);
            this.tRes.tested("getPropertyValue()", true);
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception occured while trying to get property '" + this.PTT.normal + "'");
            e.printStackTrace(this.log);
            this.tRes.tested("getPropertyValue()", false);
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception occured while trying to get property '" + this.PTT.normal + "'");
            e.printStackTrace(this.log);
            this.tRes.tested("getPropertyValue()", false);
        }
    }

    public void _removePropertyChangeListener() {
        this.requiredMethod("addPropertyChangeListener()");
        this.propertyChanged = false;
        if (this.PTT.bound.equals("none")) {
            this.log.println("*** No bound properties found ***");
            this.tRes.tested("removePropertyChangeListener()", true);
        } else {
            try {
                this.propertyChanged = false;
                this.oObj.removePropertyChangeListener(this.PTT.bound, this.PClistener);
                Object gValue = this.oObj.getPropertyValue(this.PTT.bound);
                this.oObj.setPropertyValue(this.PTT.bound, ValueChanger.changePValue(gValue));
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.bound + "'");
                e.printStackTrace(this.log);
            }
            this.tRes.tested("removePropertyChangeListener()", !this.propertyChanged);
            if (this.propertyChanged) {
                this.log.println("propertyChangeListener was called after removing for '" + this.PTT.bound + "'");
            }
        }
    }

    public void _removeVetoableChangeListener() {
        this.requiredMethod("addVetoableChangeListener()");
        this.vetoableChanged = false;
        if (this.PTT.constrained.equals("none")) {
            this.log.println("*** No constrained properties found ***");
            this.tRes.tested("removeVetoableChangeListener()", true);
        } else {
            try {
                this.oObj.removeVetoableChangeListener(this.PTT.constrained, this.VClistener);
                Object gValue = this.oObj.getPropertyValue(this.PTT.constrained);
                this.oObj.setPropertyValue(this.PTT.constrained, ValueChanger.changePValue(gValue));
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.PTT.constrained + "'");
                e.printStackTrace(this.log);
            }
            this.tRes.tested("removeVetoableChangeListener()", !this.vetoableChanged);
            if (this.vetoableChanged) {
                this.log.println("vetoableChangeListener was called after removing for '" + this.PTT.constrained + "'");
            }
        }
    }

    public PropsToTest getPropsToTest(XPropertySetInfo xPSI) {
        Property[] properties = xPSI.getProperties();
        String bound = "";
        String constrained = "";
        String normal = "";
        String[] skip = new String[]{"PrinterName", "CharRelief", "IsLayerMode"};
        for (int i = 0; i < properties.length; ++i) {
            Property property = properties[i];
            String name = property.Name;
            boolean cont = false;
            for (int j = 0; j < skip.length; ++j) {
                if (!name.equals(skip[j])) continue;
                this.log.println("skipping '" + name + "'");
                cont = true;
            }
            if (cont) continue;
            if (name.equals(this.oObj)) {
                this.log.println("Checking '" + name + "'");
            }
            boolean isWritable = (property.Attributes & 0x10) == 0;
            boolean isNotNull = (property.Attributes & 1) == 0;
            boolean isBound = (property.Attributes & 2) != 0;
            boolean isConstr = (property.Attributes & 4) != 0;
            boolean canChange = false;
            if (!isWritable) {
                this.log.println("Property '" + name + "' is READONLY");
            }
            if (name.endsWith("URL")) {
                isWritable = false;
            }
            if (name.startsWith("Fill")) {
                isWritable = false;
            }
            if (name.startsWith("Font")) {
                isWritable = false;
            }
            if (name.startsWith("IsNumbering")) {
                isWritable = false;
            }
            if (name.startsWith("LayerName")) {
                isWritable = false;
            }
            if (name.startsWith("Line")) {
                isWritable = false;
            }
            if (name.startsWith("TextWriting")) {
                isWritable = false;
            }
            if (isWritable && isNotNull) {
                canChange = this.isChangeable(name);
            }
            if (isWritable && isNotNull && isBound && canChange) {
                bound = bound + name + ";";
            }
            if (isWritable && isNotNull && isConstr && canChange) {
                constrained = constrained + name + ";";
            }
            if (!isWritable || !isNotNull || !canChange) continue;
            normal = normal + name + ";";
        }
        this.PTT.bound = this.getRandomString(bound);
        this.log.println("Bound: " + this.PTT.bound);
        this.PTT.constrained = this.getRandomString(constrained);
        this.log.println("Constrained: " + this.PTT.constrained);
        this.PTT.normal = this.getRandomString(normal);
        return this.PTT;
    }

    public String getRandomString(String str) {
        StringTokenizer ST;
        int nr;
        String gRS = "none";
        Random rnd = new Random();
        if (str.equals("")) {
            str = "none";
        }
        if ((nr = rnd.nextInt((ST = new StringTokenizer(str, ";")).countTokens())) < 1) {
            ++nr;
        }
        for (int i = 1; i < nr + 1; ++i) {
            gRS = ST.nextToken();
        }
        return gRS;
    }

    public boolean isChangeable(String name) {
        boolean hasChanged = false;
        try {
            Object getProp = this.oObj.getPropertyValue(name);
            this.log.println("Getting: " + getProp);
            if (name.equals("xinterfaceA")) {
                System.out.println("drin");
            }
            Object setValue = null;
            if (getProp != null) {
                if (!utils.isVoid(getProp)) {
                    setValue = ValueChanger.changePValue(getProp);
                } else {
                    this.log.println("Property '" + name + "' is void but MAYBEVOID isn't set");
                }
            } else {
                this.log.println("Property '" + name + "'is null and can't be changed");
            }
            if (name.equals("LineStyle")) {
                setValue = null;
            }
            if (setValue != null) {
                this.log.println("Setting to :" + setValue);
                this.oObj.setPropertyValue(name, setValue);
                hasChanged = !getProp.equals(this.oObj.getPropertyValue(name));
            } else {
                this.log.println("Couldn't change Property '" + name + "'");
            }
        }
        catch (PropertyVetoException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        catch (IllegalArgumentException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        catch (UnknownPropertyException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        catch (WrappedTargetException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        catch (RuntimeException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.println("'" + name + "' throws exception '" + e + "'");
            e.printStackTrace(this.log);
        }
        return hasChanged;
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public class PropsToTest {
        String constrained = null;
        String bound = null;
        String normal = null;
    }

    public class MyVetoListener
    implements XVetoableChangeListener {
        @Override
        public void vetoableChange(PropertyChangeEvent e) {
            _XPropertySet.this.vetoableChanged = true;
        }

        @Override
        public void disposing(EventObject obj) {
        }
    }

    public class MyChangeListener
    implements XPropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            _XPropertySet.this.propertyChanged = true;
        }

        @Override
        public void disposing(EventObject obj) {
        }
    }
}

