/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XMultiPropertyStates;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XMultiPropertyStates
extends MultiMethodTest {
    public XMultiPropertyStates oObj = null;
    Object[] defaults = null;
    PropertyState[] states = null;
    String[] names = null;

    @Override
    public void before() {
        this.names = (String[])this.tEnv.getObjRelation("PropertyNames");
        if (this.names == null) {
            throw new StatusException(Status.failed("No PropertyNames given"));
        }
        this.log.println("Totally " + this.names.length + " properties encountered:");
        this.log.print("{");
        for (int i = 0; i < this.names.length; ++i) {
            this.log.print(this.names[i] + " ");
        }
        this.log.print("}");
        this.log.println("");
    }

    public void _getPropertyDefaults() {
        boolean result = false;
        try {
            this.defaults = this.oObj.getPropertyDefaults(this.names);
            result = this.defaults != null && this.defaults.length == this.names.length;
            this.log.println("Number of default values: " + this.defaults.length);
        }
        catch (UnknownPropertyException e) {
            this.log.println("some properties seem to be unknown: " + e.toString());
        }
        catch (WrappedTargetException e) {
            this.log.println("Wrapped target Exception was thrown: " + e.toString());
        }
        this.tRes.tested("getPropertyDefaults()", result);
    }

    public void _getPropertyStates() {
        boolean result = false;
        try {
            this.states = this.oObj.getPropertyStates(this.names);
            result = this.states != null && this.states.length == this.names.length;
            this.log.println("Number of states: " + this.states.length);
        }
        catch (UnknownPropertyException e) {
            this.log.println("some properties seem to be unknown: " + e.toString());
        }
        this.tRes.tested("getPropertyStates()", result);
    }

    public void _setPropertiesToDefault() {
        this.requiredMethod("getPropertyStates()");
        String ro = (String)this.tEnv.getObjRelation("allReadOnly");
        if (ro != null) {
            this.log.println(ro);
            this.tRes.tested("setPropertiesToDefault()", Status.skipped(true));
            return;
        }
        boolean mayBeDef = false;
        String propName = this.names[0];
        for (int i = 0; i < this.names.length; ++i) {
            if (mayBeDef || this.states[i] == PropertyState.DEFAULT_VALUE) continue;
            propName = this.names[i];
            XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
            XPropertySetInfo xPropSetInfo = xPropSet.getPropertySetInfo();
            Property prop = null;
            try {
                prop = xPropSetInfo.getPropertyByName(this.names[i]);
            }
            catch (UnknownPropertyException e) {
                this.log.println("couldn't get property info: " + e.toString());
                throw new StatusException(Status.failed("couldn't get property info"));
            }
            if ((prop.Attributes & 0x40) == 0) continue;
            this.log.println("Property " + this.names[i] + " 'may be default' and doesn't have default value");
            mayBeDef = true;
        }
        this.log.println("The property " + propName + " selected");
        boolean result = false;
        try {
            String[] the_first = new String[]{propName};
            this.log.println("Setting " + propName + " to default");
            this.oObj.setPropertiesToDefault(the_first);
            result = this.oObj.getPropertyStates(the_first)[0].equals(PropertyState.DEFAULT_VALUE);
        }
        catch (UnknownPropertyException e) {
            this.log.println("some properties seem to be unknown: " + e.toString());
        }
        if (!result) {
            this.log.println("The property didn't change its state to default ...");
            if (mayBeDef) {
                this.log.println("   ... and it may be default - FAILED");
            } else {
                this.log.println("   ... but it may not be default - OK");
                result = true;
            }
        }
        this.tRes.tested("setPropertiesToDefault()", result);
    }

    public void _setAllPropertiesToDefault() {
        this.requiredMethod("setPropertiesToDefault()");
        boolean result = true;
        try {
            this.oObj.setAllPropertiesToDefault();
        }
        catch (RuntimeException e) {
            this.log.println("Ignore Runtime Exception: " + e.getMessage());
        }
        this.log.println("Checking that all properties are now in DEFAULT state excepting may be those which 'cann't be default'");
        try {
            this.states = this.oObj.getPropertyStates(this.names);
            for (int i = 0; i < this.states.length; ++i) {
                boolean part_result = this.states[i].equals(PropertyState.DEFAULT_VALUE);
                if (!part_result) {
                    this.log.println("Property '" + this.names[i] + "' wasn't set to default");
                    XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
                    XPropertySetInfo xPropSetInfo = xPropSet.getPropertySetInfo();
                    Property prop = xPropSetInfo.getPropertyByName(this.names[i]);
                    if ((prop.Attributes & 0x40) != 0) {
                        this.log.println("   ... and it has MAYBEDEFAULT attribute - FAILED");
                    } else {
                        this.log.println("   ... but it has no MAYBEDEFAULT attribute - OK");
                        part_result = true;
                    }
                }
                result &= part_result;
            }
        }
        catch (UnknownPropertyException e) {
            this.log.println("some properties seem to be unknown: " + e.toString());
            result = false;
        }
        this.tRes.tested("setAllPropertiesToDefault()", result);
    }
}

