/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertiesChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.utils;

public class _XMultiPropertySet
extends MultiMethodTest {
    public XMultiPropertySet oObj = null;
    private boolean propertiesChanged = false;
    private XPropertySetInfo propertySetInfo = null;
    private String[] testPropsNames = null;
    private int testPropsAmount = 0;
    private PrintWriter _log = null;
    private Object[] values = null;
    private Set exclProps = null;
    private XPropertiesChangeListener PClistener = new MyChangeListener();

    @Override
    public void before() {
        this._log = this.log;
        this.exclProps = (Set)this.tEnv.getObjRelation("XMultiPropertySet.ExcludeProps");
        if (this.exclProps == null) {
            this.exclProps = new HashSet(0);
        }
    }

    public void _getPropertySetInfo() {
        boolean bResult = true;
        this.propertySetInfo = this.oObj.getPropertySetInfo();
        if (this.propertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            bResult = false;
        }
        this.tRes.tested("getPropertySetInfo()", bResult);
    }

    public void _getPropertyValues() {
        this.requiredMethod("getPropertySetInfo()");
        boolean bResult = true;
        Property[] properties = this.propertySetInfo.getProperties();
        String[] allnames = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            allnames[i] = properties[i].Name;
        }
        this.values = this.oObj.getPropertyValues(allnames);
        this.tRes.tested("getPropertyValues()", bResult &= this.values != null);
        this.getPropsToTest(properties);
    }

    public void _addPropertiesChangeListener() {
        this.requiredMethod("getPropertyValues()");
        boolean result = true;
        this.oObj.addPropertiesChangeListener(this.testPropsNames, this.PClistener);
        if (this.testPropsAmount == 1 && this.testPropsNames[0].equals("none")) {
            this.testPropsAmount = 0;
        }
        for (int i = 0; i < this.testPropsAmount; ++i) {
            this.log.print("Trying to change property " + this.testPropsNames[i]);
            try {
                Object newValue;
                Object[] gValues = this.oObj.getPropertyValues(this.testPropsNames);
                gValues[i] = newValue = ValueChanger.changePValue(gValues[i]);
                this.propertiesChanged = false;
                this.oObj.setPropertyValues(this.testPropsNames, gValues);
                this.waitAMoment();
                result &= this.propertiesChanged;
                this.log.println(" ... done");
                continue;
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + e);
                e.printStackTrace(this.log);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + e);
                e.printStackTrace(this.log);
                continue;
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + e);
                e.printStackTrace(this.log);
            }
        }
        if (this.testPropsAmount == 0) {
            this.log.println("all properties are read only");
            this.tRes.tested("addPropertiesChangeListener()", Status.skipped(true));
        } else {
            this.tRes.tested("addPropertiesChangeListener()", this.propertiesChanged);
        }
    }

    public void _firePropertiesChangeEvent() {
        this.requiredMethod("addPropertiesChangeListener()");
        this.propertiesChanged = false;
        this.oObj.firePropertiesChangeEvent(this.testPropsNames, this.PClistener);
        this.waitAMoment();
        this.tRes.tested("firePropertiesChangeEvent()", this.propertiesChanged);
    }

    public void _removePropertiesChangeListener() {
        this.requiredMethod("firePropertiesChangeEvent()");
        boolean bResult = true;
        this.oObj.removePropertiesChangeListener(this.PClistener);
        this.tRes.tested("removePropertiesChangeListener()", bResult);
    }

    public void _setPropertyValues() {
        this.requiredMethod("getPropertyValues()");
        boolean bResult = true;
        if (this.testPropsNames.length == 1 && this.testPropsNames[0].equals("none")) {
            this.log.println("all properties are readOnly");
            this.tRes.tested("setPropertyValues()", Status.skipped(true));
            return;
        }
        this.log.println("Changing all properties");
        Object[] gValues = this.oObj.getPropertyValues(this.testPropsNames);
        for (int i = 0; i < this.testPropsAmount; ++i) {
            Object newValue;
            Object oldValue = gValues[i];
            gValues[i] = newValue = ValueChanger.changePValue(oldValue);
        }
        try {
            this.oObj.setPropertyValues(this.testPropsNames, gValues);
            Object[] newValues = this.oObj.getPropertyValues(this.testPropsNames);
            for (int i = 0; i < this.testPropsAmount; ++i) {
                if (!newValues[i].equals(gValues[i])) continue;
                bResult = true;
            }
        }
        catch (PropertyVetoException e) {
            this.log.println("Exception occured while setting properties");
            e.printStackTrace(this.log);
            bResult = false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Exception occured while setting properties");
            e.printStackTrace(this.log);
            bResult = false;
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception occured while setting properties");
            e.printStackTrace(this.log);
            bResult = false;
        }
        this.tRes.tested("setPropertyValues()", bResult);
    }

    private void getPropsToTest(Property[] properties) {
        String bound = "";
        for (int i = 0; i < properties.length; ++i) {
            Property property = properties[i];
            String name = property.Name;
            boolean isWritable = (property.Attributes & 0x10) == 0;
            boolean isNotNull = (property.Attributes & 1) == 0;
            boolean isBound = (property.Attributes & 2) != 0;
            boolean isExcluded = this.exclProps.contains(name);
            if (name.indexOf("UserDefined") > 0 || name.indexOf("Device") > 0) {
                isWritable = false;
            }
            this.values = this.oObj.getPropertyValues(new String[]{property.Name});
            boolean isVoid = utils.isVoid(this.values[0]);
            if (!isWritable || !isNotNull || !isBound || isExcluded || isVoid) continue;
            bound = bound + name + ";";
        }
        if (bound.equals("")) {
            bound = "none";
        }
        StringTokenizer ST = new StringTokenizer(bound, ";");
        int nr = ST.countTokens();
        this.testPropsNames = new String[nr];
        for (int i = 0; i < nr; ++i) {
            this.testPropsNames[i] = ST.nextToken();
        }
        this.testPropsAmount = nr;
    }

    private void waitAMoment() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.println("!!! Exception while waiting !!!");
        }
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public class MyChangeListener
    implements XPropertiesChangeListener {
        @Override
        public void propertiesChange(PropertyChangeEvent[] e) {
            _XMultiPropertySet.this.propertiesChanged = true;
        }

        @Override
        public void disposing(EventObject obj) {
        }
    }
}

