/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.beans.XMultiHierarchicalPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;

public class _XMultiHierarchicalPropertySet
extends MultiMethodTest {
    public XMultiHierarchicalPropertySet oObj;

    public void _getHierarchicalPropertySetInfo() {
        XHierarchicalPropertySetInfo hpsi = this.oObj.getHierarchicalPropertySetInfo();
        boolean res = true;
        if (hpsi == null) {
            this.log.println("The component doesn't provide HierarchicalPropertySetInfo");
            this.tRes.tested("getHierarchicalPropertySetInfo()", Status.skipped(true));
            return;
        }
        res = this.checkHPSI(hpsi);
        this.tRes.tested("getMultiHierarchicalPropertySetInfo()", res);
    }

    public void _getHierarchicalPropertyValues() {
        String[] pNames = (String[])this.tEnv.getObjRelation("PropertyNames");
        String[] pTypes = (String[])this.tEnv.getObjRelation("PropertyTypes");
        boolean res = true;
        try {
            Object[] getting = this.oObj.getHierarchicalPropertyValues(pNames);
            res &= this.checkType(pNames, pTypes, getting);
        }
        catch (IllegalArgumentException e) {
            this.log.println("Exception " + e.getMessage());
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception " + e.getMessage());
        }
        this.tRes.tested("getHierarchicalPropertyValues()", res);
    }

    public void _setHierarchicalPropertyValues() {
        String ro = (String)this.tEnv.getObjRelation("allReadOnly");
        if (ro != null) {
            this.log.println(ro);
            this.tRes.tested("setHierarchicalPropertyValues()", Status.skipped(true));
            return;
        }
        String[] pNames = (String[])this.tEnv.getObjRelation("PropertyNames");
        boolean res = true;
        try {
            Object[] oldValues = this.oObj.getHierarchicalPropertyValues(pNames);
            Object[] newValues = new Object[oldValues.length];
            for (int k = 0; k < oldValues.length; ++k) {
                newValues[k] = ValueChanger.changePValue(oldValues[k]);
            }
            this.oObj.setHierarchicalPropertyValues(pNames, newValues);
            Object[] getValues = this.oObj.getHierarchicalPropertyValues(pNames);
            for (int k = 0; k < pNames.length; ++k) {
                boolean localRes = ValueComparer.equalValue(getValues[k], newValues[k]);
                if (!localRes) {
                    this.log.println("didn't work for " + pNames[k]);
                    this.log.println("Expected " + newValues[k].toString());
                    this.log.println("Getting " + getValues[k].toString());
                }
                this.oObj.setHierarchicalPropertyValues(pNames, oldValues);
            }
        }
        catch (IllegalArgumentException e) {
            this.log.println("IllegalArgument " + e.getMessage());
        }
        catch (PropertyVetoException e) {
            this.log.println("VetoException " + e.getMessage());
        }
        catch (WrappedTargetException e) {
            this.log.println("WrappedTarget " + e.getMessage());
        }
        this.tRes.tested("setHierarchicalPropertyValues()", res);
    }

    protected boolean checkHPSI(XHierarchicalPropertySetInfo hpsi) {
        this.log.println("Checking the resulting HierarchicalPropertySetInfo");
        this.log.println("### NOT yet implemented");
        return true;
    }

    protected boolean checkType(String[] name, String[] type, Object[] value) {
        boolean result = true;
        for (int k = 0; k < name.length; ++k) {
            if (type[k].equals("Boolean")) {
                result &= value[k] instanceof Boolean;
                if (value[k] instanceof Boolean) continue;
                this.log.println("Wrong Type for property " + name[k]);
                this.log.println("Expected " + type[k]);
                this.log.println("getting " + value[k].getClass());
                continue;
            }
            if (!type[k].equals("Short")) continue;
            result &= value[k] instanceof Short;
            if (value[k] instanceof Short) continue;
            this.log.println("Wrong Type for property " + name[k]);
            this.log.println("Expected " + type[k]);
            this.log.println("getting " + value[k].getClass());
        }
        return result;
    }
}

