/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;

public class _XHierarchicalPropertySet
extends MultiMethodTest {
    public XHierarchicalPropertySet oObj;

    public void _getHierarchicalPropertySetInfo() {
        XHierarchicalPropertySetInfo hpsi = this.oObj.getHierarchicalPropertySetInfo();
        boolean res = true;
        if (hpsi == null) {
            this.log.println("The component doesn't provide HierarchicalPropertySetInfo");
            this.tRes.tested("getHierarchicalPropertySetInfo()", Status.skipped(true));
            return;
        }
        res = this.checkHPSI(hpsi);
        this.tRes.tested("getHierarchicalPropertySetInfo()", res);
    }

    public void _getHierarchicalPropertyValue() {
        String[] pNames = (String[])this.tEnv.getObjRelation("PropertyNames");
        String[] pTypes = (String[])this.tEnv.getObjRelation("PropertyTypes");
        boolean res = true;
        for (int i = 0; i < pNames.length; ++i) {
            try {
                this.log.print("Property " + pNames[i]);
                Object getting = this.oObj.getHierarchicalPropertyValue(pNames[i]);
                this.log.println(" has Value " + getting.toString());
                res &= this.checkType(pNames[i], pTypes[i], getting);
                continue;
            }
            catch (UnknownPropertyException e) {
                this.log.println(" is unknown");
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.println(" is illegal");
                continue;
            }
            catch (WrappedTargetException e) {
                this.log.println(" throws expeption " + e.getMessage());
            }
        }
        this.tRes.tested("getHierarchicalPropertyValue()", res);
    }

    public void _setHierarchicalPropertyValue() {
        String ro = (String)this.tEnv.getObjRelation("allReadOnly");
        if (ro != null) {
            this.log.println(ro);
            this.tRes.tested("setHierarchicalPropertyValue()", Status.skipped(true));
            return;
        }
        boolean res = true;
        String[] pNames = (String[])this.tEnv.getObjRelation("PropertyNames");
        for (int k = 0; k < pNames.length; ++k) {
            try {
                Object oldValue = this.oObj.getHierarchicalPropertyValue(pNames[k]);
                Object newValue = ValueChanger.changePValue(oldValue);
                this.oObj.setHierarchicalPropertyValue(pNames[k], newValue);
                Object getValue = this.oObj.getHierarchicalPropertyValue(pNames[k]);
                boolean localRes = ValueComparer.equalValue(getValue, newValue);
                if (!localRes) {
                    this.log.println("Expected " + newValue.toString());
                    this.log.println("Gained " + getValue.toString());
                }
                this.oObj.setHierarchicalPropertyValue(pNames[k], oldValue);
                res &= localRes;
                continue;
            }
            catch (UnknownPropertyException e) {
                this.log.println("Property is unknown");
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.println("IllegalArgument " + e.getMessage());
                continue;
            }
            catch (PropertyVetoException e) {
                this.log.println("VetoException " + e.getMessage());
                continue;
            }
            catch (WrappedTargetException e) {
                this.log.println("WrappedTarget " + e.getMessage());
            }
        }
        this.tRes.tested("setHierarchicalPropertyValue()", res);
    }

    protected boolean checkHPSI(XHierarchicalPropertySetInfo hpsi) {
        this.log.println("Checking the resulting HierarchicalPropertySetInfo");
        this.log.println("### NOT yet implemented");
        return true;
    }

    protected boolean checkType(String name, String type, Object value) {
        boolean result = true;
        if (type.equals("Boolean")) {
            result = value instanceof Boolean;
            if (!result) {
                this.log.println("Wrong Type for property " + name);
                this.log.println("Expected " + type);
                this.log.println("getting " + value.getClass());
            }
        } else if (type.equals("Short") && !(result = value instanceof Short)) {
            this.log.println("Wrong Type for property " + name);
            this.log.println("Expected " + type);
            this.log.println("getting " + value.getClass());
        }
        return result;
    }
}

