/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XFastPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.StatusException;
import util.ValueChanger;

public class _XFastPropertySet
extends MultiMethodTest {
    public XFastPropertySet oObj = null;
    private Vector handles = new Vector();
    private int handle = -1;
    private Set exclude = null;

    @Override
    protected void before() {
        this.exclude = (Set)this.tEnv.getObjRelation("XFastPropertySet.ExcludeProps");
        if (this.exclude == null) {
            this.exclude = new HashSet();
        }
    }

    public void _setFastPropertyValue() {
        XPropertySet PS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
        XPropertySetInfo propertySetInfo = PS.getPropertySetInfo();
        if (propertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            this.tRes.tested("setFastPropertyValue()", false);
        }
        this.getPropsToTest(propertySetInfo);
        Object gValue = null;
        Object sValue = null;
        if (this.handle == -1) {
            this.log.println("*** No changeable properties found ***");
            this.tRes.tested("setFastPropertyValue()", false);
        } else {
            try {
                gValue = this.oObj.getFastPropertyValue(this.handle);
                sValue = ValueChanger.changePValue(gValue);
                this.oObj.setFastPropertyValue(this.handle, sValue);
                sValue = this.oObj.getFastPropertyValue(this.handle);
            }
            catch (UnknownPropertyException e) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                e.printStackTrace(this.log);
            }
            catch (PropertyVetoException e) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                e.printStackTrace(this.log);
            }
            this.tRes.tested("setFastPropertyValue()", !gValue.equals(sValue));
        }
    }

    public void _getFastPropertyValue() {
        XPropertySet PS = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oObj);
        XPropertySetInfo propertySetInfo = PS.getPropertySetInfo();
        if (propertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            this.tRes.tested("getFastPropertyValue()", false);
        }
        this.getPropsToTest(propertySetInfo);
        try {
            this.oObj.getFastPropertyValue(this.handle);
            this.tRes.tested("getFastPropertyValue()", true);
        }
        catch (UnknownPropertyException e) {
            this.log.println("Exception occured while trying to get property '" + this.handle + "'");
            e.printStackTrace(this.log);
            this.tRes.tested("getFastPropertyValue()", false);
        }
        catch (WrappedTargetException e) {
            this.log.println("Exception occured while trying to get property '" + this.handle + "'");
            e.printStackTrace(this.log);
            this.tRes.tested("getFastPropertyValue()", false);
        }
    }

    private void getPropsToTest(XPropertySetInfo xPSI) {
        Property[] properties = xPSI.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (this.exclude.contains(properties[i].Name)) continue;
            Property property = properties[i];
            String name = property.Name;
            int handle = property.Handle;
            this.log.println("Checking '" + name + "' with handle = " + handle);
            boolean isWritable = (property.Attributes & 0x10) == 0;
            boolean isNotNull = (property.Attributes & 1) == 0;
            boolean canChange = false;
            if (isWritable && isNotNull) {
                canChange = this.isChangeable(handle);
            }
            if (!isWritable || !isNotNull || !canChange) continue;
            this.handles.add(new Integer(handle));
        }
        Random rnd = new Random();
        int nr = rnd.nextInt(this.handles.size());
        this.handle = (Integer)this.handles.elementAt(nr);
    }

    private boolean isChangeable(int handle) {
        boolean hasChanged = false;
        try {
            Object getProp = this.oObj.getFastPropertyValue(handle);
            Object setValue = null;
            if (getProp != null) {
                setValue = ValueChanger.changePValue(getProp);
            } else {
                this.log.println("Property with handle = " + handle + " is null but 'MAYBEVOID' isn't set");
            }
            if (setValue != null) {
                this.oObj.setFastPropertyValue(handle, setValue);
                hasChanged = !getProp.equals(this.oObj.getFastPropertyValue(handle));
            } else {
                this.log.println("Couldn't change Property with handle " + handle);
            }
        }
        catch (WrappedTargetException e) {
            this.log.println("Property with handle " + handle + " throws exception");
            e.printStackTrace(this.log);
            throw new StatusException("Property with handle " + handle + " throws exception", e);
        }
        catch (IllegalArgumentException e) {
            this.log.println("Property with handle " + handle + " throws exception");
            e.printStackTrace(this.log);
            throw new StatusException("Property with handle " + handle + " throws exception", e);
        }
        catch (PropertyVetoException e) {
            this.log.println("Property with handle " + handle + " throws exception");
            e.printStackTrace(this.log);
            throw new StatusException("Property with handle " + handle + " throws exception", e);
        }
        catch (UnknownPropertyException e) {
            this.log.println("Property with handle " + handle + " throws exception");
            e.printStackTrace(this.log);
            throw new StatusException("Property with handle " + handle + " throws exception", e);
        }
        return hasChanged;
    }
}

