/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt.tree;

import com.sun.star.awt.tree.XTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTreeNode
extends MultiMethodTest {
    public XTreeNode oObj = null;
    private int mCount = 0;
    String msDisplayValue = null;
    String msExpandedGraphicURL = null;
    String msCollapsedGraphicURL = null;
    String msNodeGraphicURL = null;

    @Override
    public void before() {
        this.msDisplayValue = (String)this.tEnv.getObjRelation("XTreeNode_DisplayValue");
        if (this.msDisplayValue == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_DisplayVlaue'"));
        }
        this.msExpandedGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_ExpandedGraphicURL");
        if (this.msExpandedGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_ExpandedGraphicURL'"));
        }
        this.msCollapsedGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_CollapsedGraphicURL");
        if (this.msCollapsedGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_CollapsedGraphicURL'"));
        }
        this.msNodeGraphicURL = (String)this.tEnv.getObjRelation("XTreeNode_NodeGraphicURL");
        if (this.msNodeGraphicURL == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XTreeNode_NodeGraphicURL'"));
        }
    }

    public void _getChildAt() {
        this.requiredMethod("getChildCount()");
        boolean bOK = true;
        for (int i = 0; i < this.mCount; ++i) {
            XTreeNode xNode = null;
            try {
                xNode = this.oObj.getChildAt(i);
            }
            catch (IndexOutOfBoundsException ex) {
                this.log.println("ERROR: getChildAt(" + i + "): " + ex.toString());
            }
            if (xNode != null) continue;
            this.log.println("ERROR: getChildAt(" + i + ") returns null => FAILED");
            bOK = false;
        }
        this.tRes.tested("getChildAt()", bOK);
    }

    public void _getChildCount() {
        boolean bOK = true;
        this.mCount = this.oObj.getChildCount();
        this.log.println("got count '" + this.mCount + "' of children");
        if (this.mCount < 1) {
            this.log.println("ERROR: got a count < 1. The test object must be support morw then zero children => FAILED");
            bOK = false;
        }
        this.tRes.tested("getChildCount()", bOK);
    }

    public void _getParent() {
        this.requiredMethod("getChildAt()");
        boolean bOK = true;
        XTreeNode xNode = null;
        try {
            this.log.println("try to getChildAt(0)");
            xNode = this.oObj.getChildAt(0);
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("ERROR: getChildAt(0): " + ex.toString());
        }
        this.log.println("try to get parrent of children");
        XTreeNode xParrent = xNode.getParent();
        bOK = this.oObj.equals(xParrent);
        this.log.println("original object and parrent should be the same: " + bOK);
        this.tRes.tested("getParent()", bOK);
    }

    public void _getIndex() {
        this.requiredMethod("getChildAt()");
        boolean bOK = true;
        XTreeNode xNode = null;
        try {
            this.log.println("try to getChildAt(0)");
            xNode = this.oObj.getChildAt(0);
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("ERROR: getChildAt(0): " + ex.toString());
        }
        this.log.println("try to get index from child...");
        int index = this.oObj.getIndex(xNode);
        if (index != 0) {
            this.log.println("ERROR: getIndex() does not return '0' => FAILED");
            bOK = false;
        }
        this.tRes.tested("getIndex()", bOK);
    }

    public void _hasChildrenOnDemand() {
        boolean bOK = true;
        bOK = this.oObj.hasChildrenOnDemand();
        this.tRes.tested("hasChildrenOnDemand()", bOK);
    }

    public void _getDisplayValue() {
        boolean bOK = true;
        String DisplayValue = null;
        Object dispVal = this.oObj.getDisplayValue();
        try {
            DisplayValue = AnyConverter.toString((Object)dispVal);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not convert the returned object of 'getDisplyValue()' to String with AnyConverter: " + ex.toString());
        }
        if (!this.msDisplayValue.equals(DisplayValue)) {
            this.log.println("ERROR: getNodeGraphicURL() does not return expected value:\n\tExpected: " + this.msDisplayValue + "\n" + "\tGot: " + DisplayValue);
            bOK = false;
        }
        this.tRes.tested("getDisplayValue()", bOK);
    }

    public void _getNodeGraphicURL() {
        boolean bOK = true;
        String graphicURL = this.oObj.getNodeGraphicURL();
        if (!this.msNodeGraphicURL.equals(graphicURL)) {
            this.log.println("ERROR: getNodeGraphicURL() does not return expected value:\n\tExpected: " + this.msNodeGraphicURL + "\n" + "\tGot: " + graphicURL);
            bOK = false;
        }
        this.tRes.tested("getNodeGraphicURL()", bOK);
    }

    public void _getExpandedGraphicURL() {
        boolean bOK = true;
        String ExpandedGraphicURL = this.oObj.getExpandedGraphicURL();
        if (!this.msExpandedGraphicURL.equals(ExpandedGraphicURL)) {
            this.log.println("ERROR: getExpandedGraphicURL() does not return expected value:\n\tExpected: " + this.msExpandedGraphicURL + "\n" + "\tGot: " + ExpandedGraphicURL);
            bOK = false;
        }
        this.tRes.tested("getExpandedGraphicURL()", bOK);
    }

    public void _getCollapsedGraphicURL() {
        boolean bOK = true;
        String CollapsedGraphicURL = this.oObj.getCollapsedGraphicURL();
        if (!this.msCollapsedGraphicURL.equals(CollapsedGraphicURL)) {
            this.log.println("ERROR: getExpandedGraphicURL() does not return expected value:\n\tExpected: " + this.msCollapsedGraphicURL + "\n" + "\tGot: " + CollapsedGraphicURL);
            bOK = false;
        }
        this.tRes.tested("getCollapsedGraphicURL()", bOK);
    }
}

