/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt.tree;

import com.sun.star.awt.tree.ExpandVetoException;
import com.sun.star.awt.tree.TreeExpansionEvent;
import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.awt.tree.XTreeControl;
import com.sun.star.awt.tree.XTreeEditListener;
import com.sun.star.awt.tree.XTreeExpansionListener;
import com.sun.star.awt.tree.XTreeNode;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.util.VetoException;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XTreeControl
extends MultiMethodTest {
    public XTreeControl oObj = null;
    private XMutableTreeNode mNewNode = null;
    private XMutableTreeNode mXNode = null;
    XTreeExpansionListener mTreeExpansionListener1 = new TreeExpansionListenerImpl1();
    XTreeExpansionListener mTreeExpansionListener2 = new TreeExpansionListenerImpl2();
    XTreeEditListener mTreeEditListener1 = new TreeEditListenerImpl1();
    XTreeEditListener mTreeEditListener2 = new TreeEditListenerImpl2();
    boolean mTreeExpanded1 = false;
    boolean mTreeExpanding1 = false;
    boolean mTreeCollapsed1 = false;
    boolean mTreeCollapsing1 = false;
    boolean mTreeExpanded2 = false;
    boolean mTreeExpanding2 = false;
    boolean mTreeCollapsed2 = false;
    boolean mTreeCollapsing2 = false;
    boolean mTreeNodeEditing1 = false;
    boolean mTreeNodeEdit1 = false;
    boolean mTreeNodeEditing2 = false;
    boolean mTreeNodeEdit2 = false;

    private void resetTreeExpandingListener() {
        this.mTreeExpanded1 = false;
        this.mTreeExpanded2 = false;
        this.mTreeCollapsed1 = false;
        this.mTreeCollapsed2 = false;
        this.mTreeExpanding1 = false;
        this.mTreeExpanding2 = false;
        this.mTreeCollapsing1 = false;
        this.mTreeCollapsing2 = false;
    }

    private void resetEditListener() {
        this.mTreeNodeEditing1 = false;
        this.mTreeNodeEdit1 = false;
        this.mTreeNodeEditing2 = false;
        this.mTreeNodeEdit2 = false;
    }

    @Override
    public void before() {
        this.mXNode = (XMutableTreeNode)this.tEnv.getObjRelation("XTreeControl_Node");
        if (this.mXNode == null) {
            throw new StatusException(Status.failed("ERROR: could not get object relation 'XTreeControl_Node'"));
        }
    }

    public void _isNodeExpanded() throws ExpandVetoException {
        boolean bOK = true;
        boolean isExpanded = false;
        try {
            isExpanded = this.oObj.isNodeExpanded(this.mXNode);
            this.log.println("node is expanded: " + isExpanded);
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not query for 'isNodeExpanded()': " + ex.toString());
        }
        if (isExpanded) {
            try {
                this.log.println("try to collapse node...");
                this.oObj.collapseNode(this.mXNode);
            }
            catch (ExpandVetoException ex) {
                bOK = false;
                this.log.println("ERROR: could not collapse node: " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                bOK = false;
                this.log.println("ERROR: could not collapse node: " + ex.toString());
            }
        } else {
            try {
                this.log.println("try to expand node...");
                this.oObj.expandNode(this.mXNode);
            }
            catch (ExpandVetoException ex) {
                bOK = false;
                this.log.println("ERROR: could not expand node: " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                bOK = false;
                this.log.println("ERROR: could not expand node: " + ex.toString());
            }
        }
        try {
            boolean isAlsoExpanded = this.oObj.isNodeExpanded(this.mXNode);
            this.log.println("node is expanded: " + isAlsoExpanded + " => " + (bOK &= isExpanded != isAlsoExpanded));
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not query for 'isNodeExpanded()': " + ex.toString());
        }
        this.tRes.tested("isNodeExpanded()", bOK);
    }

    public void _isNodeCollapsed() {
        boolean bOK = true;
        boolean isCollapsed = false;
        try {
            isCollapsed = this.oObj.isNodeCollapsed(this.mXNode);
            this.log.println("node is Collapsed: " + isCollapsed);
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not query for 'isNodeCollapsed()': " + ex.toString());
        }
        if (!isCollapsed) {
            try {
                this.log.println("try to collapse node...");
                this.oObj.collapseNode(this.mXNode);
            }
            catch (ExpandVetoException ex) {
                bOK = false;
                this.log.println("ERROR: could not collapse node: " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                bOK = false;
                this.log.println("ERROR: could not collapse node: " + ex.toString());
            }
        } else {
            try {
                this.log.println("try to expand node...");
                this.oObj.expandNode(this.mXNode);
            }
            catch (ExpandVetoException ex) {
                bOK = false;
                this.log.println("ERROR: could not expand node: " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                bOK = false;
                this.log.println("ERROR: could not expand node: " + ex.toString());
            }
        }
        try {
            boolean isAlsoCollapsed = this.oObj.isNodeCollapsed(this.mXNode);
            this.log.println("node is Collapsed: " + isAlsoCollapsed + " => " + (bOK &= isCollapsed != isAlsoCollapsed));
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not query for 'isNodeCollapsed()': " + ex.toString());
        }
        this.tRes.tested("isNodeCollapsed()", bOK);
    }

    public void _makeNodeVisible() {
        boolean bOK = true;
        try {
            this.oObj.makeNodeVisible(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not call method 'makeNodeVisible()' successfully: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not call method 'makeNodeVisible()' successfully: " + ex.toString());
        }
        try {
            bOK &= this.oObj.isNodeVisible(this.mXNode);
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not call method 'isNodeVisible()' successfully: " + ex.toString());
        }
        this.tRes.tested("makeNodeVisible()", bOK);
    }

    public void _isNodeVisible() {
        this.requiredMethod("makeNodeVisible()");
        boolean bOK = true;
        this.log.println("since required method 'makeNodeVisible()' uses method 'isNodeVisible()' this test is ok.");
        this.tRes.tested("isNodeVisible()", bOK);
    }

    public void _expandNode() {
        this.requiredMethod("isNodeExpanded()");
        boolean bOK = true;
        this.log.println("since required method 'isnodeExpanded()' uses method 'expandNode()' this test is ok.");
        this.tRes.tested("expandNode()", bOK);
    }

    public void _collapseNode() {
        this.requiredMethod("isNodeCollapsed()");
        boolean bOK = true;
        this.log.println("since required method 'isnodeCollapsed()' uses method 'expandNode()' this test is ok.");
        this.tRes.tested("collapseNode()", bOK);
    }

    public void _addTreeExpansionListener() {
        boolean bOK = true;
        this.log.println("collapse Node to get an initial status...");
        try {
            this.oObj.collapseNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        this.log.println("add mTreeExpansionListener1...");
        this.oObj.addTreeExpansionListener(this.mTreeExpansionListener1);
        this.log.println("add mTreeExpansionListener2");
        this.oObj.addTreeExpansionListener(this.mTreeExpansionListener2);
        this.resetTreeExpandingListener();
        this.log.println("expand Node...");
        try {
            this.oObj.expandNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not expand node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not expand node: " + ex.toString());
        }
        bOK &= this.mTreeExpanded1 & this.mTreeExpanded2 & !this.mTreeCollapsed1 & !this.mTreeCollapsed2 & this.mTreeExpanding1 & this.mTreeExpanding2 & !this.mTreeCollapsing1 & !this.mTreeCollapsing2;
        this.resetTreeExpandingListener();
        this.log.println("collapse Node...");
        try {
            this.oObj.collapseNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        this.tRes.tested("addTreeExpansionListener()", bOK &= !this.mTreeExpanded1 & !this.mTreeExpanded2 & this.mTreeCollapsed1 & this.mTreeCollapsed2 & !this.mTreeExpanding1 & !this.mTreeExpanding2 & this.mTreeCollapsing1 & this.mTreeCollapsing2);
    }

    public void _removeTreeExpansionListener() {
        this.requiredMethod("addTreeExpansionListener()");
        boolean bOK = true;
        this.log.println("collapse Node to get an initial status...");
        try {
            this.oObj.collapseNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        this.resetTreeExpandingListener();
        this.log.println("remove mTreeExpansionListener2 ...");
        this.oObj.removeTreeExpansionListener(this.mTreeExpansionListener2);
        this.log.println("expand Node...");
        try {
            this.oObj.expandNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not expand node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not expand node: " + ex.toString());
        }
        bOK &= this.mTreeExpanded1 & !this.mTreeExpanded2 & !this.mTreeCollapsed1 & !this.mTreeCollapsed2 & this.mTreeExpanding1 & !this.mTreeExpanding2 & !this.mTreeCollapsing1 & !this.mTreeCollapsing2;
        this.resetTreeExpandingListener();
        this.log.println("collapse Node...");
        try {
            this.oObj.collapseNode(this.mXNode);
        }
        catch (ExpandVetoException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            bOK = false;
            this.log.println("ERROR: could not collapse node: " + ex.toString());
        }
        boolean bl = !this.mTreeExpanded1 & !this.mTreeExpanded2 & this.mTreeCollapsed1 & !this.mTreeCollapsed2 & !this.mTreeExpanding1 & !this.mTreeExpanding2 & this.mTreeCollapsing1;
        boolean bl2 = !this.mTreeCollapsing2;
        this.log.println("remove mTreeExpansionListener2 ...");
        this.oObj.removeTreeExpansionListener(this.mTreeExpansionListener2);
        this.tRes.tested("removeTreeExpansionListener()", bOK &= bl & bl2);
    }

    public void _getNodeForLocation() {
        boolean bOK = false;
        this.tRes.tested("getNodeForLocation()", bOK);
    }

    public void _getClosestNodeForLocation() {
        boolean bOK = false;
        this.log.println("try to get Node for location 100,100");
        XTreeNode myNode = this.oObj.getClosestNodeForLocation(100, 100);
        this.tRes.tested("getClosestNodeForLocation()", bOK &= myNode != null);
    }

    public void _isEditing() {
        boolean bOK = false;
        this.log.println("not ready because of i78701");
        this.tRes.tested("isEditing()", bOK);
    }

    public void _stopEditing() {
        boolean bOK = false;
        this.log.println("not ready because of i78701");
        this.tRes.tested("stopEditing()", bOK);
    }

    public void _cancelEditing() {
        boolean bOK = false;
        this.log.println("not ready because of i78701");
        this.tRes.tested("cancelEditing()", bOK);
    }

    public void _startEditingAtNode() {
        boolean bOK = false;
        this.log.println("not ready because of i78701");
        this.tRes.tested("startEditingAtNode()", bOK);
    }

    public void _addTreeEditListener() {
        boolean bOK = true;
        this.log.println("add EditListener 1....");
        this.oObj.addTreeEditListener(this.mTreeEditListener1);
        this.log.println("add EditListener 2....");
        this.oObj.addTreeEditListener(this.mTreeEditListener2);
        this.resetEditListener();
        try {
            this.oObj.startEditingAtNode(this.mXNode);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not start editing at node: " + ex.toString());
            bOK = false;
        }
        this.log.println("not ready because of i78701");
        bOK = false;
        this.tRes.tested("addTreeEditListener()", bOK);
    }

    public void _removeTreeEditListener() {
        boolean bOK = false;
        this.log.println("not ready because of i78701");
        this.tRes.tested("removeTreeEditListener()", bOK);
    }

    public void _DefaultExpandedGraphicURL() {
        boolean bOK = true;
        String current = this.oObj.getDefaultExpandedGraphicURL();
        this.log.println("current DefaultExpandedGraphicURL: " + current);
        String changeUrl = null;
        changeUrl = current.equals("private:graphicrepository/sd/res/triangle_right.png") ? "private:graphicrepository/sd/res/triangle_down.png" : "private:graphicrepository/sd/res/triangle_right.png";
        this.log.println("try to set '" + changeUrl + "' as new DefaultExpandedGraphicURL");
        this.oObj.setDefaultExpandedGraphicURL(changeUrl);
        String newUrl = this.oObj.getDefaultExpandedGraphicURL();
        this.log.println("new DefaultExpandedGraphicURL: " + newUrl);
        this.tRes.tested("DefaultExpandedGraphicURL()", bOK &= !newUrl.equals(current));
    }

    public void _DefaultCollapsedGraphicURL() {
        boolean bOK = true;
        String current = this.oObj.getDefaultCollapsedGraphicURL();
        this.log.println("current DefaultCollapsedGraphicURL: " + current);
        String changeUrl = null;
        changeUrl = current.equals("private:graphicrepository/sd/res/triangle_right.png") ? "private:graphicrepository/sd/res/triangle_down.png" : "private:graphicrepository/sd/res/triangle_right.png";
        this.log.println("try to set '" + changeUrl + "' as new DefaultCollapsedGraphicURL");
        this.oObj.setDefaultCollapsedGraphicURL(changeUrl);
        String newUrl = this.oObj.getDefaultCollapsedGraphicURL();
        this.log.println("new DefaultCollapsedGraphicURL: " + newUrl);
        this.tRes.tested("DefaultCollapsedGraphicURL()", bOK &= !newUrl.equals(current));
    }

    public class TreeEditListenerImpl2
    implements XTreeEditListener {
        @Override
        public void nodeEditing(XTreeNode xTreeNode) throws VetoException {
            _XTreeControl.this.log.println("event at EditListener 2: nodeEditing");
            _XTreeControl.this.mTreeNodeEditing2 = true;
        }

        @Override
        public void nodeEdited(XTreeNode xTreeNode, String string) {
            _XTreeControl.this.log.println("event at EditListener 2: nodeEdited");
            _XTreeControl.this.mTreeNodeEdit2 = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            _XTreeControl.this.log.println("event at EditListener 2: disposing");
        }
    }

    public class TreeEditListenerImpl1
    implements XTreeEditListener {
        @Override
        public void nodeEditing(XTreeNode xTreeNode) throws VetoException {
            _XTreeControl.this.log.println("event at EditListener 1: nodeEditing");
            _XTreeControl.this.mTreeNodeEditing1 = true;
        }

        @Override
        public void nodeEdited(XTreeNode xTreeNode, String string) {
            _XTreeControl.this.log.println("event at EditListener 1: nodeEdited");
            _XTreeControl.this.mTreeNodeEdit1 = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            _XTreeControl.this.log.println("event at EditListener 1: disposing");
        }
    }

    public class TreeExpansionListenerImpl2
    implements XTreeExpansionListener {
        @Override
        public void requestChildNodes(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 2: requestChildNodes");
        }

        @Override
        public void treeExpanding(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            _XTreeControl.this.log.println("event at ExpansionListener 2: treeExpanding");
            _XTreeControl.this.mTreeExpanding2 = true;
        }

        @Override
        public void treeCollapsing(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            _XTreeControl.this.log.println("event at ExpansionListener 2: treeCollapsing");
            _XTreeControl.this.mTreeCollapsing2 = true;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 2: treeExpanded");
            _XTreeControl.this.mTreeExpanded2 = true;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 2: treeCollapsed");
            _XTreeControl.this.mTreeCollapsed2 = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            _XTreeControl.this.log.println("event at ExpansionListener 2: disposing");
        }
    }

    public class TreeExpansionListenerImpl1
    implements XTreeExpansionListener {
        @Override
        public void requestChildNodes(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 1: requestChildNodes");
        }

        @Override
        public void treeExpanding(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            _XTreeControl.this.log.println("event at ExpansionListener 1: treeExpanding");
            _XTreeControl.this.mTreeExpanding1 = true;
        }

        @Override
        public void treeCollapsing(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            _XTreeControl.this.log.println("event at ExpansionListener 1: treeCollapsing");
            _XTreeControl.this.mTreeCollapsing1 = true;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 1: treeExpanded");
            _XTreeControl.this.mTreeExpanded1 = true;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            _XTreeControl.this.log.println("event at ExpansionListener 1: treeCollapsed");
            _XTreeControl.this.mTreeCollapsed1 = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            _XTreeControl.this.log.println("event at ExpansionListener 1: disposing");
        }
    }

    public static interface XTreeDataModelListenerEvent {
        public void fireEvent();
    }
}

