/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt.tree;

import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XMutableTreeNode
extends MultiMethodTest {
    public XMutableTreeNode oObj = null;
    private int mCount = 0;
    private XMutableTreeNodeCreator nodeCreator = null;

    @Override
    public void before() {
        this.nodeCreator = (XMutableTreeNodeCreator)this.tEnv.getObjRelation("XMutableTreeNodeCreator");
        if (this.nodeCreator == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XMutableTreeNodeCreator'"));
        }
    }

    public void _appendChild() {
        boolean bOK = true;
        this.log.println("try to append a valid node...");
        XMutableTreeNode myNode = this.nodeCreator.createNode("myNodeToAppend");
        try {
            this.oObj.appendChild(myNode);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not appedn a valid node: " + ex.toString());
            bOK = false;
        }
        this.log.println("try to append the node a second time...");
        try {
            this.oObj.appendChild(myNode);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        this.log.println("try to append the object itself...");
        try {
            this.oObj.appendChild(this.oObj);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        this.tRes.tested("appendChild()", bOK);
    }

    public void _insertChildByIndex() {
        boolean bOK = true;
        XMutableTreeNode myNode = this.nodeCreator.createNode("myNodeToInsert");
        try {
            this.log.println("try to insert a valid node...");
            this.oObj.insertChildByIndex(0, myNode);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not insert a valid node: " + ex.toString());
            bOK = false;
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("ERROR: could not insert a valid node on index '0': " + ex.toString());
            bOK = false;
        }
        try {
            this.log.println("try to insert a valid node a second time...");
            this.oObj.insertChildByIndex(0, myNode);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected IllegalArgumentException wa thrown => OK");
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("ERROR: wrong IndexOutOfBoundsException was thrown. Expected is IllegalArgumentException => FAILED");
            bOK = false;
        }
        XMutableTreeNode myNode2 = this.nodeCreator.createNode("myNodeToInsert2");
        try {
            this.log.println("try to insert a valid node on invalid index '-3'...");
            this.oObj.insertChildByIndex(-3, myNode2);
            this.log.println("ERROR: expected IndexOutOfBoundsException was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: wrong IllegalArgumentException was thrown. Expeced is IndexOutOfBoundsException => FAILED");
            bOK = false;
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("Expected IndexOutOfBoundsException was thrown => OK");
        }
        try {
            this.log.println("try to insert the object itself...");
            this.oObj.insertChildByIndex(0, this.oObj);
            this.log.println("ERROR: expected IllegalArgumentException was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected IllegalArgumentException was thrown => OK");
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("unexpected IndexOutOfBoundsException was thrown, expected was IllegalArgumentException => FAILED");
            bOK = false;
        }
        this.tRes.tested("insertChildByIndex()", bOK);
    }

    public void _removeChildByIndex() {
        this.requiredMethod("insertChildByIndex()");
        boolean bOK = true;
        try {
            this.log.println("try to remove node at index '0'...");
            this.oObj.removeChildByIndex(0);
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("ERROR: IndexOutOfBoundsException was thrown => FAILED");
            bOK = false;
        }
        try {
            this.log.println("try to remove node at invalid index '-3'");
            this.oObj.removeChildByIndex(-3);
            this.log.println("ERROR: expeced IndexOutOfBoundsException was not thrown => FAILED");
            bOK = false;
        }
        catch (IndexOutOfBoundsException ex) {
            this.log.println("expected IndexOutOfBoundsException was thrown => OK");
        }
        this.tRes.tested("removeChildByIndex()", bOK);
    }

    public void _setHasChildrenOnDemand() {
        boolean bOK = true;
        this.log.println("setHasChildrenOnDemand(true)");
        this.oObj.setHasChildrenOnDemand(true);
        this.log.println("setHasChildrenOnDemand(false)");
        this.oObj.setHasChildrenOnDemand(false);
        this.tRes.tested("setHasChildrenOnDemand()", bOK);
    }

    public void _setDisplayValue() {
        boolean bOK = true;
        this.log.println("setDisplayValue(\"MyTestValue\")");
        this.oObj.setDisplayValue("MyTestValue");
        this.log.println("setDisplayValue(null)");
        this.oObj.setDisplayValue(null);
        this.log.println("oObj.setDisplayValue(oObj)");
        this.oObj.setDisplayValue(this.oObj);
        this.tRes.tested("setDisplayValue()", bOK);
    }

    public void _setNodeGraphicURL() {
        boolean bOK = true;
        this.log.println("setNodeGraphicURL(\"MyTestURL\")");
        this.oObj.setNodeGraphicURL("MyTestURL");
        this.log.println("setNodeGraphicURL(null)");
        this.oObj.setNodeGraphicURL(null);
        this.tRes.tested("setNodeGraphicURL()", bOK);
    }

    public void _setExpandedGraphicURL() {
        boolean bOK = true;
        this.log.println("setExpandedGraphicURL(\"myExpandedURL\")");
        this.oObj.setExpandedGraphicURL("myExpandedURL");
        this.log.println("setExpandedGraphicURL(null)");
        this.oObj.setExpandedGraphicURL(null);
        this.tRes.tested("setExpandedGraphicURL()", bOK);
    }

    public void _setCollapsedGraphicURL() {
        boolean bOK = true;
        this.log.println("setCollapsedGraphicURL(\"myCollapsedURL\")");
        this.oObj.setCollapsedGraphicURL("myCollapsedURL");
        this.log.println("setCollapsedGraphicURL(null)");
        this.oObj.setCollapsedGraphicURL(null);
        this.tRes.tested("setCollapsedGraphicURL()", bOK);
    }

    public void _DataValue() {
        boolean bOK = true;
        this.log.println("setDataValue(\"myDataValue\")");
        this.oObj.setDataValue("myDataValue");
        String sDataValue = (String)this.oObj.getDataValue();
        if (!sDataValue.equals("myDataValue")) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: myDataValue\n\tgot: " + sDataValue);
            bOK = false;
        }
        this.log.println("setDataValue(null)");
        this.oObj.setDataValue(null);
        Object oDataValue = this.oObj.getDataValue();
        if (oDataValue != null) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: null\n\tgot: " + oDataValue.toString());
            bOK = false;
        }
        this.log.println("oObj.setDisplayValue(oObj)");
        this.oObj.setDisplayValue(this.oObj);
        oDataValue = this.oObj.getDataValue();
        if (oDataValue != null) {
            this.log.println("ERROR: getDataVlaue does not return the value which is inserted before:\n\texpected: " + this.oObj.toString() + "\n" + "\tgot: " + oDataValue.toString());
            bOK = false;
        }
        this.tRes.tested("DataValue()", bOK);
    }

    public static interface XMutableTreeNodeCreator {
        public XMutableTreeNode createNode(String var1);
    }
}

