/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.awt.FocusEvent;
import com.sun.star.awt.KeyEvent;
import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.PaintEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.WindowEvent;
import com.sun.star.awt.XFocusListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XMouseMotionListener;
import com.sun.star.awt.XPaintListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowListener;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.EventObject;
import lib.MultiMethodTest;
import util.ValueComparer;

public class _XWindow
extends MultiMethodTest {
    public XWindow oObj = null;
    private Rectangle posSize = null;
    private XWindow win = null;
    private TestWindowListener wListener = new TestWindowListener();
    private TestFocusListener fListener = new TestFocusListener();
    private TestKeyListener kListener = new TestKeyListener();
    private TestMouseListener mListener = new TestMouseListener();
    private TestMouseMotionListener mmListener = new TestMouseMotionListener();
    private TestPaintListener pListener = new TestPaintListener();

    public void _getPosSize() {
        this.posSize = this.oObj.getPosSize();
        this.tRes.tested("getPosSize()", this.posSize != null);
    }

    public void _setPosSize() {
        Rectangle newRec = new Rectangle();
        this.requiredMethod("getPosSize()");
        newRec.X = this.posSize.X + 1;
        newRec.Y = this.posSize.Y + 1;
        newRec.Width = this.posSize.Width - 3;
        newRec.Height = this.posSize.Height - 3;
        this.oObj.setPosSize(newRec.X, newRec.Y, newRec.Width, newRec.Height, (short)15);
        Rectangle gPS = this.oObj.getPosSize();
        this.log.println("Was : (" + this.posSize.X + ", " + this.posSize.Y + ", " + this.posSize.Width + ", " + this.posSize.Height + "), ");
        this.log.println("Set : (" + newRec.X + ", " + newRec.Y + ", " + newRec.Width + ", " + newRec.Height + "), ");
        this.log.println("Get : (" + gPS.X + ", " + gPS.Y + ", " + gPS.Width + ", " + gPS.Height + "). ");
        this.tRes.tested("setPosSize()", ValueComparer.equalValue(newRec, gPS));
    }

    public void _setFocus() {
        this.win = (XWindow)this.tEnv.getObjRelation("XWindow.AnotherWindow");
        this.oObj.setFocus();
        this.win.setFocus();
        this.oObj.setFocus();
        this.tRes.tested("setFocus()", true);
    }

    public void _setVisible() {
        this.oObj.setVisible(false);
        this.oObj.setVisible(true);
        this.tRes.tested("setVisible()", true);
    }

    public void _setEnable() {
        this.oObj.setEnable(false);
        this.oObj.setEnable(true);
        this.tRes.tested("setEnable()", true);
    }

    public void _addWindowListener() {
        this.executeMethod("setPosSize()");
        this.executeMethod("setVisible()");
        boolean result = true;
        this.oObj.addWindowListener(this.wListener);
        XControlShape ctrlShape = (XControlShape)this.tEnv.getObjRelation("XWindow.ControlShape");
        this.log.println("change object position and size...");
        if (ctrlShape != null) {
            try {
                Size sz = ctrlShape.getSize();
                sz.Height += 100;
                ctrlShape.setSize(sz);
                Point pos = ctrlShape.getPosition();
                pos.X += 100;
                ctrlShape.setPosition(pos);
            }
            catch (PropertyVetoException e) {
                this.log.println("Couldn't change size or position: ");
                e.printStackTrace(this.log);
            }
        } else {
            this.oObj.setPosSize(this.posSize.X + 2, 0, 0, 0, (short)1);
            this.oObj.setPosSize(0, 0, 100, 100, (short)4);
        }
        this.shortWait();
        boolean res = this.wListener.resized && this.wListener.moved && !this.wListener.hidden && !this.wListener.shown;
        result &= res;
        if (!res) {
            this.log.println("\twindowHidden()  wasn't called: " + !this.wListener.hidden);
            this.log.println("\twindowShown()   wasn't called: " + !this.wListener.shown);
            this.log.println("\twindowResized()    was called: " + this.wListener.resized);
            this.log.println("\twindowMoved()      was called: " + this.wListener.moved);
        } else {
            this.log.println("windowMoved() and windowResized() was called");
        }
        this.wListener.init();
        this.shortWait();
        this.log.println("set object invisible...");
        this.oObj.setVisible(false);
        this.shortWait();
        res = this.wListener.hidden && !this.wListener.resized && !this.wListener.moved && !this.wListener.shown;
        result &= res;
        if (!res) {
            this.log.println("\twindowHidden()     was called: " + this.wListener.hidden);
            this.log.println("\twindowShown()   wasn't called: " + !this.wListener.shown);
            this.log.println("\twindowResized() wasn't called: " + !this.wListener.resized);
            this.log.println("\twindowMoved()   wasn't called: " + !this.wListener.moved);
        } else {
            this.log.println("windowHidden() was called");
        }
        this.wListener.init();
        this.shortWait();
        this.log.println("set object visible...");
        this.oObj.setVisible(true);
        this.shortWait();
        res = this.wListener.shown && !this.wListener.resized && !this.wListener.hidden && !this.wListener.moved;
        result &= res;
        if (!res) {
            this.log.println("\twindowHidden()  wasn't called: " + !this.wListener.hidden);
            this.log.println("\twindowShown()      was called: " + this.wListener.shown);
            this.log.println("\twindowResized() wasn't called: " + !this.wListener.resized);
            this.log.println("\twindowMoved()   wasn't called: " + !this.wListener.moved);
        } else {
            this.log.println("windowShown() was called");
        }
        this.tRes.tested("addWindowListener()", result);
    }

    public void _removeWindowListener() {
        this.requiredMethod("addWindowListener()");
        this.oObj.removeWindowListener(this.wListener);
        this.wListener.init();
        this.oObj.setPosSize(this.posSize.X, this.posSize.Y, this.posSize.Width, this.posSize.Height, (short)15);
        this.oObj.setVisible(false);
        this.oObj.setVisible(true);
        boolean res = !this.wListener.resized && !this.wListener.moved && !this.wListener.hidden && !this.wListener.shown;
        this.tRes.tested("removeWindowListener()", res);
    }

    public void _addFocusListener() {
        boolean result = true;
        this.requiredMethod("setFocus()");
        this.oObj.addFocusListener(this.fListener);
        this.oObj.setFocus();
        this.shortWait();
        this.win.setFocus();
        this.shortWait();
        result &= this.fListener.lost;
        if (!this.fListener.lost) {
            this.log.println("Lost focus was not notified about");
        }
        this.oObj.setFocus();
        this.shortWait();
        result &= this.fListener.gained;
        if (!this.fListener.gained) {
            this.log.println("Gained focus was not notified about");
        }
        this.tRes.tested("addFocusListener()", result);
    }

    public void _removeFocusListener() {
        this.requiredMethod("addFocusListener()");
        this.oObj.removeFocusListener(this.fListener);
        this.fListener.init();
        this.oObj.setFocus();
        this.win.setFocus();
        this.oObj.setFocus();
        boolean res = !this.fListener.gained && !this.fListener.lost;
        this.tRes.tested("removeFocusListener()", res);
    }

    public void _addKeyListener() {
        this.oObj.addKeyListener(this.kListener);
        this.tRes.tested("addKeyListener()", true);
    }

    public void _removeKeyListener() {
        this.requiredMethod("addKeyListener()");
        this.oObj.removeKeyListener(this.kListener);
        this.tRes.tested("removeKeyListener()", true);
    }

    public void _addMouseListener() {
        this.oObj.addMouseListener(this.mListener);
        this.tRes.tested("addMouseListener()", true);
    }

    public void _removeMouseListener() {
        this.requiredMethod("addMouseListener()");
        this.oObj.removeMouseListener(this.mListener);
        this.tRes.tested("removeMouseListener()", true);
    }

    public void _addMouseMotionListener() {
        this.oObj.addMouseMotionListener(this.mmListener);
        this.tRes.tested("addMouseMotionListener()", true);
    }

    public void _removeMouseMotionListener() {
        this.requiredMethod("addMouseMotionListener()");
        this.oObj.removeMouseMotionListener(this.mmListener);
        this.tRes.tested("removeMouseMotionListener()", true);
    }

    public void _addPaintListener() {
        this.oObj.addPaintListener(this.pListener);
        this.tRes.tested("addPaintListener()", true);
    }

    public void _removePaintListener() {
        this.requiredMethod("addPaintListener()");
        this.oObj.removePaintListener(this.pListener);
        this.tRes.tested("removePaintListener()", true);
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class TestPaintListener
    implements XPaintListener {
        public boolean paint = false;

        @Override
        public void windowPaint(PaintEvent e) {
            this.paint = true;
        }

        @Override
        public void disposing(EventObject e) {
        }

        public void init() {
            this.paint = false;
        }
    }

    public class TestMouseMotionListener
    implements XMouseMotionListener {
        public boolean dragged = false;
        public boolean moved = false;

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dragged = true;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.moved = true;
        }

        @Override
        public void disposing(EventObject e) {
        }

        public void init() {
            this.dragged = false;
            this.moved = false;
        }
    }

    public class TestMouseListener
    implements XMouseListener {
        public boolean pressed = false;
        public boolean released = false;
        public boolean entered = false;
        public boolean exited = false;

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.released = true;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.entered = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.exited = true;
        }

        @Override
        public void disposing(EventObject e) {
        }

        public void init() {
            this.pressed = false;
            this.released = false;
            this.exited = false;
            this.entered = false;
        }
    }

    public class TestKeyListener
    implements XKeyListener {
        public boolean pressed = false;
        public boolean released = false;

        @Override
        public void keyPressed(KeyEvent e) {
            this.pressed = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.released = true;
        }

        @Override
        public void disposing(EventObject e) {
        }

        public void init() {
            this.pressed = false;
            this.released = false;
        }
    }

    public class TestFocusListener
    implements XFocusListener {
        public boolean gained = false;
        public boolean lost = false;

        @Override
        public void focusGained(FocusEvent e) {
            this.gained = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.lost = true;
        }

        public void init() {
            this.gained = false;
            this.lost = false;
        }

        @Override
        public void disposing(EventObject e) {
        }
    }

    public class TestWindowListener
    implements XWindowListener {
        public boolean resized = false;
        public boolean moved = false;
        public boolean hidden = false;
        public boolean shown = false;

        public void init() {
            this.resized = false;
            this.moved = false;
            this.hidden = false;
            this.shown = false;
        }

        @Override
        public void windowResized(WindowEvent e) {
            this.resized = true;
        }

        @Override
        public void windowMoved(WindowEvent e) {
            this.moved = true;
        }

        @Override
        public void windowHidden(EventObject e) {
            this.hidden = true;
        }

        @Override
        public void windowShown(EventObject e) {
            this.shown = true;
        }

        @Override
        public void disposing(EventObject e) {
        }
    }
}

