/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.awt.XMenuBar;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import util.WriterTools;

public class _XTopWindow
extends MultiMethodTest {
    public XTopWindow oObj = null;
    protected TestListener listener = null;
    XTextDocument aTextDoc = null;

    @Override
    protected void before() {
        this.aTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)this.tParam.getMSF());
    }

    public void _addTopWindowListener() {
        this.listener = new TestListener(this.log);
        this.oObj.addTopWindowListener(this.listener);
        this.tRes.tested("addTopWindowListener()", true);
    }

    public void _removeTopWindowListener() {
        this.executeMethod("toBack()");
        this.oObj.removeTopWindowListener(this.listener);
        this.tRes.tested("removeTopWindowListener()", true);
    }

    public void _toFront() {
        this.requiredMethod("addTopWindowListener()");
        this.listener.initListener();
        this.oObj.toFront();
        this.shortWait();
        this.tRes.tested("toFront()", this.listener.activated && !this.listener.deactivated);
    }

    public void _toBack() {
        this.oObj.toBack();
        this.tRes.tested("toBack()", true);
    }

    public void _setMenuBar() {
        XMenuBar menu = null;
        boolean result = true;
        try {
            menu = UnoRuntime.queryInterface(XMenuBar.class, ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.awt.MenuBar"));
        }
        catch (Exception e) {
            this.log.println("Can't instanciate MenuBar service");
            result = false;
        }
        menu.insertItem((short)1, "MenuItem", (short)1, (short)1);
        this.oObj.setMenuBar(menu);
        this.tRes.tested("setMenuBar()", result);
    }

    @Override
    protected void after() {
        this.aTextDoc.dispose();
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    protected class TestListener
    implements XTopWindowListener {
        private PrintWriter log = null;
        public boolean activated = false;
        public boolean deactivated = false;

        public TestListener(PrintWriter log) {
            this.log = log;
        }

        public void initListener() {
            this.activated = false;
            this.deactivated = false;
        }

        @Override
        public void windowOpened(EventObject e) {
            this.log.println("windowOpened() called");
        }

        @Override
        public void windowClosing(EventObject e) {
            this.log.println("windowClosing() called");
        }

        @Override
        public void windowClosed(EventObject e) {
            this.log.println("windowClosed() called");
        }

        @Override
        public void windowMinimized(EventObject e) {
            this.log.println("windowMinimized() called");
        }

        @Override
        public void windowNormalized(EventObject e) {
            this.log.println("windowNormalized() called");
        }

        @Override
        public void windowActivated(EventObject e) {
            this.activated = true;
            this.log.println("windowActivated() called");
        }

        @Override
        public void windowDeactivated(EventObject e) {
            this.deactivated = true;
            this.log.println("windowDeactivated() called");
        }

        @Override
        public void disposing(EventObject e) {
        }
    }
}

