/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.AdjustmentEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XSpinValue;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.FormTools;

public class _XSpinValue
extends MultiMethodTest {
    public XSpinValue oObj;
    public boolean adjusted = false;
    XAdjustmentListener listener = new AdjustmentListener();

    public void _addAdjustmentListener() {
        FormTools.switchDesignOf((XMultiServiceFactory)this.tParam.getMSF(), (XTextDocument)this.tEnv.getObjRelation("Document"));
        this.shortWait();
        this.oObj.addAdjustmentListener(this.listener);
        this.adjustScrollBar();
        boolean res = this.adjusted;
        this.oObj.removeAdjustmentListener(this.listener);
        this.adjusted = false;
        this.adjustScrollBar();
        this.tRes.tested("addAdjustmentListener()", res &= !this.adjusted);
    }

    public void _removeAdjustmentListener() {
        this.requiredMethod("addAdjustmentListener()");
        this.tRes.tested("removeAdjustmentListener()", true);
    }

    public void _setSpinIncrement() {
        this.oObj.setSpinIncrement(15);
        this.oObj.setSpinIncrement(5);
        int bi = this.oObj.getSpinIncrement();
        this.tRes.tested("setSpinIncrement()", bi == 5);
    }

    public void _getSpinIncrement() {
        this.requiredMethod("setSpinIncrement()");
        this.tRes.tested("getSpinIncrement()", true);
    }

    public void _setMaximum() {
        this.oObj.setMaximum(490);
        this.oObj.setMaximum(480);
        int max = this.oObj.getMaximum();
        this.tRes.tested("setMaximum()", max == 480);
    }

    public void _getMaximum() {
        this.requiredMethod("setMaximum()");
        this.tRes.tested("getMaximum()", true);
    }

    public void _setMinimum() {
        this.oObj.setMinimum(90);
        this.oObj.setMinimum(80);
        int max = this.oObj.getMinimum();
        this.tRes.tested("setMinimum()", max == 80);
    }

    public void _getMinimum() {
        this.requiredMethod("setMinimum()");
        this.tRes.tested("getMinimum()", true);
    }

    public void _setOrientation() {
        boolean res = true;
        try {
            this.oObj.setOrientation(0);
            this.oObj.setOrientation(1);
        }
        catch (NoSupportException e) {
            this.log.println("Couldn't set Orientation");
        }
        int ori = this.oObj.getOrientation();
        this.tRes.tested("setOrientation()", res &= ori == 1);
    }

    public void _getOrientation() {
        this.requiredMethod("setOrientation()");
        this.tRes.tested("getOrientation()", true);
    }

    public void _setValue() {
        this.oObj.setMaximum(600);
        this.oObj.setValue(480);
        this.oObj.setValue(520);
        int val = this.oObj.getValue();
        this.tRes.tested("setValue()", val == 520);
    }

    public void _getValue() {
        this.requiredMethod("setValue()");
        this.tRes.tested("getValue()", true);
    }

    public void _setValues() {
        this.oObj.setValues(80, 200, 180);
        this.oObj.setValues(70, 210, 200);
        int val = this.oObj.getValue();
        int min = this.oObj.getMinimum();
        int max = this.oObj.getMaximum();
        this.tRes.tested("setValues()", min == 70 && max == 210 && val == 200);
    }

    private void adjustScrollBar() {
        XSpinValue sv = UnoRuntime.queryInterface(XSpinValue.class, (Object)this.tEnv.getTestObject());
        sv.setValue(500);
        this.shortWait();
        XAccessible acc = UnoRuntime.queryInterface(XAccessible.class, (Object)this.tEnv.getTestObject());
        XAccessibleComponent aCom = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)acc.getAccessibleContext());
        Point location = aCom.getLocationOnScreen();
        try {
            Robot rob = new Robot();
            rob.mouseMove(location.X + 20, location.Y + 10);
            rob.mousePress(16);
            rob.mouseRelease(16);
        }
        catch (AWTException e) {
            System.out.println("couldn't adjust scrollbar");
        }
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class AdjustmentListener
    implements XAdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            System.out.println("Adjustment Value changed");
            System.out.println("AdjustmentEvent: " + adjustmentEvent.Value);
            _XSpinValue.this.adjusted = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            System.out.println("Listener disposed");
        }
    }
}

