/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.awt.AdjustmentEvent;
import com.sun.star.awt.Point;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XScrollBar;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import util.FormTools;

public class _XScrollBar
extends MultiMethodTest {
    public XScrollBar oObj;
    public boolean adjusted = false;
    XAdjustmentListener listener = new AdjustmentListener();

    public void _addAdjustmentListener() {
        FormTools.switchDesignOf((XMultiServiceFactory)this.tParam.getMSF(), (XTextDocument)this.tEnv.getObjRelation("Document"));
        this.shortWait();
        this.oObj.addAdjustmentListener(this.listener);
        this.adjustScrollBar();
        boolean res = this.adjusted;
        this.oObj.removeAdjustmentListener(this.listener);
        this.adjusted = false;
        this.adjustScrollBar();
        this.tRes.tested("addAdjustmentListener()", res &= !this.adjusted);
    }

    public void _removeAdjustmentListener() {
        this.requiredMethod("addAdjustmentListener()");
        this.tRes.tested("removeAdjustmentListener()", true);
    }

    public void _setBlockIncrement() {
        this.oObj.setBlockIncrement(15);
        this.oObj.setBlockIncrement(5);
        int bi = this.oObj.getBlockIncrement();
        this.tRes.tested("setBlockIncrement()", bi == 5);
    }

    public void _getBlockIncrement() {
        this.requiredMethod("setBlockIncrement()");
        this.tRes.tested("getBlockIncrement()", true);
    }

    public void _setLineIncrement() {
        this.oObj.setLineIncrement(12);
        this.oObj.setLineIncrement(2);
        int li = this.oObj.getLineIncrement();
        this.tRes.tested("setLineIncrement()", li == 2);
    }

    public void _getLineIncrement() {
        this.requiredMethod("setLineIncrement()");
        this.tRes.tested("getLineIncrement()", true);
    }

    public void _setMaximum() {
        this.oObj.setMaximum(490);
        this.oObj.setMaximum(480);
        int max = this.oObj.getMaximum();
        this.tRes.tested("setMaximum()", max == 480);
    }

    public void _getMaximum() {
        this.requiredMethod("setMaximum()");
        this.tRes.tested("getMaximum()", true);
    }

    public void _setOrientation() {
        this.oObj.setOrientation(0);
        this.oObj.setOrientation(1);
        int ori = this.oObj.getOrientation();
        this.tRes.tested("setOrientation()", ori == 1);
    }

    public void _getOrientation() {
        this.requiredMethod("setOrientation()");
        this.tRes.tested("getOrientation()", true);
    }

    public void _setValue() {
        this.oObj.setMaximum(600);
        this.oObj.setValue(480);
        this.oObj.setValue(520);
        int val = this.oObj.getValue();
        this.tRes.tested("setValue()", val == 520);
    }

    public void _getValue() {
        this.requiredMethod("setValue()");
        this.tRes.tested("getValue()", true);
    }

    public void _setVisibleSize() {
        this.oObj.setVisibleSize(700);
        this.oObj.setVisibleSize(500);
        int vs = this.oObj.getVisibleSize();
        this.tRes.tested("setVisibleSize()", vs == 500);
    }

    public void _getVisibleSize() {
        this.requiredMethod("setVisibleSize()");
        this.tRes.tested("getVisibleSize()", true);
    }

    public void _setValues() {
        this.oObj.setValues(80, 200, 300);
        this.oObj.setValues(70, 210, 500);
        int val = this.oObj.getValue();
        int vs = this.oObj.getVisibleSize();
        int max = this.oObj.getMaximum();
        this.tRes.tested("setValues()", val == 70 && vs == 210 && max == 500);
    }

    private void adjustScrollBar() {
        XScrollBar sc = UnoRuntime.queryInterface(XScrollBar.class, (Object)this.tEnv.getTestObject());
        sc.setValue(500);
        this.shortWait();
        XAccessible acc = UnoRuntime.queryInterface(XAccessible.class, (Object)this.tEnv.getTestObject());
        XAccessibleComponent aCom = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)acc.getAccessibleContext());
        Point location = aCom.getLocationOnScreen();
        try {
            Robot rob = new Robot();
            rob.mouseMove(location.X + 50, location.Y + 75);
            rob.mousePress(16);
            rob.mouseRelease(16);
        }
        catch (AWTException e) {
            System.out.println("couldn't adjust scrollbar");
        }
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class AdjustmentListener
    implements XAdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            System.out.println("Adjustment Value changed");
            System.out.println("AdjustmentEvent: " + adjustmentEvent.Value);
            _XScrollBar.this.adjusted = true;
        }

        @Override
        public void disposing(EventObject eventObject) {
            System.out.println("Listener disposed");
        }
    }
}

