/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.lang.EventObject;
import lib.MultiMethodTest;
import lib.Status;

public class _XListBox
extends MultiMethodTest {
    public XListBox oObj = null;
    TestActionListener actionListener = new TestActionListener();
    TestItemListener itemListener = new TestItemListener();
    short lineCount = 0;
    short itemCount = 0;

    @Override
    public void before() {
        this.itemCount = this.oObj.getItemCount();
    }

    public void _addItemListener() {
        this.oObj.addItemListener(this.itemListener);
        this.tRes.tested("addItemListener()", Status.skipped(true));
    }

    public void _removeItemListener() {
        this.requiredMethod("addItemListener()");
        this.oObj.removeItemListener(this.itemListener);
        this.tRes.tested("removeItemListener()", Status.skipped(true));
    }

    public void _addActionListener() {
        this.oObj.addActionListener(this.actionListener);
        this.tRes.tested("addActionListener()", Status.skipped(true));
    }

    public void _removeActionListener() {
        this.requiredMethod("addActionListener()");
        this.oObj.removeActionListener(this.actionListener);
        this.tRes.tested("removeActionListener()", Status.skipped(true));
    }

    public void _addItem() {
        this.requiredMethod("getItemCount()");
        boolean result = true;
        this.oObj.addItem("Item1", this.itemCount);
        result = this.oObj.getItemCount() == this.itemCount + 1;
        this.tRes.tested("addItem()", result);
    }

    public void _addItems() {
        this.executeMethod("addItem()");
        boolean result = true;
        short oldCnt = this.oObj.getItemCount();
        this.oObj.addItems(new String[]{"Item2", "Item3"}, oldCnt);
        result = this.oObj.getItemCount() == oldCnt + 2;
        this.tRes.tested("addItems()", result);
    }

    public void _removeItems() {
        this.executeMethod("getItems()");
        this.executeMethod("getItem()");
        this.executeMethod("getSelectedItemPos()");
        this.executeMethod("getSelectedItemsPos()");
        this.executeMethod("getSelectedItem()");
        this.executeMethod("getSelectedItems()");
        boolean result = true;
        short oldCnt = this.oObj.getItemCount();
        this.oObj.removeItems((short)0, oldCnt);
        result = this.oObj.getItemCount() == 0;
        this.tRes.tested("removeItems()", result);
    }

    public void _getItemCount() {
        this.itemCount = this.oObj.getItemCount();
        this.tRes.tested("getItemCount()", this.itemCount >= 0);
    }

    public void _getItem() {
        this.requiredMethod("addItems()");
        boolean result = true;
        String item = this.oObj.getItem(this.itemCount);
        result = "Item1".equals(item);
        this.tRes.tested("getItem()", result);
    }

    public void _getItems() {
        this.requiredMethod("addItems()");
        boolean result = true;
        String[] items = this.oObj.getItems();
        for (int i = this.itemCount; i < this.itemCount + 3; ++i) {
            result &= ("Item" + (i + 1 - this.itemCount)).equals(items[i]);
        }
        this.tRes.tested("getItems()", result);
    }

    public void _getDropDownLineCount() {
        boolean result = true;
        this.lineCount = this.oObj.getDropDownLineCount();
        this.tRes.tested("getDropDownLineCount()", result);
    }

    public void _setDropDownLineCount() {
        this.requiredMethod("getDropDownLineCount()");
        boolean result = true;
        this.oObj.setDropDownLineCount((short)(this.lineCount + 1));
        result = this.oObj.getDropDownLineCount() == this.lineCount + 1;
        this.tRes.tested("setDropDownLineCount()", result);
    }

    public void _getSelectedItemPos() {
        this.requiredMethod("addItems()");
        boolean result = true;
        this.oObj.selectItemPos((short)1, true);
        short pos = this.oObj.getSelectedItemPos();
        result = pos == 1;
        this.tRes.tested("getSelectedItemPos()", result);
    }

    public void _getSelectedItemsPos() {
        this.requiredMethod("selectItemsPos()");
        boolean result = true;
        short cnt = this.oObj.getItemCount();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            this.oObj.selectItemPos(i, false);
        }
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        short[] items = this.oObj.getSelectedItemsPos();
        result = items != null && items.length == 2 && items[0] == 0 && items[1] == 2;
        this.tRes.tested("getSelectedItemsPos()", result);
    }

    public void _getSelectedItem() {
        this.requiredMethod("addItems()");
        boolean result = true;
        short cnt = this.oObj.getItemCount();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            this.oObj.selectItemPos(i, false);
        }
        this.oObj.selectItem("Item3", true);
        String item = this.oObj.getSelectedItem();
        result = "Item3".equals(item);
        this.tRes.tested("getSelectedItem()", result);
    }

    public void _getSelectedItems() {
        this.requiredMethod("selectItemsPos()");
        this.requiredMethod("getItem()");
        boolean result = true;
        short cnt = this.oObj.getItemCount();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            this.oObj.selectItemPos(i, false);
        }
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        String[] items = this.oObj.getSelectedItems();
        result = items != null && items.length == 2 && this.oObj.getItem((short)0).equals(items[0]) && this.oObj.getItem((short)2).equals(items[1]);
        this.tRes.tested("getSelectedItems()", result);
    }

    public void _selectItemPos() {
        this.requiredMethod("addItems()");
        boolean result = true;
        short cnt = this.oObj.getItemCount();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            this.oObj.selectItemPos(i, false);
        }
        this.oObj.selectItemPos((short)1, true);
        this.tRes.tested("selectItemPos()", result);
    }

    public void _selectItemsPos() {
        this.requiredMethod("addItems()");
        this.requiredMethod("setMultipleMode()");
        boolean result = true;
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        this.tRes.tested("selectItemsPos()", result);
    }

    public void _selectItem() {
        this.requiredMethod("addItems()");
        boolean result = true;
        this.oObj.selectItem("Item3", true);
        this.tRes.tested("selectItem()", result);
    }

    public void _isMutipleMode() {
        this.requiredMethod("setMultipleMode()");
        boolean result = true;
        result = this.oObj.isMutipleMode();
        this.tRes.tested("isMutipleMode()", result);
    }

    public void _setMultipleMode() {
        boolean result = true;
        this.oObj.setMultipleMode(true);
        this.tRes.tested("setMultipleMode()", result);
    }

    public void _makeVisible() {
        this.requiredMethod("addItems()");
        boolean result = true;
        this.oObj.makeVisible((short)2);
        this.tRes.tested("makeVisible()", result);
    }

    protected class TestItemListener
    implements XItemListener {
        public boolean disposingCalled = false;
        public boolean itemStateChangedCalled = false;

        protected TestItemListener() {
        }

        @Override
        public void disposing(EventObject e) {
            this.disposingCalled = true;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.itemStateChangedCalled = true;
        }
    }

    protected class TestActionListener
    implements XActionListener {
        public boolean disposingCalled = false;
        public boolean actionPerformedCalled = false;

        protected TestActionListener() {
        }

        @Override
        public void disposing(EventObject e) {
            this.disposingCalled = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionPerformedCalled = true;
        }
    }
}

