/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessibleValue;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XAccessibleValue
extends MultiMethodTest {
    public XAccessibleValue oObj = null;
    private double minVal = 0.0;
    private double maxVal = 0.0;
    private double curVal = 0.0;
    private Object val = null;
    XAccessibleValue anotherFromGroup = null;

    @Override
    protected void before() {
        this.anotherFromGroup = (XAccessibleValue)this.tEnv.getObjRelation("XAccessibleValue.anotherFromGroup");
    }

    public void _getCurrentValue() {
        double curVal;
        this.executeMethod("getMaximumValue()");
        this.executeMethod("getMinimumValue()");
        boolean result = true;
        this.val = this.oObj.getCurrentValue();
        if (utils.isVoid(this.val)) {
            this.val = new Integer(0);
            curVal = 0.0;
        } else {
            curVal = this.getDoubleValue(this.val);
        }
        if (curVal < this.minVal || this.maxVal < curVal) {
            this.log.println("" + (curVal - this.minVal) + "," + (this.maxVal - curVal));
            this.log.println("Current value " + curVal + " is not in range [" + this.minVal + "," + this.maxVal + "]");
            result = false;
        }
        this.tRes.tested("getCurrentValue()", result);
    }

    public void _setCurrentValue() {
        this.executeMethod("getCurrentValue()");
        boolean result = true;
        boolean partResult = true;
        String noMax = "com.sun.star.comp.toolkit.AccessibleScrollBar";
        String implName = utils.getImplName(this.oObj);
        if (this.tEnv.getObjRelation("ValueNotPersitent") != null) {
            this.log.println("Excluded since it works like AccessibleAction");
            this.tRes.tested("setCurrentValue()", Status.skipped(true));
            return;
        }
        if (this.anotherFromGroup == null) {
            double newVal = this.curVal + 1.0;
            if (newVal > this.maxVal) {
                newVal -= 2.0;
            }
            if (newVal < this.minVal) {
                newVal += 1.0;
            }
            this.log.println("New value is " + newVal);
            Object setVal = this.getObjectValue(newVal, this.val.getClass());
            if (!(result &= this.oObj.setCurrentValue(setVal))) {
                this.log.println("The value can't be set");
                throw new StatusException(Status.skipped(true));
            }
            double resVal = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Res value is " + resVal);
            result &= Math.abs(newVal - resVal) < 1.0E-5;
            this.log.println("Checking min/max values");
            result &= this.oObj.setCurrentValue(this.getObjectValue(this.minVal, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.minVal, this.val.getClass()));
            resVal = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result min value is " + resVal);
            result &= Math.abs(this.minVal - resVal) < 1.0E-5;
            this.log.println("\t works: " + (Math.abs(this.minVal - resVal) < 1.0E-5));
            result &= this.oObj.setCurrentValue(this.getObjectValue(this.maxVal, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.maxVal, this.val.getClass()));
            resVal = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result max value is " + resVal);
            boolean bl = partResult = Math.abs(this.maxVal - resVal) < 1.0E-5;
            if (implName.equals(noMax)) {
                this.log.println("If one sets the maximum value of a scroll bar with XScrollBar::setMaximum(),then XScrollBar::getValue() returns the maximum value minus the visible size ofthe thumb");
                partResult = resVal > 10.0;
            }
            result &= partResult;
            this.log.println("\t works: " + partResult);
            this.log.println("Checking truncating of min/max values");
            this.oObj.setCurrentValue(this.getObjectValue(this.minVal - 1.0, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.minVal - 1.0, this.val.getClass()));
            resVal = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result min value is " + resVal);
            result &= Math.abs(this.minVal - resVal) < 1.0E-5;
            this.log.println("\t works: " + (Math.abs(this.minVal - resVal) < 1.0E-5));
            this.oObj.setCurrentValue(this.getObjectValue(this.maxVal + 1.0, this.val.getClass()));
            this.log.println("Setting to " + this.getObjectValue(this.maxVal + 1.0, this.val.getClass()));
            resVal = this.getDoubleValue(this.oObj.getCurrentValue());
            this.log.println("Result max value is " + resVal);
            boolean bl2 = partResult = Math.abs(this.maxVal - resVal) < 1.0E-5;
            if (implName.equals(noMax)) {
                this.log.println("If one sets the maximum value of a scroll bar with XScrollBar::setMaximum(),then XScrollBar::getValue() returns the maximum value minus the visible size ofthe thumb");
                partResult = resVal > 10.0;
            }
            result &= partResult;
            this.log.println("\t works: " + partResult);
        } else {
            int curValBase = this.getIntegerValue(this.val);
            Object valAnotherFromGroup = this.anotherFromGroup.getCurrentValue();
            int curValAnother = this.getIntegerValue(valAnotherFromGroup);
            this.log.println("Current value of base component: " + curValBase);
            this.log.println("Current value of another component from group: " + curValAnother);
            this.log.println("Set value of base component to " + curValAnother);
            if (this.tEnv.getTestCase().getObjectName().equals("AccessibleRadioButton")) {
                this.anotherFromGroup.setCurrentValue(new Integer(curValBase));
            } else {
                this.oObj.setCurrentValue(valAnotherFromGroup);
            }
            this.log.println("Checking of values...");
            int newValBase = this.getIntegerValue(this.oObj.getCurrentValue());
            int newValAnother = this.getIntegerValue(this.anotherFromGroup.getCurrentValue());
            this.log.println("New value of base component: " + newValBase);
            this.log.println("Expected value of base component: " + curValAnother);
            this.log.println("New value of another component from group: " + newValAnother);
            this.log.println("Expected value of another component from group: " + curValBase);
            result = newValBase == curValAnother && newValAnother == curValBase;
        }
        this.tRes.tested("setCurrentValue()", result);
    }

    public void _getMaximumValue() {
        this.requiredMethod("getMinimumValue()");
        boolean result = true;
        Object val = this.oObj.getMaximumValue();
        if (utils.isVoid(val)) {
            this.maxVal = Double.MAX_VALUE;
            result = false;
        } else {
            this.maxVal = this.getDoubleValue(val);
        }
        this.log.println("Max is " + val.getClass() + " = " + this.maxVal);
        this.tRes.tested("getMaximumValue()", result &= this.maxVal >= this.minVal);
    }

    public void _getMinimumValue() {
        boolean result = true;
        Object val = this.oObj.getMinimumValue();
        if (utils.isVoid(val)) {
            this.minVal = -1.7976931348623157E308;
            result = false;
        } else {
            this.minVal = this.getDoubleValue(val);
        }
        this.log.println("Min is " + val.getClass() + " = " + this.minVal);
        this.tRes.tested("getMinimumValue()", result);
    }

    private int getIntegerValue(Object val) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new StatusException(Status.failed("Unexpected value type: " + val.getClass()));
    }

    private double getDoubleValue(Object val) {
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Short) {
            return ((Short)val).doubleValue();
        }
        if (val instanceof Float) {
            return ((Float)val).doubleValue();
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (utils.isVoid(val)) {
            return Double.NaN;
        }
        throw new StatusException(Status.failed("Undetected value type: " + val.getClass()));
    }

    private Object getObjectValue(double val, Class clazz) {
        if (clazz.equals(Integer.class)) {
            return new Integer((int)val);
        }
        if (clazz.equals(Short.class)) {
            return new Short((short)val);
        }
        if (clazz.equals(Float.class)) {
            return new Float((float)val);
        }
        if (clazz.equals(Double.class)) {
            return new Double(val);
        }
        throw new StatusException(Status.failed("Unexpected class: " + clazz));
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

