/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.SysUtils;

public class _XAccessibleText
extends MultiMethodTest {
    public XAccessibleText oObj = null;
    protected Rectangle bounds = null;
    String text = null;
    String editOnly = null;
    Object LimitedBounds = null;
    Rectangle chBounds = null;
    int chCount = 0;

    @Override
    protected void before() {
        Object xat = this.tEnv.getObjRelation("XAccessibleText");
        XAccessibleComponent component = null;
        if (xat != null) {
            this.oObj = UnoRuntime.queryInterface(XAccessibleText.class, xat);
            component = UnoRuntime.queryInterface(XAccessibleComponent.class, xat);
        }
        this.text = (String)this.tEnv.getObjRelation("XAccessibleText.Text");
        if (this.text == null) {
            this.text = this.oObj.getText();
        }
        if (this.text.length() == 0) {
            throw new StatusException(Status.failed("The length of text must be greater than zero"));
        }
        this.editOnly = (String)this.tEnv.getObjRelation("EditOnly");
        this.LimitedBounds = this.tEnv.getObjRelation("LimitedBounds");
        if (component == null) {
            component = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.tEnv.getTestObject());
        }
        this.bounds = component.getBounds();
        this.log.println("Text is '" + this.text + "'");
        System.out.println("############################");
    }

    public void _getCaretPosition() {
        this.requiredMethod("getCharacterCount()");
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        boolean res = true;
        boolean sc = true;
        try {
            this.oObj.setCaretPosition(this.chCount - 1);
        }
        catch (IndexOutOfBoundsException ie) {
            // empty catch block
        }
        int carPos = this.oObj.getCaretPosition();
        this.log.println("getCaretPosition: " + carPos);
        if (sc) {
            res = carPos == this.chCount - 1;
        } else {
            this.log.println("Object is read only and Caret position couldn't be set");
            res = carPos == -1;
        }
        this.tRes.tested("getCaretPosition()", res);
    }

    public void _setCaretPosition() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        try {
            this.log.print("setCaretPosition(-1):");
            this.oObj.setCaretPosition(-1);
            res &= false;
            this.log.println("exception was expected ... FAILED");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("setCaretPosition(chCount+1):");
            this.oObj.setCaretPosition(this.chCount + 1);
            res &= false;
            this.log.println("exception was expected  ... FAILED");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.println("setCaretPosition(chCount - 1)");
            this.oObj.setCaretPosition(this.chCount - 1);
            res &= true;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception  ... FAILED");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("setCaretPosition()", res);
    }

    public void _getCharacter() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        try {
            this.log.println("getCharacter(-1)");
            this.oObj.getCharacter(-1);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res = true;
        }
        try {
            this.log.println("getCharacter(chCount)");
            this.oObj.getCharacter(this.chCount);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.println("Checking of every character in the text...");
            boolean isEqCh = true;
            for (int i = 0; i < this.chCount; ++i) {
                char ch = this.oObj.getCharacter(i);
                isEqCh = ch == this.text.charAt(i);
                res &= isEqCh;
                if (isEqCh) continue;
                this.log.println("At the position " + i + "was expected character: " + this.text.charAt(i));
                this.log.println("but was returned: " + ch);
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getCharacter()", res);
    }

    public void _getCharacterAttributes() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        String[] attr = new String[]{""};
        try {
            this.log.println("getCharacterAttributes(-1)");
            this.oObj.getCharacterAttributes(-1, attr);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.println("getCharacterAttributes(chCount)");
            this.oObj.getCharacterAttributes(this.chCount, attr);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.println("getCharacterAttributes(chCount-1)");
            PropertyValue[] props = this.oObj.getCharacterAttributes(this.chCount - 1, attr);
            res &= props != null;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getCharacterAttributes()", res);
    }

    public void _getCharacterBounds() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        int lastIndex = this.chCount;
        if (this.LimitedBounds != null) {
            lastIndex = this.LimitedBounds instanceof Integer ? (Integer)this.LimitedBounds : this.chCount - 1;
            this.log.println(this.LimitedBounds);
        }
        try {
            this.log.println("getCharacterBounds(-1)");
            this.oObj.getCharacterBounds(-1);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.println("getCharacterBounds(" + (lastIndex + 1) + ")");
            this.oObj.getCharacterBounds(lastIndex + 1);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            for (int i = 0; i < lastIndex; ++i) {
                this.log.println("getCharacterBounds(" + i + ")");
                this.chBounds = this.oObj.getCharacterBounds(i);
                boolean localres = true;
                localres = this.chBounds.X >= 0;
                localres &= this.chBounds.Y >= 0;
                localres &= this.chBounds.X + this.chBounds.Width <= this.bounds.Width;
                localres &= this.chBounds.X + this.chBounds.Width > 0;
                localres &= this.chBounds.Y + this.chBounds.Height <= this.bounds.Height;
                if (localres &= this.chBounds.Y + this.chBounds.Height > 0) continue;
                this.log.println("Text at this place: " + this.oObj.getCharacter(i));
                this.log.println("Character bounds outside component");
                this.log.println("Character rect: " + this.chBounds.X + ", " + this.chBounds.Y + ", " + this.chBounds.Width + ", " + this.chBounds.Height);
                this.log.println("Component rect: " + this.bounds.X + ", " + this.bounds.Y + ", " + this.bounds.Width + ", " + this.bounds.Height);
                res &= localres;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getCharacterBounds()", res);
    }

    public void _getCharacterCount() {
        this.chCount = this.oObj.getCharacterCount();
        this.log.println("Character count:" + this.chCount);
        boolean res = this.chCount == this.text.length();
        this.tRes.tested("getCharacterCount()", res);
    }

    public void _getIndexAtPoint() {
        boolean res = true;
        this.log.print("getIndexAtPoint(-1, -1):");
        Point pt = new Point(-1, -1);
        int index = this.oObj.getIndexAtPoint(pt);
        this.log.println(index);
        res &= index == -1;
        int lastIndex = this.chCount;
        if (this.LimitedBounds != null) {
            lastIndex = this.LimitedBounds instanceof Integer ? (Integer)this.LimitedBounds : this.chCount - 1;
            this.log.println(this.LimitedBounds);
        }
        for (int i = 0; i < lastIndex; ++i) {
            Rectangle aRect = null;
            String text = "empty";
            try {
                aRect = this.oObj.getCharacterBounds(i);
                text = this.oObj.getTextAtIndex((int)i, (short)1).SegmentText;
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            int x = aRect.X + aRect.Width / 2;
            int y = aRect.Y + aRect.Height / 2;
            Point aPoint = new Point(x, y);
            int nIndex = this.oObj.getIndexAtPoint(aPoint);
            x = aRect.X;
            y = aRect.Y + aRect.Height / 2;
            aPoint = new Point(x, y);
            int left = this.oObj.getIndexAtPoint(aPoint);
            int[] previous = (int[])this.tEnv.getObjRelation("PreviousUsed");
            if (previous != null) {
                for (int k = 0; k < previous.length; ++k) {
                    if (i != previous[k]) continue;
                    ++nIndex;
                }
            }
            if (nIndex == i || left == i) continue;
            this.log.println("## Method didn't work for Point (" + x + "," + y + ")");
            this.log.println("Expected Index " + i);
            this.log.println("Gained Index: " + nIndex);
            this.log.println("Left Border: " + left);
            this.log.println("CharacterAtIndex: " + text);
            res &= false;
        }
        this.tRes.tested("getIndexAtPoint()", res);
    }

    public void _getSelectedText() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean res = true;
        try {
            this.log.println("setSelection(0, 0)");
            this.oObj.setSelection(0, 0);
            this.log.print("getSelectedText():");
            String txt = this.oObj.getSelectedText();
            this.log.println("'" + txt + "'");
            res &= txt.length() == 0;
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            this.log.print("getSelectedText():");
            txt = this.oObj.getSelectedText();
            this.log.println("'" + txt + "'");
            res &= txt.equals(this.text);
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                this.log.print("getSelectedText():");
                txt = this.oObj.getSelectedText();
                this.log.println("'" + txt + "'");
                res &= txt.equals(this.text.substring(1, this.chCount - 1));
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getSelectedText()", res);
    }

    public void _getSelectionStart() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean res = true;
        try {
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            int start = this.oObj.getSelectionStart();
            this.log.println("getSelectionStart():" + start);
            res &= start == 0;
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                start = this.oObj.getSelectionStart();
                this.log.println("getSelectionStart():" + start);
                res &= start == 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getSelectionStart()", res);
    }

    public void _getSelectionEnd() {
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        this.requiredMethod("setSelection()");
        boolean res = true;
        try {
            this.log.println("setSelection(0, chCount)");
            this.oObj.setSelection(0, this.chCount);
            int end = this.oObj.getSelectionEnd();
            this.log.println("getSelectionEnd():" + end);
            res &= end == this.chCount;
            if (this.chCount > 2) {
                this.log.println("setSelection(1, chCount-1)");
                this.oObj.setSelection(1, this.chCount - 1);
                end = this.oObj.getSelectionEnd();
                this.log.println("getSelectionEnd():" + end);
                res &= end == this.chCount - 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getSelectionEnd()", res);
    }

    public void _setSelection() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        boolean locRes = true;
        if (this.editOnly != null) {
            this.log.println(this.editOnly);
            throw new StatusException(Status.skipped(true));
        }
        try {
            this.log.print("setSelection(-1, chCount-1):");
            locRes = this.oObj.setSelection(-1, this.chCount - 1);
            this.log.println(locRes + " excepion was expected");
            res &= !locRes;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.print("setSelection(0, chCount+1):");
            locRes = this.oObj.setSelection(0, this.chCount + 1);
            this.log.println(locRes + " excepion was expected");
            res &= !locRes;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            if (this.chCount > 2) {
                this.log.print("setSelection(1, chCount-1):");
                locRes = this.oObj.setSelection(1, this.chCount - 1);
                this.log.println(locRes);
                res &= locRes;
                this.log.print("setSelection(chCount-1, 1):");
                locRes = this.oObj.setSelection(this.chCount - 1, 1);
                this.log.println(locRes);
                res &= locRes;
            }
            this.log.print("setSelection(0, chCount-1):");
            locRes = this.oObj.setSelection(0, this.chCount - 1);
            this.log.println(locRes);
            res &= locRes;
            this.log.print("setSelection(chCount-1, 0):");
            locRes = this.oObj.setSelection(this.chCount - 1, 0);
            this.log.println(locRes);
            res &= locRes;
            this.log.print("setSelection(0, 0):");
            locRes = this.oObj.setSelection(0, 0);
            this.log.println(locRes);
            res &= locRes;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("setSelection()", res);
    }

    public void _getText() {
        String txt = this.oObj.getText();
        this.log.println("getText: " + txt);
        boolean res = txt.equals(this.text);
        this.tRes.tested("getText()", res);
    }

    public void _getTextRange() {
        this.requiredMethod("getCharacterCount()");
        boolean res = true;
        boolean locRes = true;
        String txtRange = "";
        try {
            if (this.chCount > 3) {
                this.log.print("getTextRange(1, chCount - 2): ");
                txtRange = this.oObj.getTextRange(1, this.chCount - 2);
                this.log.println(txtRange);
                locRes = txtRange.equals(this.text.substring(1, this.chCount - 2));
                res &= locRes;
                if (!locRes) {
                    this.log.println("Was expected: " + this.text.substring(1, this.chCount - 2));
                }
            }
            this.log.print("getTextRange(0, chCount-1): ");
            txtRange = this.oObj.getTextRange(0, this.chCount - 1);
            this.log.println(txtRange);
            locRes = txtRange.equals(this.text.substring(0, this.chCount - 1));
            res &= locRes;
            if (!locRes) {
                this.log.println("Was expected: " + this.text.substring(0, this.chCount - 1));
            }
            this.log.print("getTextRange(chCount, 0): ");
            txtRange = this.oObj.getTextRange(this.chCount, 0);
            this.log.println(txtRange);
            res &= txtRange.equals(this.text);
            this.log.print("getTextRange(0, 0): ");
            txtRange = this.oObj.getTextRange(0, 0);
            this.log.println(txtRange);
            locRes = txtRange.equals("");
            res &= locRes;
            if (!locRes) {
                this.log.println("Empty string was expected");
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        try {
            this.log.print("getTextRange(-1, chCount - 1): ");
            txtRange = this.oObj.getTextRange(-1, this.chCount - 1);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.print("getTextRange(0, chCount + 1): ");
            txtRange = this.oObj.getTextRange(0, this.chCount + 1);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.print("getTextRange(chCount+1, -1): ");
            txtRange = this.oObj.getTextRange(this.chCount + 1, -1);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        this.tRes.tested("getTextRange()", res);
    }

    public void _getTextAtIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment txt = null;
        boolean res = true;
        try {
            this.log.print("getTextAtIndex(-1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextAtIndex(-1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= false;
        }
        try {
            this.log.print("getTextAtIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextAtIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= false;
        }
        try {
            this.log.print("getTextAtIndex(chCount, AccessibleTextType.WORD):");
            txt = this.oObj.getTextAtIndex(this.chCount, (short)2);
            this.log.println("'" + txt.SegmentText + "'");
            res &= this.compareLength(0, txt.SegmentText);
            if (!this.tEnv.getTestCase().getObjectName().equals("SmGraphicAccessible")) {
                this.log.print("getTextAtIndex(1, AccessibleTextType.PARAGRAPH):");
                txt = this.oObj.getTextAtIndex(1, (short)4);
                this.log.println("'" + txt.SegmentText + "'");
                res &= this.compareStrings(this.text, txt.SegmentText);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getTextAtIndex()", res);
    }

    public void _getTextBeforeIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment txt = null;
        boolean res = true;
        try {
            this.log.print("getTextBeforeIndex(-1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBeforeIndex(-1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= false;
        }
        try {
            this.log.print("getTextBeforeIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBeforeIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= true;
        }
        try {
            if (!this.tEnv.getTestCase().getObjectName().equals("SmGraphicAccessible")) {
                this.log.print("getTextBeforeIndex(chCount, AccessibleTextType.WORD):");
                txt = this.oObj.getTextBeforeIndex(this.chCount, (short)2);
                this.log.println("'" + txt.SegmentText + "'");
                res &= this.compareLength(this.chCount, txt.SegmentText);
            }
            this.log.print("getTextBeforeIndex(1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBeforeIndex(1, (short)4);
            this.log.println("'" + txt.SegmentText + "'");
            res &= this.compareLength(0, txt.SegmentText);
            this.log.print("getTextBeforeIndex(chCount-1, AccessibleTextType.CHARACTER):");
            txt = this.oObj.getTextBeforeIndex(this.chCount - 1, (short)1);
            this.log.println("'" + txt.SegmentText + "'");
            res &= this.compareStrings(this.text.substring(this.chCount - 2, this.chCount - 1), txt.SegmentText);
            if (this.chCount > 2) {
                this.log.print("getTextBeforeIndex(2, AccessibleTextType.CHARACTER):");
                txt = this.oObj.getTextBeforeIndex(2, (short)1);
                this.log.println("'" + txt.SegmentText + "'");
                res &= this.compareStrings(this.text.substring(1, 2), txt.SegmentText);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getTextBeforeIndex()", res);
    }

    public void _getTextBehindIndex() {
        this.requiredMethod("getCharacterCount()");
        TextSegment txt = null;
        boolean res = true;
        try {
            this.log.print("getTextBehindIndex(-1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBehindIndex(-1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= true;
        }
        try {
            this.log.print("getTextBehindIndex(chCount+1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBehindIndex(this.chCount + 1, (short)4);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        catch (IllegalArgumentException e) {
            this.log.println("UnExpected exception");
            res &= true;
        }
        try {
            this.log.print("getTextBehindIndex(chCount, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBehindIndex(this.chCount, (short)4);
            this.log.println("'" + txt.SegmentText + "'");
            res &= txt.SegmentText.length() == 0;
            this.log.print("getTextBehindIndex(chCount-1, AccessibleTextType.PARAGRAPH):");
            txt = this.oObj.getTextBehindIndex(this.chCount - 1, (short)4);
            this.log.println("'" + txt.SegmentText + "'");
            res &= txt.SegmentText.length() == 0;
            this.log.print("getTextBehindIndex(1, AccessibleTextType.CHARACTER):");
            txt = this.oObj.getTextBehindIndex(1, (short)1);
            this.log.println("'" + txt.SegmentText + "'");
            res &= txt.SegmentText.equals(this.text.substring(2, 3));
            if (this.chCount > 2) {
                this.log.print("getTextBehindIndex(chCount-2, AccessibleTextType.CHARACTER):");
                txt = this.oObj.getTextBehindIndex(this.chCount - 2, (short)1);
                this.log.println("'" + txt.SegmentText + "'");
                res &= txt.SegmentText.equals(this.text.substring(this.chCount - 1, this.chCount));
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        catch (IllegalArgumentException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getTextBehindIndex()", res);
    }

    public void _copyText() {
        boolean res;
        block11: {
            res = true;
            boolean locRes = true;
            if (this.editOnly != null) {
                this.log.println(this.editOnly);
                throw new StatusException(Status.skipped(true));
            }
            try {
                this.log.print("copyText(-1,chCount):");
                this.oObj.copyText(-1, this.chCount);
                this.log.println("Exception was expected");
                res &= false;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Expected exception");
                res &= true;
            }
            try {
                this.log.print("copyText(0,chCount+1):");
                this.oObj.copyText(0, this.chCount + 1);
                this.log.println("Exception was expected");
                res &= false;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Expected exception");
                res &= true;
            }
            try {
                this.log.print("copyText(0,chCount):");
                locRes = this.oObj.copyText(0, this.chCount);
                this.log.println(locRes);
                res &= locRes;
                String cbText = null;
                try {
                    cbText = SysUtils.getSysClipboardText((XMultiServiceFactory)this.tParam.getMSF());
                }
                catch (Exception e) {
                    this.log.println("Couldn't access system clipboard :");
                    e.printStackTrace(this.log);
                }
                this.log.println("Clipboard: '" + cbText + "'");
                res &= this.text.equals(cbText);
                if (this.chCount <= 2) break block11;
                this.log.print("copyText(1,chCount-1):");
                locRes = this.oObj.copyText(1, this.chCount - 1);
                this.log.println(locRes);
                res &= locRes;
                try {
                    cbText = SysUtils.getSysClipboardText((XMultiServiceFactory)this.tParam.getMSF());
                }
                catch (Exception e) {
                    this.log.println("Couldn't access system clipboard :");
                    e.printStackTrace(this.log);
                }
                this.log.println("Clipboard: '" + cbText + "'");
                res &= this.text.substring(1, this.chCount - 1).equals(cbText);
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res &= false;
            }
        }
        this.tRes.tested("copyText()", res);
    }

    public boolean compareStrings(String expected, String getting) {
        boolean res = expected.equals(getting);
        if (!res) {
            this.log.println("## The result isn't the expected:");
            this.log.println("\tGetting: " + getting);
            this.log.println("\tExpected: " + expected);
        }
        return res;
    }

    public boolean compareLength(int expected, String getting) {
        boolean res;
        boolean bl = res = expected == getting.length();
        if (!res) {
            this.log.println("## The result isn't the expected:");
            this.log.println("\tGetting: " + getting.length());
            this.log.println("\tExpected: " + expected);
        }
        return res;
    }
}

