/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XAccessibleTable
extends MultiMethodTest {
    public XAccessibleTable oObj = null;
    XAccessibleSelection xASel = null;
    XAccessibleContext xACont = null;
    int rowCount = 0;
    int colCount = 0;
    XAccessible xCellAc = null;

    @Override
    protected void before() {
        this.xASel = UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)this.oObj);
        if (this.xASel == null) {
            this.log.println("The component doesn't implement the interface XAccessibleSelection.");
            this.log.println("This interface is required for more detailed tests.");
        }
        this.xACont = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)this.oObj);
    }

    public void _getAccessibleRowCount() {
        this.rowCount = this.oObj.getAccessibleRowCount();
        this.log.println("Accessible row count: " + this.rowCount);
        this.tRes.tested("getAccessibleRowCount()", true);
    }

    public void _getAccessibleColumnCount() {
        this.colCount = this.oObj.getAccessibleColumnCount();
        this.log.println("Accessible column count: " + this.colCount);
        this.tRes.tested("getAccessibleColumnCount()", true);
    }

    public void _getAccessibleRowDescription() {
        String descr;
        this.requiredMethod("getAccessibleRowCount()");
        boolean res = true;
        try {
            this.log.print("getAccessibleRowDescription(-1): ");
            descr = this.oObj.getAccessibleRowDescription(-1);
            this.log.println("'" + descr + "'");
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowDescription(" + this.rowCount + "): ");
            descr = this.oObj.getAccessibleRowDescription(this.rowCount);
            this.log.println("'" + descr + "'");
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowDescription(" + (this.rowCount - 1) + "): ");
            descr = this.oObj.getAccessibleRowDescription(this.rowCount - 1);
            res &= descr != null;
            this.log.println("'" + descr + "'");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleRowDescription()", res);
    }

    public void _getAccessibleColumnDescription() {
        String descr;
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        try {
            this.log.print("getAccessibleColumnDescription(-1): ");
            descr = this.oObj.getAccessibleColumnDescription(-1);
            this.log.println("'" + descr + "'");
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnDescription(" + this.colCount + "): ");
            descr = this.oObj.getAccessibleColumnDescription(this.colCount);
            this.log.println("'" + descr + "'");
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnDescription(" + (this.colCount - 1) + "): ");
            descr = this.oObj.getAccessibleColumnDescription(this.colCount - 1);
            res &= descr != null;
            this.log.println("'" + descr + "'");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleColumnDescription()", res);
    }

    public void _getAccessibleRowExtentAt() {
        int ext;
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        try {
            this.log.print("getAccessibleRowExtentAt(-1," + (this.colCount - 1) + "):");
            ext = this.oObj.getAccessibleRowExtentAt(-1, this.colCount - 1);
            this.log.println(ext);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + (this.rowCount - 1) + ",-1):");
            ext = this.oObj.getAccessibleRowExtentAt(this.rowCount - 1, -1);
            this.log.println(ext);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(0," + this.colCount + "):");
            int ext2 = this.oObj.getAccessibleRowExtentAt(0, this.colCount);
            this.log.println(ext2);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + this.rowCount + ",0):");
            int ext3 = this.oObj.getAccessibleRowExtentAt(this.rowCount, 0);
            this.log.println(ext3);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRowExtentAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "):");
            int ext4 = this.oObj.getAccessibleRowExtentAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(ext4);
            res &= ext4 >= 1;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleRowExtentAt()", res);
    }

    public void _getAccessibleColumnExtentAt() {
        int ext;
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        try {
            this.log.print("getAccessibleColumnExtentAt(-1," + (this.colCount - 1) + "):");
            ext = this.oObj.getAccessibleColumnExtentAt(-1, this.colCount - 1);
            this.log.println(ext);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + (this.rowCount - 1) + ",-1):");
            ext = this.oObj.getAccessibleColumnExtentAt(this.rowCount - 1, -1);
            this.log.println(ext);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(0," + this.colCount + "):");
            int ext2 = this.oObj.getAccessibleColumnExtentAt(0, this.colCount);
            this.log.println(ext2);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + this.rowCount + ",0):");
            int ext3 = this.oObj.getAccessibleColumnExtentAt(this.rowCount, 0);
            this.log.println(ext3);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumnExtentAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "):");
            int ext4 = this.oObj.getAccessibleColumnExtentAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(ext4);
            res &= ext4 >= 1;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleColumnExtentAt()", res);
    }

    public void _getAccessibleRowHeaders() {
        XAccessibleTable rowHeaders = this.oObj.getAccessibleRowHeaders();
        this.log.println("getAccessibleRowHeaders(): " + rowHeaders);
        this.tRes.tested("getAccessibleRowHeaders()", true);
    }

    public void _getAccessibleColumnHeaders() {
        XAccessibleTable colHeaders = this.oObj.getAccessibleColumnHeaders();
        this.log.println("getAccessibleColumnHeaders(): " + colHeaders);
        this.tRes.tested("getAccessibleColumnHeaders()", true);
    }

    public void _getSelectedAccessibleRows() {
        this.requiredMethod("getAccessibleRowCount()");
        boolean res = true;
        boolean locRes = true;
        int[] selRows = null;
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        this.log.println("getSelectedAccessibleRows()");
        selRows = this.oObj.getSelectedAccessibleRows();
        this.log.println("Length of the returned sequince: " + selRows.length);
        res = this.xASel != null ? (res &= selRows.length == this.rowCount) : (res &= selRows.length == 0);
        if (selRows.length > 0) {
            this.log.println("Checking that returned sequence is in ascending order");
        }
        for (int i = 1; i < selRows.length; ++i) {
            res &= (locRes &= selRows[i] >= selRows[i - 1]);
            if (locRes) continue;
            this.log.println("Element #" + i + ":" + selRows[i] + " is less than element #" + (i - 1) + ": " + selRows[i - 1]);
            break;
        }
        this.tRes.tested("getSelectedAccessibleRows()", res);
    }

    public void _getSelectedAccessibleColumns() {
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        boolean locRes = true;
        int[] selCols = null;
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        this.log.println("getSelectedAccessibleColumns()");
        selCols = this.oObj.getSelectedAccessibleColumns();
        this.log.println("Length of the returned sequince: " + selCols.length);
        res = this.xASel != null ? (res &= selCols.length == this.colCount) : (res &= selCols.length == 0);
        if (selCols.length > 0) {
            this.log.println("Checking that returned sequence is in ascending order");
        }
        for (int i = 1; i < selCols.length; ++i) {
            res &= (locRes &= selCols[i] >= selCols[i - 1]);
            if (locRes) continue;
            this.log.println("Element #" + i + ":" + selCols[i] + " is less than element #" + (i - 1) + ": " + selCols[i - 1]);
            break;
        }
        this.tRes.tested("getSelectedAccessibleColumns()", res);
    }

    public void _isAccessibleRowSelected() {
        this.requiredMethod("getAccessibleRowCount()");
        boolean res = true;
        boolean locRes = true;
        try {
            this.log.print("isAccessibleRowSelected(-1): ");
            locRes = this.oObj.isAccessibleRowSelected(-1);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("isAccessibleRowSelected(" + this.rowCount + "): ");
            locRes = this.oObj.isAccessibleRowSelected(this.rowCount);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.println("Checking of every row selection...");
            for (int i = 0; i < this.rowCount; ++i) {
                boolean isSel = this.oObj.isAccessibleRowSelected(i);
                locRes = this.xASel == null ? !isSel : isSel;
                res &= locRes;
                if (locRes) continue;
                this.log.println("isAccessibleRowSelected(" + i + "): " + isSel);
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("isAccessibleRowSelected()", res);
    }

    public void _isAccessibleColumnSelected() {
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        boolean locRes = true;
        try {
            this.log.print("isAccessibleColumnSelected(-1): ");
            locRes = this.oObj.isAccessibleColumnSelected(-1);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("isAccessibleColumnSelected(" + this.colCount + "): ");
            locRes = this.oObj.isAccessibleColumnSelected(this.colCount);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.println("Checking of every column selection...");
            for (int i = 0; i < this.colCount; ++i) {
                boolean isSel = this.oObj.isAccessibleColumnSelected(i);
                locRes = this.xASel == null ? !isSel : isSel;
                res &= locRes;
                if (locRes) continue;
                this.log.println("isAccessibleColumnSelected(" + i + "): " + isSel);
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("isAccessibleColumnSelected()", res);
    }

    public void _getAccessibleCellAt() {
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        try {
            this.log.print("getAccessibleCellAt(-1," + (this.colCount - 1) + "):");
            this.xCellAc = this.oObj.getAccessibleCellAt(-1, this.colCount - 1);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + (this.rowCount - 1) + ",-1):");
            this.xCellAc = this.oObj.getAccessibleCellAt(this.rowCount - 1, -1);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(0, " + this.colCount + "):");
            this.xCellAc = this.oObj.getAccessibleCellAt(0, this.colCount);
            this.log.println(this.xCellAc);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + this.rowCount + ",0):");
            XAccessible xCellAc = this.oObj.getAccessibleCellAt(this.rowCount, 0);
            this.log.println(xCellAc);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleCellAt(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            this.xCellAc = this.oObj.getAccessibleCellAt(this.rowCount - 1, this.colCount - 1);
            this.log.println(this.xCellAc);
            res &= this.xCellAc != null;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleCellAt()", res);
    }

    public void _getAccessibleCaption() {
        XAccessible caption = this.oObj.getAccessibleCaption();
        this.log.println("getAccessibleCaption(): " + caption);
        this.tRes.tested("getAccessibleCaption()", true);
    }

    public void _getAccessibleSummary() {
        XAccessible summary = this.oObj.getAccessibleSummary();
        this.log.println("getAccessibleSummary(): " + summary);
        this.tRes.tested("getAccessibleSummary()", true);
    }

    public void _isAccessibleSelected() {
        this.requiredMethod("getAccessibleRowCount()");
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        boolean locRes = true;
        try {
            this.log.print("isAccessibleSelected(-1," + (this.colCount - 1) + "):");
            locRes = this.oObj.isAccessibleSelected(-1, this.colCount - 1);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("isAccessibleSelected(" + (this.rowCount - 1) + ",-1):");
            locRes = this.oObj.isAccessibleSelected(this.rowCount - 1, -1);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("isAccessibleSelected(0, " + this.colCount + "):");
            locRes = this.oObj.isAccessibleSelected(0, this.colCount);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("isAccessibleSelected(" + this.rowCount + ",0):");
            locRes = this.oObj.isAccessibleSelected(this.rowCount, 0);
            this.log.println(locRes);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        if (this.xASel != null) {
            this.log.println("XAccessibleSelection.selectAllAccessibleChildren()");
            this.xASel.selectAllAccessibleChildren();
        }
        try {
            this.log.print("isAccessibleSelected(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            boolean isSel = this.oObj.isAccessibleSelected(this.rowCount - 1, this.colCount - 1);
            this.log.println(isSel);
            locRes = this.xASel == null ? !isSel : isSel;
            res &= locRes;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("isAccessibleSelected()", res);
    }

    public void _getAccessibleIndex() {
        int indx;
        this.executeMethod("getAccessibleCellAt()");
        boolean res = true;
        try {
            this.log.print("getAccessibleIndex(-1," + (this.colCount - 1) + "):");
            indx = this.oObj.getAccessibleIndex(-1, this.colCount - 1);
            this.log.println(indx);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + (this.rowCount - 1) + ",-1):");
            indx = this.oObj.getAccessibleIndex(this.rowCount - 1, -1);
            this.log.println(indx);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleIndex(0," + this.colCount + "):");
            int indx2 = this.oObj.getAccessibleIndex(0, this.colCount);
            this.log.println(indx2);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + this.rowCount + ",0):");
            int indx3 = this.oObj.getAccessibleIndex(this.rowCount, 0);
            this.log.println(indx3);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleIndex(" + (this.rowCount - 1) + "," + (this.colCount - 1) + "): ");
            int indx4 = this.oObj.getAccessibleIndex(this.rowCount - 1, this.colCount - 1);
            this.log.println(indx4);
            if (this.xCellAc != null) {
                XAccessibleContext xAC = this.xCellAc.getAccessibleContext();
                int expIndx = xAC.getAccessibleIndexInParent();
                this.log.println("Expected index: " + expIndx);
                res &= expIndx == indx4;
            } else {
                res &= true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleIndex()", res);
    }

    public void _getAccessibleRow() {
        this.requiredMethod("getAccessibleRowCount()");
        boolean res = true;
        if (this.xACont != null) {
            int rowIndx;
            int childCount = this.xACont.getAccessibleChildCount();
            this.log.println("accessible child count: " + childCount);
            try {
                this.log.print("getAccessibleRow(" + childCount + "): ");
                rowIndx = this.oObj.getAccessibleRow(childCount);
                this.log.println(rowIndx);
                this.log.println("Exception was expected");
                res &= false;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("expected exception");
                res &= true;
            }
            try {
                this.log.print("getAccessibleRow(" + (childCount - 1) + "): ");
                rowIndx = this.oObj.getAccessibleRow(childCount - 1);
                this.log.println(rowIndx);
                res &= rowIndx >= 0 && rowIndx <= this.rowCount;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res &= false;
            }
        }
        try {
            this.log.print("getAccessibleRow(-1): ");
            int rowIndx = this.oObj.getAccessibleRow(-1);
            this.log.println(rowIndx);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleRow(0): ");
            int rowIndx = this.oObj.getAccessibleRow(0);
            this.log.println(rowIndx);
            res &= rowIndx >= 0 && rowIndx <= this.rowCount;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleRow()", res);
    }

    public void _getAccessibleColumn() {
        this.requiredMethod("getAccessibleColumnCount()");
        boolean res = true;
        if (this.xACont != null) {
            int colIndx;
            int childCount = this.xACont.getAccessibleChildCount();
            this.log.println("accessible child count: " + childCount);
            try {
                this.log.print("getAccessibleColumn(" + childCount + "): ");
                colIndx = this.oObj.getAccessibleColumn(childCount);
                this.log.println(colIndx);
                this.log.println("Exception was expected");
                res &= false;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("expected exception");
                res &= true;
            }
            try {
                this.log.print("getAccessibleColumn(" + (childCount - 1) + "): ");
                colIndx = this.oObj.getAccessibleColumn(childCount - 1);
                this.log.println(colIndx);
                res &= colIndx >= 0 && colIndx <= this.colCount;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res &= false;
            }
        }
        try {
            this.log.print("getAccessibleColumn(-1): ");
            int colIndx = this.oObj.getAccessibleColumn(-1);
            this.log.println(colIndx);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception");
            res &= true;
        }
        try {
            this.log.print("getAccessibleColumn(0): ");
            int colIndx = this.oObj.getAccessibleColumn(0);
            this.log.println(colIndx);
            res &= colIndx >= 0 && colIndx <= this.rowCount;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("getAccessibleColumn()", res);
    }
}

