/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XAccessibleSelection
extends MultiMethodTest {
    private static final String className = "com.sun.star.accessibility.XAccessibleSelection";
    public XAccessibleSelection oObj = null;
    XAccessibleContext xAC = null;
    int childCount;
    protected boolean multiSelection = true;
    protected boolean OneAlwaysSelected = false;

    @Override
    protected String getTestedClassName() {
        return className;
    }

    @Override
    protected void before() {
        Boolean b2;
        this.xAC = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)this.oObj);
        if (this.xAC == null) {
            throw new StatusException(Status.failed("Couldn't query XAccessibleContext. Test must be modified"));
        }
        Boolean b = (Boolean)this.tEnv.getObjRelation("XAccessibleSelection.multiSelection");
        if (b != null) {
            this.multiSelection = b;
        }
        if ((b2 = (Boolean)this.tEnv.getObjRelation("XAccessibleSelection.OneAlwaysSelected")) != null) {
            this.OneAlwaysSelected = b2;
        }
        this.childCount = this.xAC.getAccessibleChildCount();
        this.log.println("Child count: " + this.childCount);
    }

    public void _selectAccessibleChild() {
        boolean res = true;
        try {
            this.log.println("Try to select child with index " + this.childCount);
            this.oObj.selectAccessibleChild(this.childCount);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res = true;
        }
        try {
            this.log.println("Try to select child with index -1");
            this.oObj.selectAccessibleChild(-1);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        this.log.println("ChildCount: " + this.childCount);
        int usedChilds = this.childCount;
        if (this.childCount > 500) {
            this.log.println("Restricting to 500");
            usedChilds = 500;
        }
        if (usedChilds > 0) {
            try {
                for (int i = 0; i < usedChilds; ++i) {
                    this.log.print("Trying to select child with index " + i + ": ");
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), i)) {
                        this.oObj.selectAccessibleChild(i);
                        this.log.println("OK");
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
                res &= true;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res = false;
            }
        }
        this.tRes.tested("selectAccessibleChild()", res);
    }

    public void _isAccessibleChildSelected() {
        this.executeMethod("selectAccessibleChild()");
        boolean res = true;
        boolean isSelected = false;
        try {
            this.log.print("isAccessibleChildSelected(-1)? ");
            isSelected = this.oObj.isAccessibleChildSelected(-1);
            this.log.println(res);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res = true;
        }
        try {
            this.log.print("isAccessibleChildSelected(" + this.childCount + ")? ");
            isSelected = this.oObj.isAccessibleChildSelected(this.childCount);
            this.log.println(isSelected);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        int SelectableChildCount = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (SelectableChildCount > 500) {
            SelectableChildCount = 500;
        }
        this.log.println("SelectableChildCount: " + SelectableChildCount);
        if (SelectableChildCount > 0) {
            try {
                this.oObj.selectAllAccessibleChildren();
                for (int k = 0; k < SelectableChildCount; ++k) {
                    this.log.println("Trying to select child with index " + k);
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), k)) {
                        this.oObj.selectAccessibleChild(k);
                        this.shortWait();
                        isSelected = this.oObj.isAccessibleChildSelected(k);
                        this.log.println("isAccessibleChildSelected - " + isSelected);
                        res &= isSelected;
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res = false;
            }
        }
        this.tRes.tested("isAccessibleChildSelected()", res);
    }

    public void _clearAccessibleSelection() {
        this.executeMethod("isAccessibleChildSelected()");
        boolean res = true;
        this.log.println("clearAccessibleSelection");
        this.oObj.clearAccessibleSelection();
        this.shortWait();
        if (this.childCount > 0 && !this.OneAlwaysSelected) {
            try {
                this.log.print("isAccessibleChildSelected(" + (this.childCount - 1) + ")? ");
                boolean isSel = this.oObj.isAccessibleChildSelected(this.childCount - 1);
                this.log.println(isSel);
                res = !isSel;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res = false;
            }
        } else if (this.OneAlwaysSelected) {
            this.log.println("Can't clear selection, one child is always selected");
        }
        this.tRes.tested("clearAccessibleSelection()", res);
    }

    public void _selectAllAccessibleChildren() {
        this.executeMethod("clearAccessibleSelection()");
        this.log.println("selectAllAccessibleChildren...");
        this.oObj.selectAllAccessibleChildren();
        this.shortWait();
        boolean res = true;
        boolean isSelected = true;
        int SelectableChildCount = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (SelectableChildCount > 0 && this.multiSelection) {
            try {
                this.log.print("isAccessibleChildSelected(1)? ");
                isSelected = this.oObj.isAccessibleChildSelected(1);
                this.log.println(isSelected);
                res = isSelected;
                this.log.print("isAccessibleChildSelected(" + (this.childCount - 1) + ")? ");
                isSelected = this.oObj.isAccessibleChildSelected(this.childCount - 1);
                this.log.println(isSelected);
                res &= isSelected;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res = false;
            }
        }
        this.tRes.tested("selectAllAccessibleChildren()", res);
    }

    public void _getSelectedAccessibleChildCount() {
        this.log.println("getSelectedAccessibleChildCount():");
        if (this.multiSelection) {
            this.oObj.selectAllAccessibleChildren();
        } else {
            int usedChilds = this.childCount;
            if (this.childCount > 500) {
                this.log.println("Restricting to 500");
                usedChilds = 500;
            }
            if (usedChilds > 0) {
                try {
                    for (int i = 0; i < usedChilds; ++i) {
                        if (!_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), i)) continue;
                        this.log.print("Trying to select child with index " + i + ": ");
                        this.oObj.selectAccessibleChild(i);
                        long curtime = System.currentTimeMillis();
                        long checktime = System.currentTimeMillis();
                        while (!this.oObj.isAccessibleChildSelected(i) && checktime - curtime < 5000L) {
                            checktime = System.currentTimeMillis();
                        }
                        this.log.println("OK");
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    this.log.println("Unexpected exception");
                    e.printStackTrace(this.log);
                }
            }
        }
        int sCount = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        this.log.println("Found " + sCount + " selectable Childs");
        int selectedCount = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("After selecting all accessible " + selectedCount + " are selected");
        boolean res = true;
        res = this.multiSelection ? (res &= selectedCount == sCount) : (res &= selectedCount == 1);
        this.log.println("clearAccessibleSelection...");
        this.oObj.clearAccessibleSelection();
        this.log.print("getSelectedAccessibleChildCount: ");
        selectedCount = this.oObj.getSelectedAccessibleChildCount();
        this.log.println(selectedCount);
        res = this.OneAlwaysSelected ? (res &= selectedCount == 1) : (res &= selectedCount == 0);
        this.tRes.tested("getSelectedAccessibleChildCount()", res);
    }

    public void _getSelectedAccessibleChild() {
        this.executeMethod("getSelectedAccessibleChildCount()");
        boolean res = true;
        int selectedCount = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount: " + selectedCount);
        try {
            this.log.println("getSelectedAccessibleChild(-1)");
            this.oObj.getSelectedAccessibleChild(-1);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res = true;
        }
        try {
            this.log.println("getSelectedAccessibleChild(" + selectedCount + ")");
            this.oObj.getSelectedAccessibleChild(selectedCount);
            this.log.println("Exception was expected");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        int SelectableChildCount = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
        if (SelectableChildCount > 500) {
            SelectableChildCount = 500;
        }
        if (SelectableChildCount > 0) {
            int k = 0;
            try {
                for (k = 0; k < SelectableChildCount; ++k) {
                    this.log.println("Trying to select child with index " + k);
                    if (_XAccessibleSelection.isSelectable(this.tEnv.getTestObject(), k)) {
                        this.oObj.selectAccessibleChild(k);
                        this.shortWait();
                        this.log.println("selected child count: " + this.oObj.getSelectedAccessibleChildCount());
                        XAccessible selChild = this.oObj.getSelectedAccessibleChild(0);
                        res &= selChild != null;
                        this.log.println("valid child - " + (selChild != null));
                        continue;
                    }
                    this.log.println("Child isn't selectable");
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception: Last relevant calls:\n \toObj.selectAccessibleChild(" + k + ")\n" + "\toObj.getSelectedAccessibleChild(0)");
                e.printStackTrace(this.log);
                res = false;
            }
        }
        this.tRes.tested("getSelectedAccessibleChild()", res);
    }

    public void _deselectAccessibleChild() {
        this.executeMethod("getSelectedAccessibleChild()");
        boolean res = true;
        int selCount = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount():" + selCount);
        try {
            this.log.println("deselectAccessibleChild(-1)");
            this.oObj.deselectAccessibleChild(-1);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        try {
            this.log.println("deselectAccessibleChild(" + (this.childCount + 1) + ")");
            this.oObj.deselectAccessibleChild(this.childCount + 1);
            this.log.println("Exception was expected");
            res = false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Expected exception");
            res &= true;
        }
        this.log.println("#################");
        this.log.println("Selecting all accessible");
        this.oObj.selectAllAccessibleChildren();
        selCount = this.oObj.getSelectedAccessibleChildCount();
        this.log.println("getSelectedAccessibleChildCount():" + selCount);
        if (this.childCount > 0 && selCount > 0) {
            try {
                int maxCount = _XAccessibleSelection.chkSelectable(this.tEnv.getTestObject());
                if (this.childCount > 100) {
                    maxCount = 100;
                }
                for (int k = 0; k < maxCount; ++k) {
                    this.log.println("deselectAccessibleChild(" + k + ")");
                    if (!this.oObj.isAccessibleChildSelected(k)) continue;
                    this.oObj.deselectAccessibleChild(k);
                }
                int newSelCount = this.oObj.getSelectedAccessibleChildCount();
                this.log.println("getSelectedAccessibleChildCount():" + newSelCount);
                if (this.OneAlwaysSelected && selCount == 1) {
                    this.log.println("One Child is always selected");
                    res &= true;
                } else {
                    res &= selCount > newSelCount;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("Unexpected exception");
                e.printStackTrace(this.log);
                res = false;
            }
        }
        this.tRes.tested("deselectAccessibleChild()", res);
    }

    protected static int chkSelectable(Object Testcase) {
        int ret = 0;
        XAccessibleContext accCon = UnoRuntime.queryInterface(XAccessibleContext.class, Testcase);
        int cc = accCon.getAccessibleChildCount();
        if (cc > 500) {
            return cc;
        }
        for (int i = 0; i < cc; ++i) {
            try {
                if (!accCon.getAccessibleChild(i).getAccessibleContext().getAccessibleStateSet().contains((short)22)) continue;
                ++ret;
                System.out.println("Child " + i + " is selectable");
                continue;
            }
            catch (IndexOutOfBoundsException iab) {
                // empty catch block
            }
        }
        return ret;
    }

    protected static boolean isSelectable(Object Testcase, int index) {
        XAccessibleContext accCon = UnoRuntime.queryInterface(XAccessibleContext.class, Testcase);
        boolean res = false;
        try {
            if (accCon.getAccessibleChild(index).getAccessibleContext().getAccessibleStateSet().contains((short)22)) {
                res = true;
            }
            if (accCon.getAccessibleChild(index).getAccessibleContext().getAccessibleRole() == 36 || accCon.getAccessibleChild(index).getAccessibleContext().getAccessibleRole() == 53) {
                res = false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Exception while checking for selectability");
        }
        return res;
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

