/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XAccessibleEventBroadcaster
extends MultiMethodTest {
    public XAccessibleEventBroadcaster oObj = null;
    public String EventMsg = "";
    public boolean destroy = false;
    EventProducer prod = null;
    EvListener list = new EvListener();

    @Override
    public void before() {
        this.prod = (EventProducer)this.tEnv.getObjRelation("EventProducer");
        if (this.prod == null) {
            throw new StatusException(Status.failed("Relation missed."));
        }
        this.EventMsg = (String)this.tEnv.getObjRelation("EventMsg");
        Object dp = this.tEnv.getObjRelation("Destroy");
        if (dp != null) {
            this.destroy = true;
        }
    }

    public void _addEventListener() {
        this.log.println("adding listener");
        this.oObj.addEventListener(this.list);
        boolean isTransient = _XAccessibleEventBroadcaster.chkTransient(this.tEnv.getTestObject());
        this.log.println("fire event");
        this.prod.fireEvent();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean works = true;
        if (this.list.notifiedEvent == null) {
            if (!isTransient) {
                this.log.println("listener wasn't called");
                works = false;
            } else {
                this.log.println("Object is Transient, listener isn't expected to be called");
            }
            this.oObj.removeEventListener(this.list);
        }
        if (this.EventMsg != null) {
            this.log.println(this.EventMsg);
            this.tRes.tested("addEventListener()", Status.skipped(true));
            return;
        }
        this.tRes.tested("addEventListener()", works);
    }

    public void _removeEventListener() {
        this.requiredMethod("addEventListener()");
        this.list.notifiedEvent = null;
        this.log.println("remove listener");
        this.oObj.removeEventListener(this.list);
        this.log.println("fire event");
        this.prod.fireEvent();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.list.notifiedEvent == null) {
            this.log.println("listener wasn't called -- OK");
        }
        this.tRes.tested("removeEventListener()", this.list.notifiedEvent == null);
    }

    protected static boolean chkTransient(Object Testcase) {
        boolean ret = false;
        XAccessibleContext accCon = UnoRuntime.queryInterface(XAccessibleContext.class, Testcase);
        if (accCon.getAccessibleStateSet().contains((short)28)) {
            if (!accCon.getAccessibleParent().getAccessibleContext().getAccessibleStateSet().contains((short)15)) {
                throw new StatusException(Status.failed("Parent doesn't manage descendents"));
            }
            ret = true;
        }
        return ret;
    }

    @Override
    protected void after() {
        if (this.destroy) {
            this.disposeEnvironment();
        }
    }

    private class EvListener
    implements XAccessibleEventListener {
        public AccessibleEventObject notifiedEvent = null;

        private EvListener() {
        }

        @Override
        public void notifyEvent(AccessibleEventObject ev) {
            Object nev;
            _XAccessibleEventBroadcaster.this.log.println("Listener, Event : " + ev.EventId);
            System.out.println("EventID: " + ev.EventId);
            Object old = ev.OldValue;
            if (old instanceof XAccessible) {
                System.out.println("Old: " + ((XAccessible)old).getAccessibleContext().getAccessibleName());
            }
            if ((nev = ev.NewValue) instanceof XAccessible) {
                System.out.println("New: " + ((XAccessible)nev).getAccessibleContext().getAccessibleName());
            }
            this.notifiedEvent = ev;
        }

        @Override
        public void disposing(EventObject ev) {
        }
    }

    public static interface EventProducer {
        public void fireEvent();
    }
}

