/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import lib.MultiMethodTest;
import util.ValueComparer;

public class _XAccessibleEditableText
extends MultiMethodTest {
    public XAccessibleEditableText oObj = null;
    String pasteText = null;
    String initialText = "";
    private boolean changeableAttr = true;

    @Override
    protected void before() {
        Boolean b = (Boolean)this.tEnv.getObjRelation("XAccessibleEditableText.hasAttr");
        if (b != null) {
            this.changeableAttr = b;
        }
        this.initialText = this.oObj.getText();
    }

    public void _cutText() {
        boolean res = true;
        boolean locRes = true;
        String curText = null;
        String oldText = this.oObj.getText();
        this.log.println("Text: '" + oldText + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Character count: " + length);
        try {
            this.log.print("cutText(-1," + (length - 1) + "): ");
            locRes = this.oObj.cutText(-1, length - 1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(oldText);
        }
        try {
            this.log.print("cutText(0," + (length + 1) + "): ");
            locRes = this.oObj.cutText(0, length + 1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(oldText);
        }
        try {
            this.pasteText = oldText;
            this.log.print("cutText(0," + length + "): ");
            locRes = this.oObj.cutText(0, length);
            this.log.println(locRes);
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.length() == 0 && locRes;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("cutText()", res);
    }

    public void _pasteText() {
        this.requiredMethod("cutText()");
        boolean res = true;
        boolean locRes = true;
        String curText = null;
        String text = this.oObj.getText();
        this.log.println("Text: '" + text + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Character count: " + length);
        try {
            this.log.print("pasteText(-1): ");
            locRes = this.oObj.pasteText(-1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("pasteText(" + (length + 1) + "): ");
            locRes = this.oObj.pasteText(length + 1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("pasteText(" + length + "): ");
            locRes = this.oObj.pasteText(length);
            this.log.println(locRes);
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text + this.pasteText) && locRes;
            this.log.println("Expected text: '" + text + this.pasteText + "'");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("pasteText()", res);
    }

    public void _deleteText() {
        this.executeMethod("insertText()");
        boolean res = true;
        boolean locRes = true;
        String curText = null;
        String text = this.oObj.getText();
        this.log.println("Text: '" + text + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Character count: " + length);
        try {
            this.log.print("deleteText(-1," + length + "): ");
            locRes = this.oObj.deleteText(-1, length);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("deleteText(0," + (length + 1) + "): ");
            locRes = this.oObj.deleteText(0, length + 1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            if (length >= 1) {
                this.log.print("deleteText(" + (length - 1) + "," + length + "): ");
                locRes = this.oObj.deleteText(length - 1, length);
                this.log.println(locRes);
                String expStr = text.substring(0, length - 1);
                curText = this.oObj.getText();
                this.log.println("Current text: '" + curText + "'");
                res &= curText.equals(expStr);
                this.log.println("Expected text: '" + expStr + "'");
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("deleteText()", res);
    }

    public void _insertText() {
        this.executeMethod("pasteText()");
        boolean res = true;
        boolean locRes = true;
        String curText = null;
        String text = this.oObj.getText();
        this.log.println("Text: '" + text + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Character count: " + length);
        String insStr = "Inserted string";
        try {
            this.log.print("insertText(insStr, -1): ");
            locRes = this.oObj.insertText("Inserted string", -1);
            this.log.println(locRes);
            this.log.println("exception was expected=> FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("insertText(insStr," + (length + 1) + "): ");
            locRes = this.oObj.insertText("Inserted string", length + 1);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("insertText(insStr," + length + "): ");
            locRes = this.oObj.insertText("Inserted string", length);
            this.log.println(locRes);
            curText = this.oObj.getText();
            res &= curText.equals(text + "Inserted string");
            this.log.println("Current text: '" + curText + "'");
            this.log.println("Expected text: '" + text + "Inserted string" + "'");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception => FAILED");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("insertText()", res);
    }

    public void _replaceText() {
        this.executeMethod("deleteText()");
        boolean res = true;
        boolean locRes = true;
        String curText = null;
        String sReplacement = "String for replace";
        String oldText = this.oObj.getText();
        int startIndx = oldText.length();
        this.oObj.setText(oldText + " part of string for replace");
        String text = this.oObj.getText();
        this.log.println("Text: '" + text + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Character count: " + length);
        try {
            this.log.print("replaceText(-1," + length + "): ");
            locRes = this.oObj.replaceText(-1, length, "String for replace");
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("replaceText(0," + (length + 1) + "): ");
            locRes = this.oObj.replaceText(0, length + 1, "String for replace");
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            res &= curText.equals(text);
        }
        try {
            this.log.print("replaceText(" + startIndx + "," + length + "): ");
            locRes = this.oObj.replaceText(startIndx, length, "String for replace");
            this.log.println(locRes);
            curText = this.oObj.getText();
            this.log.println("Current text: '" + curText + "'");
            this.log.println("Expected text: '" + oldText + "String for replace" + "'");
            res &= curText.equals(oldText + "String for replace");
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("replaceText()", res);
    }

    public void _setAttributes() {
        this.executeMethod("replaceText()");
        boolean res = true;
        boolean locRes = true;
        String text = this.oObj.getText();
        this.log.println("Text: '" + text + "'");
        int length = this.oObj.getCharacterCount();
        this.log.println("Length: " + length);
        PropertyValue[] attrs = null;
        try {
            attrs = this.oObj.getCharacterAttributes(0, new String[]{""});
            this.log.print("setAttributes(-1," + (length - 1) + "):");
            locRes = this.oObj.setAttributes(-1, length - 1, attrs);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            res &= true;
        }
        try {
            this.log.print("setAttributes(0," + (length + 1) + "):");
            locRes = this.oObj.setAttributes(0, length + 1, attrs);
            this.log.println(locRes);
            this.log.println("exception was expected => FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("expected exception => OK");
            res &= true;
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].Name.equals("CharColor")) continue;
            attrs[i].Value = new Integer(-2);
        }
        try {
            this.log.print("setAttributes(0," + length + "):");
            locRes = this.oObj.setAttributes(0, length, attrs);
            this.log.println(locRes);
            res &= this.changeableAttr && locRes || !this.changeableAttr && !locRes;
            if (this.changeableAttr) {
                this.log.print("checking that new attributes was set...");
                PropertyValue[] newAttrs = this.oObj.getCharacterAttributes(0, new String[]{""});
                locRes = ValueComparer.equalValue(attrs, newAttrs);
                this.log.println(locRes);
                res &= locRes;
            } else {
                this.log.println("Text attributes can't be changed.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("unexpected exception => FAILED");
            e.printStackTrace(this.log);
            res &= false;
        }
        this.tRes.tested("setAttributes()", res);
    }

    public void _setText() {
        this.executeMethod("setAttributes()");
        boolean res = true;
        boolean locRes = true;
        String oldText = this.oObj.getText();
        this.log.println("Current text: '" + oldText + "'");
        String newText = "New text";
        this.log.print("setText('" + newText + "'): ");
        locRes = this.oObj.setText(newText);
        this.log.println(locRes);
        String newCurText = this.oObj.getText();
        this.log.println("getText(): '" + newCurText + "'");
        res &= locRes && newCurText.equals(newText);
        newText = "";
        this.log.print("setText('" + newText + "'): ");
        locRes = this.oObj.setText(newText);
        this.log.println(locRes);
        newCurText = this.oObj.getText();
        this.log.println("getText(): '" + newCurText + "'");
        res &= locRes && newCurText.equals(newText);
        this.log.print("setText('" + oldText + "'): ");
        locRes = this.oObj.setText(oldText);
        this.log.println(locRes);
        newCurText = this.oObj.getText();
        this.log.println("getText(): '" + newCurText + "'");
        this.tRes.tested("setText()", res &= locRes && newCurText.equals(oldText));
    }

    @Override
    protected void after() {
        this.oObj.setText(this.initialText);
    }
}

