/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;
import util.AccessibilityTools;
import util.utils;

public class _XAccessibleContext
extends MultiMethodTest {
    private static final String className = "com.sun.star.accessibility.XAccessibleContext";
    public XAccessibleContext oObj = null;
    private int childCount = 0;
    private XAccessible parent = null;

    @Override
    protected String getTestedClassName() {
        return className;
    }

    public void _getAccessibleChildCount() {
        this.childCount = this.oObj.getAccessibleChildCount();
        this.log.println("" + this.childCount + " children found.");
        this.tRes.tested("getAccessibleChildCount()", this.childCount > -1);
    }

    public void _getAccessibleChild() {
        this.requiredMethod("getAccessibleChildCount()");
        this.log.println("testing 'getAccessibleChild()'...");
        boolean bOK = true;
        int counter = this.childCount;
        if (this.childCount > 500) {
            counter = 500;
        }
        for (int i = 0; i < counter; ++i) {
            try {
                XAccessible ch = this.oObj.getAccessibleChild(i);
                XAccessibleContext chAC = ch.getAccessibleContext();
                this.log.println("## Child " + i + ": " + chAC.getAccessibleDescription());
                if (!AccessibilityTools.equals(chAC.getAccessibleParent().getAccessibleContext(), this.oObj)) {
                    this.log.println("The parent of child and component itself differ.");
                    this.log.println("\tRole:");
                    this.log.println("Getting:  " + chAC.getAccessibleParent().getAccessibleContext().getAccessibleRole());
                    this.log.println("Expected: " + this.oObj.getAccessibleRole());
                    this.log.println("\tImplementationName:");
                    this.log.println("Getting:  " + utils.getImplName(chAC.getAccessibleParent().getAccessibleContext()));
                    this.log.println("Expected: " + utils.getImplName(this.oObj));
                    this.log.println("\tAccessibleDescription:");
                    this.log.println("Getting(Description):  " + chAC.getAccessibleParent().getAccessibleContext().getAccessibleDescription());
                    this.log.println("Expected(Description): " + this.oObj.getAccessibleDescription());
                    this.log.println("\tAccessibleName:");
                    this.log.println("Getting(Name):  " + chAC.getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("Expected(Name): " + this.oObj.getAccessibleName());
                    this.log.println("\tChildCount:");
                    this.log.println("Getting:  " + chAC.getAccessibleParent().getAccessibleContext().getAccessibleChildCount());
                    this.log.println("Expected: " + this.oObj.getAccessibleChildCount());
                    this.log.println("\tParentName:");
                    this.log.println("Getting (Name):  " + chAC.getAccessibleParent().getAccessibleContext().getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("Expected(Name): " + this.oObj.getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("##");
                    bOK = false;
                    continue;
                }
                this.log.println("Role: " + chAC.getAccessibleRole());
                this.log.println("Name: " + chAC.getAccessibleName());
                this.log.println("IndexInParent: " + chAC.getAccessibleIndexInParent());
                this.log.println("ImplementationName: " + utils.getImplName(chAC));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace(this.log);
                bOK = false;
            }
        }
        this.tRes.tested("getAccessibleChild()", bOK);
    }

    public void _getAccessibleParent() {
        this.parent = this.oObj.getAccessibleParent();
        this.tRes.tested("getAccessibleParent()", this.parent != null);
    }

    public void _getAccessibleIndexInParent() {
        this.requiredMethod("getAccessibleParent()");
        boolean bOK = true;
        int idx = this.oObj.getAccessibleIndexInParent();
        XAccessibleContext parentAC = this.parent.getAccessibleContext();
        try {
            if (parentAC.getAccessibleChild(idx) == null) {
                this.log.println("Parent has no child with this index");
                bOK &= false;
            } else {
                bOK &= AccessibilityTools.equals(parentAC.getAccessibleChild(idx).getAccessibleContext(), this.oObj);
            }
            if (!bOK) {
                this.log.println("Expected: " + utils.getImplName(this.oObj));
                if (parentAC.getAccessibleChild(idx) != null) {
                    this.log.println("Getting: " + utils.getImplName(parentAC.getAccessibleChild(idx).getAccessibleContext()));
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(this.log);
            bOK = false;
        }
        this.tRes.tested("getAccessibleIndexInParent()", bOK);
    }

    public void _getAccessibleRole() {
        short role = this.oObj.getAccessibleRole();
        this.log.println("The role is " + role);
        this.tRes.tested("getAccessibleRole()", role > -1);
    }

    public void _getAccessibleName() {
        String name = this.oObj.getAccessibleName();
        this.log.println("The name is '" + name + "'");
        this.tRes.tested("getAccessibleName()", name != null);
    }

    public void _getAccessibleDescription() {
        String descr = this.oObj.getAccessibleDescription();
        this.log.println("The description is '" + descr + "'");
        this.tRes.tested("getAccessibleDescription()", descr != null);
    }

    public void _getAccessibleRelationSet() {
        XAccessibleRelationSet set = this.oObj.getAccessibleRelationSet();
        this.tRes.tested("getAccessibleRelationSet()", true);
    }

    public void _getAccessibleStateSet() {
        XAccessibleStateSet set = this.oObj.getAccessibleStateSet();
        boolean res = true;
        String[] expectedStateNames = (String[])this.tEnv.getObjRelation("expectedStateNames");
        short[] expectedStates = (short[])this.tEnv.getObjRelation("expectedStates");
        res = expectedStateNames != null && expectedStates != null ? this.checkStates(expectedStateNames, expectedStates, set) : set != null;
        this.tRes.tested("getAccessibleStateSet()", res);
    }

    public void _getLocale() {
        Locale loc = null;
        try {
            loc = this.oObj.getLocale();
            this.log.println("The locale is " + loc.Language + "," + loc.Country);
        }
        catch (IllegalAccessibleComponentStateException e) {
            e.printStackTrace(this.log);
        }
        this.tRes.tested("getLocale()", loc != null && loc.Language.length() > 0 && loc.Country.length() > 0);
    }

    protected boolean checkStates(String[] expectedStateNames, short[] expectedStates, XAccessibleStateSet set) {
        boolean works = true;
        for (int k = 0; k < expectedStateNames.length; ++k) {
            boolean contains = set.contains(expectedStates[k]);
            if (contains) {
                this.log.println("Set contains " + expectedStateNames[k] + " ... OK");
                works &= true;
                continue;
            }
            this.log.println("Set doesn't contain " + expectedStateNames[k] + " ... FAILED");
            works &= false;
        }
        return works;
    }
}

