/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;
import lib.MultiMethodTest;
import util.AccessibilityTools;

public class _XAccessibleComponent
extends MultiMethodTest {
    public XAccessibleComponent oObj = null;
    private Rectangle bounds = null;
    private Vector KnownBounds = new Vector();

    public void _containsPoint() {
        int curY;
        int curX;
        this.requiredMethod("getBounds()");
        boolean result = true;
        for (curX = 0; !this.oObj.containsPoint(new Point(curX, 0)) && curX < this.bounds.Width; ++curX) {
        }
        if (curX < this.bounds.Width) {
            this.log.println("Upper bound of box containsPoint point (" + curX + ",0) - OK");
        } else {
            this.log.println("Upper bound of box containsPoint no component points - FAILED");
            result = false;
        }
        for (curX = 0; !this.oObj.containsPoint(new Point(curX, this.bounds.Height - 1)) && curX < this.bounds.Width; ++curX) {
            this.log.println("containsPoint returns false for (" + curX + "," + this.bounds.Height + ")");
        }
        if (curX < this.bounds.Width) {
            this.log.println("Lower bound of box containsPoint point (" + curX + "," + (this.bounds.Height - 1) + ") - OK");
        } else {
            this.log.println("Lower bound of box containsPoint no component points - FAILED");
            result = false;
        }
        for (curY = 0; !this.oObj.containsPoint(new Point(0, curY)) && curY < this.bounds.Height; ++curY) {
        }
        if (curY < this.bounds.Height) {
            this.log.println("Left bound of box containsPoint point (0," + curY + ") - OK");
        } else {
            this.log.println("Left bound of box containsPoint no component points - FAILED");
            result = false;
        }
        for (curY = 0; !this.oObj.containsPoint(new Point(this.bounds.Width - 1, curY)) && curY < this.bounds.Height; ++curY) {
        }
        if (curY < this.bounds.Height) {
            this.log.println("Right bound of box containsPoint point (" + (this.bounds.Width - 1) + "," + curY + ") - OK");
        } else {
            this.log.println("Right bound of box containsPoint no component points - FAILED");
            result = false;
        }
        boolean locRes = true;
        for (int x = -1; x <= this.bounds.Width; ++x) {
            locRes &= !this.oObj.containsPoint(new Point(x, -1));
            locRes &= !this.oObj.containsPoint(new Point(x, this.bounds.Height + this.bounds.Y));
        }
        if (locRes) {
            this.log.println("Outer upper and lower bounds contain no component points - OK");
        } else {
            this.log.println("Outer upper and lower bounds CONTAIN some component points - FAILED");
            result = false;
        }
        locRes = true;
        for (int y = -1; y <= this.bounds.Height; ++y) {
            locRes &= !this.oObj.containsPoint(new Point(-1, y));
            locRes &= !this.oObj.containsPoint(new Point(this.bounds.X + this.bounds.Width, y));
        }
        if (locRes) {
            this.log.println("Outer left and right bounds contain no component points - OK");
        } else {
            this.log.println("Outer left and right bounds CONTAIN some component points - FAILED");
            result = false;
        }
        this.tRes.tested("containsPoint()", result);
    }

    public void _getAccessibleAtPoint() {
        boolean result = true;
        XAccessibleComponent[] children = this.getChildrenComponents();
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                XAccessible xAccCh;
                int curY;
                Rectangle chBnd = children[i].getBounds();
                if (chBnd.X == -1) continue;
                this.log.println("Checking child with bounds (" + chBnd.X + "," + chBnd.Y + "),(" + chBnd.Width + "," + chBnd.Height + "): " + AccessibilityTools.accessibleToString(children[i]));
                XAccessibleContext xAc = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)children[i]);
                boolean MightBeCovered = false;
                boolean isShowing = xAc.getAccessibleStateSet().contains((short)25);
                this.log.println("\tStateType containsPoint SHOWING: " + isShowing);
                if (!isShowing) {
                    this.log.println("Child is invisible - OK");
                    continue;
                }
                this.log.println("finding the point which lies on the component");
                int curX = chBnd.Width / 2;
                for (curY = chBnd.Height / 2; !children[i].containsPoint(new Point(curX, curY)) && curX > 0 && curY > 0; --curX, --curY) {
                }
                if (curX == chBnd.Width && isShowing) {
                    this.log.println("Couldn't find a point with containsPoint");
                    continue;
                }
                XAccessible xAcc = this.oObj.getAccessibleAtPoint(new Point(chBnd.X + curX, chBnd.Y + curY));
                Point p = new Point(chBnd.X + curX, chBnd.X + curX);
                if (this.isCovered(p) && isShowing) {
                    this.log.println("Child might be covered by another and can't be reached");
                    MightBeCovered = true;
                }
                this.KnownBounds.add(chBnd);
                if (xAcc == null) {
                    this.log.println("The child not found at point (" + (chBnd.X + curX) + "," + (chBnd.Y + curY) + ") - FAILED");
                    result = isShowing ? false : (result &= true);
                } else {
                    String expDesc;
                    String expName;
                    int expIndex;
                    xAccCh = UnoRuntime.queryInterface(XAccessible.class, (Object)children[i]);
                    XAccessibleContext xAccC = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)children[i]);
                    this.log.println("Child found at point (" + (chBnd.X + curX) + "," + (chBnd.Y + curY) + ") - OK");
                    boolean res = false;
                    if (xAccCh != null) {
                        res = AccessibilityTools.equals(xAccCh, xAcc);
                        expIndex = xAccCh.getAccessibleContext().getAccessibleIndexInParent();
                        expName = xAccCh.getAccessibleContext().getAccessibleName();
                        expDesc = xAccCh.getAccessibleContext().getAccessibleDescription();
                    } else {
                        res = xAccC.getAccessibleName().equals(xAcc.getAccessibleContext().getAccessibleName());
                        expIndex = xAccC.getAccessibleIndexInParent();
                        expName = xAccC.getAccessibleName();
                        expDesc = xAccC.getAccessibleDescription();
                    }
                    if (!res) {
                        int gotIndex = xAcc.getAccessibleContext().getAccessibleIndexInParent();
                        if (expIndex < gotIndex) {
                            this.log.println("The children found is not the same");
                            this.log.println("The expected child " + expName);
                            this.log.print("is hidden behind the found Child ");
                            this.log.println(xAcc.getAccessibleContext().getAccessibleName() + " - OK");
                        } else {
                            this.log.println("The children found is not the same");
                            this.log.println("Expected: " + expName);
                            this.log.println("Description:  " + expDesc);
                            this.log.println("Found: " + xAcc.getAccessibleContext().getAccessibleName());
                            this.log.println("Description:  " + xAcc.getAccessibleContext().getAccessibleDescription());
                            if (MightBeCovered) {
                                this.log.println("... Child is covered by another - OK");
                            } else {
                                this.log.println("... FAILED");
                                result = false;
                            }
                        }
                    }
                }
                xAcc = this.oObj.getAccessibleAtPoint(new Point(chBnd.X - 1, chBnd.Y - 1));
                if (xAcc == null) {
                    this.log.println("No children found at point (" + (chBnd.X - 1) + "," + (chBnd.Y - 1) + ") - OK");
                    result &= true;
                    continue;
                }
                xAccCh = UnoRuntime.queryInterface(XAccessible.class, (Object)children[i]);
                boolean res = AccessibilityTools.equals(xAccCh, xAcc);
                if (!res) continue;
                this.log.println("The same child found outside its bounds at (" + (chBnd.X - 1) + "," + (chBnd.Y - 1) + ") - FAILED");
                result = false;
            }
        } else {
            this.log.println("There are no children supporting XAccessibleComponent");
        }
        this.tRes.tested("getAccessibleAtPoint()", result);
    }

    public void _getBounds() {
        boolean result = true;
        this.bounds = this.oObj.getBounds();
        boolean bl = this.bounds != null && this.bounds.X >= 0 && this.bounds.Y >= 0 && this.bounds.Width > 0 && this.bounds.Height > 0;
        this.log.println("Bounds = " + (this.bounds != null ? "(" + this.bounds.X + "," + this.bounds.Y + "),(" + this.bounds.Width + "," + this.bounds.Height + ")" : "null"));
        this.tRes.tested("getBounds()", result &= bl);
    }

    public void _getLocation() {
        this.requiredMethod("getBounds()");
        boolean result = true;
        Point loc = this.oObj.getLocation();
        this.tRes.tested("getLocation()", result &= loc.X == this.bounds.X && loc.Y == this.bounds.Y);
    }

    public void _getLocationOnScreen() {
        this.requiredMethod("getBounds()");
        XAccessibleComponent parent = this.getParentComponent();
        boolean result = true;
        Point loc = this.oObj.getLocationOnScreen();
        this.log.println("Location is (" + loc.X + "," + loc.Y + ")");
        if (parent != null) {
            Point parLoc = parent.getLocationOnScreen();
            this.log.println("Parent location is (" + parLoc.X + "," + parLoc.Y + ")");
            result &= parLoc.X + this.bounds.X == loc.X;
            result &= parLoc.Y + this.bounds.Y == loc.Y;
        }
        this.tRes.tested("getLocationOnScreen()", result);
    }

    public void _getSize() {
        this.requiredMethod("getBounds()");
        boolean result = true;
        Size size = this.oObj.getSize();
        result &= size.Width == this.bounds.Width;
        this.tRes.tested("getSize()", result &= size.Height == this.bounds.Height);
    }

    public void _grabFocus() {
        boolean result = true;
        this.oObj.grabFocus();
        this.tRes.tested("grabFocus()", result);
    }

    private XAccessibleComponent[] getChildrenComponents() {
        XAccessible xAcc = UnoRuntime.queryInterface(XAccessible.class, (Object)this.oObj);
        if (xAcc == null) {
            this.log.println("Component doesn't support XAccessible.");
            return new XAccessibleComponent[0];
        }
        XAccessibleContext xAccCon = xAcc.getAccessibleContext();
        int cnt = xAccCon.getAccessibleChildCount();
        if (cnt > 50) {
            cnt = 50;
        }
        Vector<XAccessibleComponent> childComp = new Vector<XAccessibleComponent>();
        for (int i = 0; i < cnt; ++i) {
            try {
                XAccessible child = xAccCon.getAccessibleChild(i);
                XAccessibleContext xAccConCh = child.getAccessibleContext();
                XAccessibleComponent xChAccComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccConCh);
                if (xChAccComp == null) continue;
                childComp.add(xChAccComp);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return childComp.toArray(new XAccessibleComponent[childComp.size()]);
    }

    private XAccessibleComponent getParentComponent() {
        XAccessible xAcc = UnoRuntime.queryInterface(XAccessible.class, (Object)this.oObj);
        if (xAcc == null) {
            this.log.println("Component doesn't support XAccessible.");
            return null;
        }
        XAccessibleContext xAccCon = xAcc.getAccessibleContext();
        XAccessible xAccPar = xAccCon.getAccessibleParent();
        if (xAccPar == null) {
            this.log.println("Component has no accessible parent.");
            return null;
        }
        XAccessibleContext xAccConPar = xAccPar.getAccessibleContext();
        XAccessibleComponent parent = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccConPar);
        if (parent == null) {
            this.log.println("Accessible parent doesn't support XAccessibleComponent");
            return null;
        }
        return parent;
    }

    public void _getForeground() {
        int forColor = this.oObj.getForeground();
        this.log.println("getForeground(): " + forColor);
        this.tRes.tested("getForeground()", true);
    }

    public void _getBackground() {
        int backColor = this.oObj.getBackground();
        this.log.println("getBackground(): " + backColor);
        this.tRes.tested("getBackground()", true);
    }

    @Override
    protected void after() {
        if (this.tEnv.getObjRelation("Destroy") != null) {
            this.disposeEnvironment();
        }
    }

    private boolean isCovered(Point p) {
        int elements = this.KnownBounds.size();
        boolean Covered = false;
        for (int k = 0; k < elements; ++k) {
            Rectangle known = (Rectangle)this.KnownBounds.get(k);
            Covered = known.X < p.X;
            Covered &= known.Y < p.Y;
            Covered &= p.Y < known.Y + known.Height;
            if (Covered &= p.X < known.X + known.Width) break;
        }
        return Covered;
    }
}

