/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleKeyBinding;
import com.sun.star.lang.IndexOutOfBoundsException;
import lib.MultiMethodTest;

public class _XAccessibleAction
extends MultiMethodTest {
    public XAccessibleAction oObj = null;
    public int count = 0;

    public void _getAccessibleActionCount() {
        this.count = this.oObj.getAccessibleActionCount();
        this.tRes.tested("getAccessibleActionCount()", this.count > 0);
    }

    public void _doAccessibleAction() {
        this.requiredMethod("getAccessibleActionKeyBinding()");
        boolean res = true;
        this.log.println("Calling method with wrong argument");
        try {
            this.oObj.doAccessibleAction(this.count);
            this.log.println("Exception expected -- FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException ioe) {
            this.log.println("Expected exception -- OK");
            res &= true;
        }
        try {
            boolean act = false;
            for (int i = 0; i < this.count; ++i) {
                this.log.println("do Action " + this.oObj.getAccessibleActionDescription(i));
                act = this.oObj.doAccessibleAction(i);
                this.log.println("Worked: " + act);
            }
            this.log.println("Did action: " + act);
            res &= act;
        }
        catch (IndexOutOfBoundsException ioe) {
            this.log.println("Unexepected exception -- FAILED");
            res &= false;
        }
        this.tRes.tested("doAccessibleAction()", res);
    }

    public void _getAccessibleActionDescription() {
        this.requiredMethod("getAccessibleActionCount()");
        boolean res = true;
        this.log.println("Calling method with wrong argument");
        try {
            this.oObj.getAccessibleActionDescription(this.count);
            this.log.println("Exception expected -- FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException ioe) {
            this.log.println("Expected exception -- OK");
            res &= true;
        }
        for (int i = 0; i < this.count; ++i) {
            try {
                String desc = this.oObj.getAccessibleActionDescription(i);
                this.log.println("Found action: " + desc);
                res &= desc != null;
                continue;
            }
            catch (IndexOutOfBoundsException ioe) {
                this.log.println("Unexepected exception -- FAILED");
                res &= false;
            }
        }
        this.tRes.tested("getAccessibleActionDescription()", res);
    }

    public void _getAccessibleActionKeyBinding() {
        this.requiredMethod("getAccessibleActionDescription()");
        boolean res = true;
        this.log.println("Calling method with wrong argument");
        try {
            this.oObj.getAccessibleActionKeyBinding(this.count);
            this.log.println("Exception expected -- FAILED");
            res &= false;
        }
        catch (IndexOutOfBoundsException ioe) {
            this.log.println("Expected exception -- OK");
            res &= true;
        }
        for (int i = 0; i < this.count; ++i) {
            try {
                XAccessibleKeyBinding key = this.oObj.getAccessibleActionKeyBinding(i);
                if (key != null) {
                    this.log.println("Found key: " + key.toString());
                }
                res &= true;
                continue;
            }
            catch (IndexOutOfBoundsException ioe) {
                this.log.println("Unexepected exception -- FAILED");
                res &= false;
            }
        }
        this.tRes.tested("getAccessibleActionKeyBinding()", res);
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }
}

