/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import lib.TestParameters;

public class StreamSimulator
implements XInputStream,
XOutputStream,
XSeekable {
    private String m_sFileName;
    private XInputStream m_xInStream;
    private XOutputStream m_xOutStream;
    private XSeekable m_xSeek;
    public boolean m_bInWasUsed;
    public boolean m_bOutWasUsed;

    public StreamSimulator(String sFileName, boolean bInput, TestParameters param) throws NotConnectedException {
        this.m_sFileName = sFileName;
        this.m_bInWasUsed = false;
        this.m_bOutWasUsed = false;
        try {
            XSimpleFileAccess xHelper = UnoRuntime.queryInterface(XSimpleFileAccess.class, ((XMultiServiceFactory)param.getMSF()).createInstance("com.sun.star.ucb.SimpleFileAccess"));
            if (xHelper == null) {
                throw new NotConnectedException("ucb helper not available. Can't create streams.");
            }
            if (bInput) {
                this.m_xInStream = xHelper.openFileRead(this.m_sFileName);
                this.m_xSeek = UnoRuntime.queryInterface(XSeekable.class, (Object)this.m_xInStream);
            } else {
                this.m_xOutStream = xHelper.openFileWrite(this.m_sFileName);
                this.m_xSeek = UnoRuntime.queryInterface(XSeekable.class, (Object)this.m_xOutStream);
            }
        }
        catch (Exception exUno) {
            throw new NotConnectedException("Could not open the file.");
        }
    }

    @Override
    public int readBytes(byte[][] lData, int nBytesToRead) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int nRead = 0;
        try {
            nRead = this.m_xInStream.readBytes(lData, nBytesToRead);
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exUno) {
            // empty catch block
        }
        return nRead;
    }

    @Override
    public int readSomeBytes(byte[][] lData, int nMaxBytesToRead) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int nRead = 0;
        try {
            nRead = this.m_xInStream.readSomeBytes(lData, nMaxBytesToRead);
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exUno) {
            // empty catch block
        }
        return nRead;
    }

    @Override
    public void skipBytes(int nBytesToSkip) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xInStream.skipBytes(nBytesToSkip);
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int available() throws NotConnectedException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        int nAvailable = 0;
        try {
            nAvailable = this.m_xInStream.available();
        }
        catch (NotConnectedException exConnect) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nAvailable;
    }

    @Override
    public void closeInput() throws NotConnectedException, IOException {
        this.m_bInWasUsed = true;
        if (this.m_xInStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xInStream.closeInput();
        }
        catch (NotConnectedException exConnect) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeBytes(byte[] lData) throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.writeBytes(lData);
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.flush();
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeOutput() throws NotConnectedException, BufferSizeExceededException, IOException {
        this.m_bOutWasUsed = true;
        if (this.m_xOutStream == null) {
            throw new NotConnectedException("stream not open");
        }
        try {
            this.m_xOutStream.closeOutput();
        }
        catch (NotConnectedException exConnect) {
        }
        catch (BufferSizeExceededException exBuffer) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void seek(long nLocation) throws IllegalArgumentException, IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        try {
            this.m_xSeek.seek(nLocation);
        }
        catch (IllegalArgumentException exArg) {
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getPosition() throws IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        long nPos = 0L;
        try {
            nPos = this.m_xSeek.getPosition();
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nPos;
    }

    @Override
    public long getLength() throws IOException {
        if (this.m_xInStream != null) {
            this.m_bInWasUsed = true;
        } else if (this.m_xOutStream != null) {
            this.m_bOutWasUsed = true;
        } else if (this.m_xSeek == null) {
            throw new IOException("stream not seekable");
        }
        long nLen = 0L;
        try {
            nLen = this.m_xSeek.getLength();
        }
        catch (IOException exIO) {
        }
        catch (RuntimeException exRuntime) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nLen;
    }
}

