/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SimpleMailSender {
    private String m_MailServer = "unknown";
    private String m_Sender = "unknown";
    private String m_Recipient = "unknown";
    private String m_Subject = "unknown";
    private String m_Message = "unknown";

    public String getMailServer() {
        return this.m_MailServer;
    }

    public void setMailServer(String server) {
        this.m_MailServer = server;
    }

    public String getSender() {
        return this.m_Sender;
    }

    public void setSender(String sender) {
        this.m_Sender = sender;
    }

    public String getRecipient() {
        return this.m_Recipient;
    }

    public void setRecipient(String recipient) {
        this.m_Recipient = recipient;
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public void setSubject(String subject) {
        this.m_Subject = subject;
    }

    public String getMessage() {
        return this.m_Message;
    }

    public void setMessage(String msg) {
        this.m_Message = msg;
    }

    public void sendMail() {
        if (this.m_MailServer.equals("unknown")) {
            System.out.println("No Mailserver given ... exiting");
            return;
        }
        if (this.m_Recipient.equals("unknown")) {
            System.out.println("No Recipient given ... exiting");
            return;
        }
        this.sendMail(this.m_MailServer, this.m_Sender, this.m_Recipient, this.m_Subject, this.m_Message);
    }

    public void sendMail(String server, String sender, String recipient, String subject, String msg) {
        this.m_MailServer = server;
        this.m_Sender = sender;
        this.m_Recipient = recipient;
        this.m_Subject = subject;
        this.m_Message = msg;
        try {
            Socket socket = new Socket(this.m_MailServer, 25);
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
            this.sendline(input, output, "HELO " + this.getHostName());
            this.sendline(input, output, "MAIL FROM: " + this.m_Sender);
            this.sendline(input, output, "RCPT TO: <" + this.m_Recipient + ">");
            this.sendline(input, output, "DATA");
            this.sendline(output, "MIME-Version: 1.0");
            this.sendline(output, "Subject: " + this.m_Subject);
            this.sendline(output, "From: " + this.m_Sender);
            this.sendline(output, "To: " + this.m_Recipient);
            this.sendline(output, "Content-Type: text/html; charset=\"us-ascii\"\r\n");
            this.sendline(output, this.m_Message);
            this.sendline(input, output, ".");
            this.sendline(input, output, "QUIT");
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendline(BufferedReader input, BufferedWriter output, String line) {
        try {
            output.write(line + "\r\n");
            output.flush();
            line = input.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendline(BufferedWriter output, String line) {
        try {
            output.write(line + "\r\n");
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getHostName() {
        String hostname = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }
}

