/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.beans.XFastPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XStringSubstitution;
import helper.AppProvider;
import helper.FileTools;
import helper.OfficeWatcher;
import helper.ProcessHandler;
import helper.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import lib.TestParameters;
import share.DescEntry;
import share.LogWriter;
import util.DynamicClassLoader;
import util.utils;

public class OfficeProvider
implements AppProvider {
    protected static boolean debug = false;

    public void backupUserLayer(TestParameters param, XMultiServiceFactory msf) {
        try {
            XStringSubstitution sts = OfficeProvider.createStringSubstitution(msf);
            debug = param.getBool("DebugIsActive");
            String userLayer = sts.getSubstituteVariableValue("$(user)");
            userLayer = OfficeProvider.getDirSys(userLayer);
            param.put("userLayer", userLayer);
            String copyLayer = utils.getUsersTempDir() + System.getProperty("file.separator") + "user_backup" + System.getProperty("user.name");
            param.put("copyLayer", copyLayer);
            OfficeProvider.dbg(" copy '" + userLayer + "' ->" + copyLayer + "'");
            OfficeWatcherPing owp = new OfficeWatcherPing((OfficeWatcher)param.get("Watcher"));
            owp.start();
            this.deleteFilesAndDirector(new File(copyLayer));
            FileTools.copyDirectory(new File(userLayer), new File(copyLayer), new String[]{"temp"});
            owp.finish();
        }
        catch (NoSuchElementException e) {
            System.out.println("User Variable '$(user)' not defined.");
        }
        catch (IOException e) {
            System.out.println("Couldn't backup user layer");
            e.printStackTrace();
        }
    }

    @Override
    public boolean disposeManager(TestParameters param) {
        XMultiServiceFactory msf = (XMultiServiceFactory)param.getMSF();
        if (msf == null) {
            return true;
        }
        XDesktop desk = null;
        try {
            desk = UnoRuntime.queryInterface(XDesktop.class, msf.createInstance("com.sun.star.frame.Desktop"));
        }
        catch (com.sun.star.uno.Exception ue) {
            return false;
        }
        msf = null;
        if (desk != null) {
            desk.terminate();
            return true;
        }
        return false;
    }

    @Override
    public Object getManager(TestParameters param) {
        String errorMessage = null;
        boolean bAppExecutionHasWarning = false;
        debug = param.getBool("DebugIsActive");
        String additionalArgs = (String)param.get("AdditionalConnectionArguments");
        additionalArgs = additionalArgs == null ? ";" : "," + additionalArgs + ";";
        String cncstr = "uno:" + param.get("ConnectionString") + ";urp" + additionalArgs + "StarOffice.ServiceManager";
        System.out.println("Connecting the Office with " + cncstr);
        XMultiServiceFactory msf = this.connectOffice(cncstr);
        if (param.getBool("AutoRestart") && msf != null) {
            OfficeProvider.makeAppExecCommand(msf, param);
        }
        if (msf == null) {
            String exc = "";
            Exception exConnectFailed = null;
            boolean isExecutable = false;
            boolean isAppKnown = cncstr.indexOf("host=localhost") > 0 || cncstr.indexOf("pipe,name=") > 0;
            if (isAppKnown &= !((String)param.get("AppExecutionCommand")).equals("")) {
                OfficeProvider.dbg("Local Connection trying to start the Office");
                OfficeWatcher ow_old = (OfficeWatcher)param.get("Watcher");
                if (ow_old != null) {
                    ow_old.finish = true;
                }
                String cmd = (String)param.get("AppExecutionCommand");
                OfficeProvider.dbg("AppExecutionCommand: " + cmd);
                errorMessage = utils.validateAppExecutionCommand(cmd, (String)param.get("OperatingSystem"));
                if (errorMessage.startsWith("Error")) {
                    System.out.println(errorMessage);
                    return null;
                }
                bAppExecutionHasWarning = !errorMessage.equals("OK");
                DynamicClassLoader dcl = new DynamicClassLoader();
                LogWriter log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
                DescEntry Entry2 = new DescEntry();
                Entry2.entryName = "office";
                Entry2.longName = "office";
                Entry2.EntryType = "placebo";
                Entry2.isOptional = false;
                Entry2.isToTest = false;
                Entry2.SubEntryCount = 0;
                Entry2.hasErrorMsg = false;
                Entry2.State = "non possible";
                Entry2.UserDefinedParams = param;
                log.initialize(Entry2, debug);
                ProcessHandler ph = new ProcessHandler(cmd, (PrintWriter)((Object)log));
                isExecutable = ph.executeAsynchronously();
                if (isExecutable) {
                    param.put("AppProvider", ph);
                    OfficeWatcher ow = new OfficeWatcher(param);
                    param.put("Watcher", ow);
                    ow.start();
                    ow.ping();
                }
                for (int k = 0; k < 42 && msf == null; ++k) {
                    try {
                        msf = OfficeProvider.connect(cncstr);
                    }
                    catch (com.sun.star.uno.Exception ue) {
                        exConnectFailed = ue;
                        exc = ue.getMessage();
                    }
                    catch (Exception je) {
                        exConnectFailed = je;
                        exc = je.getMessage();
                    }
                    if (msf != null) continue;
                    try {
                        Thread.sleep(k * 500);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (msf == null) {
                    System.out.println("Exception while connecting.\n" + exConnectFailed);
                    if (exc != null) {
                        System.out.println(exc);
                    }
                    if (bAppExecutionHasWarning) {
                        System.out.println(errorMessage);
                    }
                } else if (isExecutable && !param.getBool("DontBackupUserLayer")) {
                    this.backupUserLayer(param, msf);
                }
            } else {
                System.out.println("Could not connect an Office and cannot start one.\n".concat("please start an office with following parameter:\n").concat("\nsoffice -accept=").concat((String)param.get("ConnectionString")).concat(";urp;\n"));
                if (bAppExecutionHasWarning) {
                    System.out.println(errorMessage);
                }
            }
        }
        return msf;
    }

    protected static XMultiServiceFactory connect(String connectStr) throws com.sun.star.uno.Exception, RuntimeException, NoConnectException, Exception {
        XComponentContext xcomponentcontext = Bootstrap.createInitialComponentContext(null);
        XMultiComponentFactory xLocalServiceManager = xcomponentcontext.getServiceManager();
        Object xUrlResolver = xLocalServiceManager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xcomponentcontext);
        XUnoUrlResolver urlResolver = UnoRuntime.queryInterface(XUnoUrlResolver.class, xUrlResolver);
        Object rInitialObject = urlResolver.resolve(connectStr);
        XMultiServiceFactory xMSF = null;
        if (rInitialObject != null) {
            debug = true;
            OfficeProvider.dbg("resolved url");
            xMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, rInitialObject);
        }
        return xMSF;
    }

    @Override
    public boolean closeExistingOffice(TestParameters param, boolean closeIfPossible) {
        XMultiServiceFactory msf = (XMultiServiceFactory)param.getMSF();
        boolean alreadyConnected = msf != null;
        debug = param.getBool("DebugIsActive");
        if (alreadyConnected) {
            OfficeProvider.dbg("try to get ProcessHandler");
            ProcessHandler ph = (ProcessHandler)param.get("AppProvider");
            if (ph != null) {
                OfficeProvider.dbg("ProcessHandler != null");
                this.disposeOffice(msf, param);
                OfficeProvider.dbg("try to get OfficeWatcher");
                OfficeWatcher ow = (OfficeWatcher)param.get("Watcher");
                if (ow != null && ow.isAlive()) {
                    OfficeProvider.dbg("OfficeWatcher will be finished");
                    ow.finish = true;
                } else {
                    OfficeProvider.dbg("OfficeWatcher seems to be finished");
                }
                return true;
            }
            if (closeIfPossible) {
                return this.disposeOffice(msf, param);
            }
        } else {
            String cncstr = "uno:" + param.get("ConnectionString") + ";urp;StarOffice.ServiceManager";
            OfficeProvider.dbg("try to connect office");
            msf = this.connectOffice(cncstr);
            if (closeIfPossible) {
                return this.disposeOffice(msf, param);
            }
        }
        OfficeProvider.dbg("closeExistingOffice finished");
        return true;
    }

    private XMultiServiceFactory connectOffice(String cncstr) {
        XMultiServiceFactory msf = null;
        String exc = "";
        debug = true;
        OfficeProvider.dbg("trying to connect to " + cncstr);
        try {
            msf = OfficeProvider.connect(cncstr);
        }
        catch (com.sun.star.uno.Exception ue) {
            exc = ue.getMessage();
        }
        catch (Exception je) {
            exc = je.getMessage();
        }
        if (debug && exc != null && exc.length() != 0) {
            if (exc == null) {
                exc = "";
            }
            OfficeProvider.dbg("Could not connect an Office. " + exc);
        }
        return msf;
    }

    private synchronized boolean disposeOffice(XMultiServiceFactory msf, TestParameters param) {
        ProcessHandler ph;
        String AppKillCommand;
        XDesktop desk = null;
        debug = param.getBool("DebugIsActive");
        boolean result = true;
        if (msf != null) {
            try {
                Object quickStarter = msf.createInstance("com.sun.star.office.Quickstart");
                XFastPropertySet fps = UnoRuntime.queryInterface(XFastPropertySet.class, quickStarter);
                fps.setFastPropertyValue(0, false);
            }
            catch (com.sun.star.uno.Exception ex) {
                OfficeProvider.dbg("ERROR: Could not disable QuickStarter: " + ex.toString());
            }
            try {
                desk = UnoRuntime.queryInterface(XDesktop.class, msf.createInstance("com.sun.star.frame.Desktop"));
                msf = null;
                if (desk != null) {
                    boolean allClosed = this.closeAllWindows(desk);
                    if (!allClosed) {
                        OfficeProvider.dbg("Couldn't close all office windows!");
                    }
                    OfficeProvider.dbg("Trying to terminate the desktop");
                    desk.terminate();
                    OfficeProvider.dbg("Desktop terminated");
                    try {
                        int closeTime = param.getInt("OfficeCloseTimeOut");
                        OfficeProvider.dbg("the Office has " + closeTime / 1000 + " seconds for closing...");
                        Thread.sleep(closeTime);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (com.sun.star.uno.Exception ue) {
                result = false;
            }
            catch (DisposedException ue) {
                result = false;
            }
        }
        if ((AppKillCommand = (String)param.get("AppKillCommand")) != null) {
            String sAppKillCommand = StringHelper.removeSurroundQuoteIfExists(AppKillCommand);
            StringTokenizer aKillCommandToken = new StringTokenizer(sAppKillCommand, ";");
            while (aKillCommandToken.hasMoreTokens()) {
                String sKillCommand = aKillCommandToken.nextToken();
                OfficeProvider.dbg("User defined an application to destroy the started process. Trying to execute: " + sKillCommand);
                ProcessHandler pHdl = new ProcessHandler(sKillCommand, 1000);
                pHdl.runCommand();
                pHdl.kill();
            }
        }
        if ((ph = (ProcessHandler)param.get("AppProvider")) != null) {
            OfficeWatcher ow = (OfficeWatcher)param.get("Watcher");
            if (ow != null && ow.isAlive()) {
                ow.finish = true;
            }
            ph.kill();
        }
        param.remove("AppProvider");
        param.remove("ServiceFactory");
        if (!param.getBool("DontBackupUserLayer")) {
            try {
                String userLayer = (String)param.get("userLayer");
                String copyLayer = (String)param.get("copyLayer");
                if (userLayer != null && copyLayer != null) {
                    this.deleteFilesAndDirector(new File(userLayer));
                    File copyFile = new File(copyLayer);
                    OfficeProvider.dbg("copy '" + copyFile + "' -> '" + userLayer + "'");
                    FileTools.copyDirectory(copyFile, new File(userLayer), new String[]{"temp"});
                    OfficeProvider.dbg("copy '" + copyFile + "' -> '" + userLayer + "' finished");
                } else {
                    System.out.println("Cannot copy layer: '" + copyLayer + "' back to user layer: '" + userLayer + "'");
                }
            }
            catch (IOException e) {
                OfficeProvider.dbg("Couldn't recover from backup\n" + e.getMessage());
            }
        }
        return result;
    }

    protected boolean closeAllWindows(XDesktop desk) {
        XEnumerationAccess compEnumAccess = desk.getComponents();
        XEnumeration compEnum = compEnumAccess.createEnumeration();
        boolean res = true;
        try {
            while (compEnum.hasMoreElements()) {
                XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, compEnum.nextElement());
                if (closer == null) continue;
                closer.close(true);
            }
        }
        catch (CloseVetoException cve) {
            res = false;
        }
        catch (NoSuchElementException nsee) {
            res = false;
        }
        catch (WrappedTargetException wte) {
            res = false;
        }
        return res;
    }

    public static XStringSubstitution createStringSubstitution(XMultiServiceFactory xMSF) {
        Object xPathSubst = null;
        try {
            xPathSubst = xMSF.createInstance("com.sun.star.util.PathSubstitution");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
        }
        if (xPathSubst != null) {
            return UnoRuntime.queryInterface(XStringSubstitution.class, xPathSubst);
        }
        return null;
    }

    public static String getDirSys(String dir) {
        String sep;
        String sysDir = "";
        int idx = dir.indexOf("file://");
        int idx2 = dir.indexOf("file:///");
        sysDir = idx < 0 ? dir : dir.substring("file://".length());
        if ((sysDir = utils.replaceAll13(sysDir, "%20", " ")).charAt(sysDir.length() - 1) != '/') {
            sysDir = sysDir + "/";
        }
        if ((sep = System.getProperty("file.separator")).equalsIgnoreCase("\\")) {
            sysDir = idx2 >= 0 ? sysDir.substring(1) : "//" + sysDir;
            sysDir = sysDir.replace('/', '\\');
        }
        return sysDir;
    }

    private static void makeAppExecCommand(XMultiServiceFactory msf, TestParameters param) {
        debug = param.getBool("DebugIsActive");
        String command = (String)param.get("AppExecutionCommand");
        String connectionString = param.getBool("UsePipeConnection") ? (String)param.get("PipeConnectionString") : (String)param.get("ConnectionString");
        String sysBinDir = "";
        try {
            sysBinDir = utils.getSystemURL(utils.expandMacro(msf, "$SYSBINDIR"));
        }
        catch (Exception e) {
            OfficeProvider.dbg("could not get system binary directory");
            return;
        }
        if (command.indexOf(sysBinDir) == -1) {
            command = sysBinDir + System.getProperty("file.separator") + "soffice" + " -norestore -accept=" + connectionString + ";urp;";
        }
        OfficeProvider.dbg("update AppExecutionCommand: " + command);
        param.put("AppExecutionCommand", command);
    }

    private static void dbg(String message) {
        if (debug) {
            System.out.println(utils.getDateTime() + "OfficeProvider: " + message);
        }
    }

    private void deleteFilesAndDirector(File file) {
        File f = file;
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteFilesAndDirector(files[i]);
            }
            f.delete();
        } else if (f.isFile()) {
            f.delete();
        }
    }

    private class OfficeWatcherPing
    extends Thread {
        private final OfficeWatcher ow;
        private boolean bStop = false;

        public OfficeWatcherPing(OfficeWatcher ow) {
            this.ow = ow;
        }

        @Override
        public void run() {
            System.out.println(utils.getDateTime() + "OfficeProvider:Owp: start ");
            while (!this.bStop) {
                System.out.println(utils.getDateTime() + "OfficeProvider:Owp: ping ");
                this.ow.ping();
                try {
                    System.out.println(utils.getDateTime() + "OfficeProvider:Owp: sleep ");
                    OfficeWatcherPing.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            OfficeWatcherPing officeWatcherPing = this;
            synchronized (officeWatcherPing) {
                this.bStop = true;
                System.out.println(utils.getDateTime() + "OfficeProvider:Owp: stop ");
                this.notify();
            }
        }
    }
}

