/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.util.Properties;
import lib.TestParameters;
import util.utils;

public class ClParser {
    public void getCommandLineParameter(TestParameters param, String[] args) {
        Properties mapping = this.getMapping();
        int i = 0;
        while (i < args.length) {
            String pName = this.getParameterFor(mapping, args[i]).trim();
            String pValue = "";
            if (pName.equals("TestJob")) {
                if (args.length > i + 1) {
                    pValue = args[i].trim() + " " + args[i + 1].trim();
                    i += 2;
                } else {
                    pValue = args[i].trim() + " unknown";
                    i += 2;
                }
            } else if (i + 1 < args.length) {
                pValue = args[i + 1].trim();
                if (pValue.startsWith("-")) {
                    ++i;
                    pValue = "yes";
                } else if (pValue.startsWith("'")) {
                    ++i;
                    while (!pValue.endsWith("'")) {
                        pValue = pValue + " " + args[++i].trim();
                    }
                    pValue = utils.replaceAll13(pValue, "'", "");
                    ++i;
                } else {
                    i += 2;
                }
                if (pName.equals("TestDocumentPath")) {
                    System.setProperty("DOCPTH", pValue);
                } else if (pName.equals("SRC_ROOT")) {
                    System.setProperty(pName, pValue);
                }
            } else {
                pValue = "yes";
                ++i;
            }
            param.put(pName, pValue);
        }
    }

    public String getIniPath(String[] args) {
        String iniFile = "";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-ini")) continue;
            iniFile = args[i + 1];
            break;
        }
        return iniFile;
    }

    public String getRunnerIniPath(String[] args) {
        String iniFile = "";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-runnerini")) continue;
            iniFile = args[i + 1];
            break;
        }
        return iniFile;
    }

    protected Properties getMapping() {
        Properties map = new Properties();
        map.setProperty("-cs", "ConnectionString");
        map.setProperty("-tb", "TestBase");
        map.setProperty("-tdoc", "TestDocumentPath");
        map.setProperty("-objdsc", "DescriptionPath");
        map.setProperty("-cmd", "AppExecutionCommand");
        map.setProperty("-o", "TestJob");
        map.setProperty("-sce", "TestJob");
        map.setProperty("-p", "TestJob");
        map.setProperty("-aca", "AdditionalConnectionArguments");
        map.setProperty("-xcl", "ExclusionList");
        map.setProperty("-debug", "DebugIsActive");
        map.setProperty("-log", "LoggingIsActive");
        map.setProperty("-dbout", "DataBaseOut");
        map.setProperty("-nca", "NoCwsAttach");
        return map;
    }

    protected String getParameterFor(Properties map, String name) {
        String ret = map.getProperty(name);
        if (ret == null) {
            ret = name.substring(1);
        }
        return ret;
    }
}

