/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.File;
import java.io.PrintWriter;
import lib.TestParameters;
import share.LogWriter;

public class BuildEnvTools {
    private final TestParameters param;
    private final LogWriter log;
    private final boolean mDebug;
    private final String mPlatform;
    private final String mShell;
    private boolean mCygwin;

    public BuildEnvTools(TestParameters param, LogWriter log) throws ParameterNotFoundException {
        this.param = param;
        this.log = log;
        this.mDebug = param.getBool("DebugIsActive");
        boolean error = false;
        String msg = "\nERROR: the following parameter must be set before executing the test:\n\n";
        this.mPlatform = (String)param.get("OperatingSystem");
        if (this.mDebug) {
            log.println("### " + this.mPlatform);
        }
        if (this.mPlatform == null) {
            msg = msg + "OperatingSystem\nFill this parameter with an operating system like unxsols, unxsoli, unxlngi, unxmacxi or wntmsci.  \n\n";
        }
        if (!(this.mPlatform.equalsIgnoreCase("unxsols") || this.mPlatform.equalsIgnoreCase("unxsoli") || this.mPlatform.equalsIgnoreCase("unxlngi") || this.mPlatform.equalsIgnoreCase("unxmacxi") || this.mPlatform.equalsIgnoreCase("wntmsci"))) {
            msg = msg + "OperatingSystem:" + this.mPlatform + "\nFill this parameter with an operating system like unxsols," + " unxsoli, unxlngi, unxmacxi or wntmsci.  \n\n";
            error = true;
        }
        this.mShell = (String)param.get("Shell");
        if (this.mShell == null) {
            msg = msg + "Shell\nFill this parameter with a shell\n\t/bin/tcsh c:\\myShell\\myShell.exe\n\n";
            error = true;
        }
        this.mCygwin = param.getBool("Cygwin");
        if (error) {
            throw new ParameterNotFoundException(msg);
        }
    }

    public ProcessHandler runCommandsInEnvironmentShell(String[] commands, File workDir, int shortWait) {
        String[] cmdLines = this.getCmdLinesWithCommand(commands);
        ProcessHandler pHdl = new ProcessHandler(cmdLines, (PrintWriter)((Object)this.log), workDir, shortWait, this.param);
        pHdl.runCommand();
        return pHdl;
    }

    public String getSrcRoot() {
        String sSrcRoot = (String)this.param.get("SRC_ROOT");
        if (sSrcRoot == null) {
            String[] cmdLines = null;
            cmdLines = this.mPlatform.equals("wntmsci") && !this.mCygwin ? new String[]{this.mShell, "/C", "echo SRC_ROOT=%SRC_ROOT"} : new String[]{this.mShell, "--login ", "-c ", "echo \"SRC_ROOT=$SRC_ROOT\""};
            ProcessHandler procHdl = new ProcessHandler(cmdLines, (PrintWriter)((Object)this.log), null, 5000, this.param);
            procHdl.runCommand();
            if (this.mDebug) {
                this.log.println("---> Output of command:");
                this.log.println(procHdl.getOutputText());
                this.log.println("<--- Output of command:");
                this.log.println("---> Error output of command");
                this.log.println(procHdl.getErrorText());
                this.log.println("<--- Error output of command");
            }
            String output = procHdl.getOutputText();
            String[] outs = output.split("\n");
            for (int i = 0; i < outs.length; ++i) {
                String line = outs[i];
                if (!line.startsWith("SRC_ROOT")) continue;
                sSrcRoot = this.getEnvValue(line);
            }
        }
        return sSrcRoot;
    }

    private String[] getCmdLinesWithCommand(String[] commands) {
        String[] cmdLines = null;
        this.log.println("prepare command for platform " + this.mPlatform);
        String seperator = "";
        seperator = this.mPlatform.equals("wntmsci") ? (this.mCygwin ? ";" : "^") : ";";
        String command = "";
        for (int i = 0; i < commands.length; ++i) {
            if (i != 0) {
                command = command + seperator;
            }
            command = command + commands[i];
        }
        if (this.mPlatform.equals("wntmsci")) {
            if (this.mCygwin) {
                String srcRoot = (String)this.param.get("SRC_ROOT");
                String envSet = "export cyg_src_root=`cygpath '" + srcRoot.replaceAll("\\\\", "\\\\\\\\") + "'`; source $cyg_src_root/winenv.set.sh;";
                command = envSet + command;
                cmdLines = new String[]{this.mShell, "--login", "-c", "\"" + command + "\""};
            } else {
                cmdLines = new String[]{this.mShell, "/C", "\"" + command + "\""};
            }
        } else {
            cmdLines = new String[]{this.mShell, "-c", command};
        }
        return cmdLines;
    }

    private String getEnvValue(String line) {
        String[] split = line.split("=");
        return split[1];
    }
}

