/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.GlobalLogWriter;
import graphical.IniFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class PerformanceContainer {
    private long m_nStartTime;
    static final int Load = 0;
    static final int Store = 1;
    static final int Print = 2;
    static final int OfficeStart = 3;
    static final int StoreAsPDF = 4;
    static final int OfficeStop = 5;
    static final int AllTime = 6;
    static final int LAST_VALUE = 7;
    private long[] m_nTime = new long[7];
    private String m_sMSOfficeVersion;

    public long getStartTime() {
        return System.currentTimeMillis();
    }

    public void setStartTime(long _nStartTime) {
        this.m_nStartTime = _nStartTime;
    }

    private long meanTime(long _nCurrentTimer) {
        if (_nCurrentTimer == 0L) {
            GlobalLogWriter.get().println("Forgotten to initialise a start timer.");
            return 0L;
        }
        long nMeanTime = System.currentTimeMillis();
        return nMeanTime - _nCurrentTimer;
    }

    public PerformanceContainer() {
        for (int i = 0; i < 7; ++i) {
            this.m_nTime[i] = 0L;
        }
    }

    public void setTime(int _nIndex, long _nValue) {
        this.m_nTime[_nIndex] = _nValue;
    }

    public long getTime(int _nIndex) {
        return this.m_nTime[_nIndex];
    }

    public void startTime(int _nIndex) {
        this.m_nTime[_nIndex] = this.getStartTime();
    }

    public void stopTime(int _nIndex) {
        this.m_nTime[_nIndex] = this.meanTime(this.m_nTime[_nIndex]);
    }

    public String getMSOfficeVersion() {
        return this.m_sMSOfficeVersion;
    }

    public void print(PrintStream out) {
        out.println("loadtime=" + String.valueOf(this.m_nTime[0]));
        out.println("storetime=" + String.valueOf(this.m_nTime[1]));
        out.println("printtime=" + String.valueOf(this.m_nTime[2]));
        out.println("officestarttime=" + String.valueOf(this.m_nTime[3]));
        out.println("officestoptime=" + String.valueOf(this.m_nTime[5]));
        out.println("storeaspdftime=" + String.valueOf(this.m_nTime[4]));
        out.println("alltime=" + String.valueOf(this.m_nTime[6]));
    }

    public void print(IniFile _aIniFile, String _sSection) {
        _aIniFile.insertValue(_sSection, "loadtime", String.valueOf(this.m_nTime[0]));
        _aIniFile.insertValue(_sSection, "storetime", String.valueOf(this.m_nTime[1]));
        _aIniFile.insertValue(_sSection, "printtime", String.valueOf(this.m_nTime[2]));
        _aIniFile.insertValue(_sSection, "officestarttime", String.valueOf(this.m_nTime[3]));
        _aIniFile.insertValue(_sSection, "officestoptime", String.valueOf(this.m_nTime[5]));
        _aIniFile.insertValue(_sSection, "storeaspdftime", String.valueOf(this.m_nTime[4]));
        _aIniFile.insertValue(_sSection, "alltime", String.valueOf(this.m_nTime[6]));
    }

    public static double stringToDouble(String _sStr) {
        double nValue = 0.0;
        try {
            nValue = Double.parseDouble(_sStr);
        }
        catch (NumberFormatException e) {
            GlobalLogWriter.get().println("Can't convert string to double " + _sStr);
        }
        return nValue;
    }

    public static long secondsToMilliSeconds(double _nSeconds) {
        return (long)(_nSeconds * 1000.0);
    }

    public void readWordValuesFromFile(String sFilename) {
        File aFile = new File(sFilename);
        if (!aFile.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + sFilename);
            return;
        }
        RandomAccessFile aRandomAccessFile = null;
        try {
            aRandomAccessFile = new RandomAccessFile(aFile, "r");
            String sLine = "";
            while (sLine != null) {
                String sMSOfficeVersion;
                String sTime;
                sLine = aRandomAccessFile.readLine();
                if (sLine == null || sLine.length() < 2 || sLine.startsWith("#")) continue;
                if (sLine.startsWith("WordStartTime=")) {
                    sTime = sLine.substring(14);
                    this.m_nTime[3] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(sTime));
                    continue;
                }
                if (sLine.startsWith("WordLoadTime=")) {
                    sTime = sLine.substring(13);
                    this.m_nTime[0] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(sTime));
                    continue;
                }
                if (sLine.startsWith("WordPrintTime=")) {
                    sTime = sLine.substring(14);
                    this.m_nTime[2] = PerformanceContainer.secondsToMilliSeconds(PerformanceContainer.stringToDouble(sTime));
                    continue;
                }
                if (sLine.startsWith("WordVersion=")) {
                    sMSOfficeVersion = sLine.substring(12);
                    this.m_sMSOfficeVersion = "Word:" + sMSOfficeVersion;
                    continue;
                }
                if (sLine.startsWith("ExcelVersion=")) {
                    sMSOfficeVersion = sLine.substring(13);
                    this.m_sMSOfficeVersion = "Excel:" + sMSOfficeVersion;
                    continue;
                }
                if (!sLine.startsWith("PowerPointVersion=")) continue;
                sMSOfficeVersion = sLine.substring(18);
                this.m_sMSOfficeVersion = "PowerPoint:" + sMSOfficeVersion;
            }
        }
        catch (FileNotFoundException fne) {
            GlobalLogWriter.get().println("couldn't open file " + sFilename);
            GlobalLogWriter.get().println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Exception while reading file " + sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
        try {
            aRandomAccessFile.close();
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Couldn't close file " + sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
    }
}

