/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import com.sun.star.lang.XMultiServiceFactory;
import graphical.BuildID;
import graphical.GlobalLogWriter;
import graphical.PerformanceContainer;
import helper.StringHelper;
import lib.TestParameters;

public class ParameterHelper {
    private String m_sReferenceType = null;
    private String m_sPrinterName = null;
    private int m_nResolutionInDPI = 180;
    private boolean m_bIncludeSubdirectories;
    private String m_sInputPath = null;
    private String m_sOutputPath = null;
    private TestParameters m_aCurrentParams;
    PerformanceContainer m_aPerformanceContainer = null;
    String m_sImportFilterName = "";
    String m_sExportFilterName = "";
    String m_sDocumentType = "";
    private String m_sHTMLPrefix = null;

    private ParameterHelper() {
    }

    public ParameterHelper(TestParameters param) {
        this.m_aCurrentParams = param;
    }

    protected TestParameters getTestParameters() {
        return this.m_aCurrentParams;
    }

    public String getInputPath() {
        if (this.m_sInputPath == null) {
            String sInputPath = (String)this.getTestParameters().get("DOC_COMPARATOR_INPUT_PATH");
            if (sInputPath == null || sInputPath.length() == 0) {
                GlobalLogWriter.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            } else {
                this.m_sInputPath = StringHelper.removeQuoteIfExists(sInputPath);
            }
        }
        return this.m_sInputPath;
    }

    public String getOutputPath() {
        if (this.m_sOutputPath == null) {
            String sOutputPath = (String)this.getTestParameters().get("DOC_COMPARATOR_OUTPUT_PATH");
            if (sOutputPath == null || sOutputPath.length() == 0) {
                GlobalLogWriter.println("Please set output path (path where to store document results) DOC_COMPARATOR_OUTPUT_PATH=path.");
            } else {
                this.m_sOutputPath = StringHelper.removeQuoteIfExists(sOutputPath);
            }
        }
        return this.m_sOutputPath;
    }

    public boolean isIncludeSubDirectories() {
        this.m_bIncludeSubdirectories = true;
        String sRECURSIVE = (String)this.getTestParameters().get("DOC_COMPARATOR_INCLUDE_SUBDIRS");
        if (sRECURSIVE == null) {
            sRECURSIVE = "true";
        }
        if (sRECURSIVE.toLowerCase().equals("no") || sRECURSIVE.toLowerCase().equals("false")) {
            this.m_bIncludeSubdirectories = false;
        }
        return this.m_bIncludeSubdirectories;
    }

    public String getReferenceType() {
        if (this.m_sReferenceType == null) {
            String sReferenceType = (String)this.getTestParameters().get("DOC_COMPARATOR_REFERENCE_CREATOR_TYPE");
            this.m_sReferenceType = sReferenceType == null || sReferenceType.length() == 0 ? "OOo" : sReferenceType;
        }
        return this.m_sReferenceType;
    }

    public String getPrinterName() {
        if (this.m_sPrinterName == null) {
            String sPrinterName = (String)this.getTestParameters().get("DOC_COMPARATOR_PRINTER_NAME");
            this.m_sPrinterName = sPrinterName == null || sPrinterName.length() == 0 ? "" : sPrinterName;
        }
        return this.m_sPrinterName;
    }

    public PerformanceContainer getPerformance() {
        if (this.m_aPerformanceContainer == null) {
            this.m_aPerformanceContainer = new PerformanceContainer();
        }
        return this.m_aPerformanceContainer;
    }

    public String getBuildID() {
        String sAPP = (String)this.m_aCurrentParams.get("AppExecutionCommand");
        String sBuildID = BuildID.getBuildID(sAPP);
        return sBuildID;
    }

    public int getResolutionInDPI() {
        return this.m_nResolutionInDPI;
    }

    public XMultiServiceFactory getMultiServiceFactory() {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)this.m_aCurrentParams.getMSF();
        if ((this.getReferenceType().toLowerCase().equals("pdf") || this.getReferenceType().toLowerCase().equals("ooo")) && xMSF == null) {
            GlobalLogWriter.get().println("ERROR! MultiServiceFactory not given.");
        }
        return xMSF;
    }

    public boolean isHidden() {
        String sOfficeViewable = (String)this.m_aCurrentParams.get("OFFICE_VIEWABLE");
        if (sOfficeViewable != null) {
            return !sOfficeViewable.toLowerCase().equals("yes") && !sOfficeViewable.toLowerCase().equals("true");
        }
        return true;
    }

    public void setImportFilterName(String _sImportFilterName) {
        this.m_sImportFilterName = _sImportFilterName;
    }

    public String getImportFilterName() {
        return this.m_sImportFilterName;
    }

    public void setExportFilterName(String _sExportFilterName) {
        this.m_sExportFilterName = _sExportFilterName;
    }

    public String getExportFilterName() {
        return this.m_sExportFilterName;
    }

    public void setDocumentType(String _sName) {
        this.m_sDocumentType = _sName;
    }

    public String getDocumentType() {
        return this.m_sDocumentType;
    }

    public int getMaxPages() {
        int nMaxPages = this.m_aCurrentParams.getInt("DOC_COMPARATOR_PRINT_MAX_PAGE");
        return nMaxPages;
    }

    public String getOnlyPages() {
        String sOnlyPage = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_PRINT_ONLY_PAGE");
        if (sOnlyPage == null) {
            sOnlyPage = "";
        }
        return sOnlyPage;
    }

    public boolean printAllPages() {
        return this.getMaxPages() <= 0 && this.getOnlyPages().length() == 0;
    }

    public boolean getOverwrite() {
        boolean bOverwrite = this.m_aCurrentParams.getBool("DOC_COMPARATOR_OVERWRITE_REFERENCE");
        return bOverwrite;
    }

    public String getHTMLPrefix() {
        if (this.m_sHTMLPrefix == null) {
            String sPrefix = (String)this.getTestParameters().get("DOC_COMPARATOR_HTML_OUTPUT_PREFIX");
            if (sPrefix == null || sPrefix.length() == 0) {
                GlobalLogWriter.println("Please set html prefix DOC_COMPARATOR_HTML_OUTPUT_PREFIX=prefix.");
            } else {
                this.m_sHTMLPrefix = sPrefix;
            }
        }
        return this.m_sHTMLPrefix;
    }
}

