/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XTypeDetection;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XPrintable;
import graphical.DateHelper;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.IOffice;
import graphical.OfficeException;
import graphical.ParameterHelper;
import graphical.TimeHelper;
import helper.OSHelper;
import helper.OfficeProvider;
import helper.OfficeWatcher;
import helper.PropertyHelper;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;

public class OpenOfficePostscriptCreator
implements IOffice {
    private ParameterHelper m_aParameterHelper;
    private String m_sOutputURL;
    private String m_sBasename;
    private String m_sDocumentName;
    private XComponent m_aDocument;
    OfficeProvider m_aProvider = null;
    private boolean m_bStoreFile;

    public OpenOfficePostscriptCreator(ParameterHelper _aParam, String _sResult) {
        this.m_aParameterHelper = _aParam;
        String sOutputURL = _sResult;
        if (!sOutputURL.startsWith("file:")) {
            sOutputURL = URLHelper.getFileURLFromSystemPath(_sResult);
        }
        this.m_sOutputURL = sOutputURL;
        this.m_aDocument = null;
    }

    @Override
    public void load(String _sDocumentName) throws OfficeException {
        this.m_sDocumentName = _sDocumentName;
        String sInputFileURL = URLHelper.getFileURLFromSystemPath(this.m_sDocumentName);
        this.m_aDocument = this.loadFromURL(this.m_aParameterHelper, sInputFileURL);
        if (this.m_aDocument == null) {
            GlobalLogWriter.get().println("loadDocumentFromURL() failed with document: " + sInputFileURL);
            throw new OfficeException("load(): failed with document" + sInputFileURL);
        }
        this.m_sBasename = FileHelper.getBasename(this.m_sDocumentName);
    }

    @Override
    public void storeAsPostscript() throws OfficeException {
        if (this.m_aDocument != null) {
            String sDocumentName = FileHelper.appendPath(this.m_sOutputURL, this.m_sBasename);
            if (this.m_aParameterHelper.getReferenceType().toLowerCase().equals("ooo")) {
                String sPrintURL = sDocumentName + ".ps";
                this.impl_printToFileWithOOo(this.m_aParameterHelper, this.m_aDocument, sDocumentName, sPrintURL);
                String sBasename = FileHelper.getBasename(sPrintURL);
                FileHelper.addBasenameToIndex(this.m_sOutputURL, sBasename, "OOo", "postscript", this.m_sDocumentName);
            } else if (this.m_aParameterHelper.getReferenceType().toLowerCase().equals("pdf")) {
                String sPDFURL = sDocumentName + ".pdf";
                this.storeAsPDF(this.m_aParameterHelper, this.m_aDocument, sPDFURL);
                String sBasename = FileHelper.getBasename(sPDFURL);
                FileHelper.addBasenameToIndex(this.m_sOutputURL, sBasename, "OOo", "pdf-export", this.m_sDocumentName);
            } else {
                throw new OfficeException("unknown reference type");
            }
            GlobalLogWriter.get().println("Close document.");
            this.m_aDocument.dispose();
        }
    }

    @Override
    public void start() throws OfficeException {
        this.startOffice();
    }

    @Override
    public void close() throws OfficeException {
        this.stopOffice();
    }

    private void showProperty(PropertyValue _aValue) {
        String sName = _aValue.Name;
        try {
            String sValue = AnyConverter.toString((Object)_aValue.Value);
            GlobalLogWriter.get().println("Property " + sName + ":=" + sValue);
        }
        catch (IllegalArgumentException e) {
            GlobalLogWriter.get().println("showProperty: can't convert a object to string.");
        }
    }

    private String getDocumentType(XComponent _aDoc) {
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)_aDoc);
        PropertyValue[] aArgs = xModel.getArgs();
        for (int i = 0; i < aArgs.length; ++i) {
            PropertyValue aValue = aArgs[i];
            if (!aValue.Name.equals("FilterName") && !aValue.Name.equals("MediaType")) continue;
            String sNameValue = "'" + aValue.Name + "' := '" + aValue.Value + "'";
            return sNameValue;
        }
        return "";
    }

    private void showDocumentType(XComponent _aDoc) {
        String sNameValue = this.getDocumentType(_aDoc);
        GlobalLogWriter.get().println("  Property: '" + sNameValue);
    }

    private XComponent loadFromURL(ParameterHelper _aGTA, String _sInputURL) {
        XComponent aDoc = null;
        try {
            if (_aGTA.getMultiServiceFactory() == null) {
                GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
                return null;
            }
            Object oDsk = _aGTA.getMultiServiceFactory().createInstance("com.sun.star.frame.Desktop");
            XDesktop aDesktop = UnoRuntime.queryInterface(XDesktop.class, oDsk);
            if (aDesktop != null) {
                PropertyValue Arg;
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop created.");
                ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
                if (_aGTA.isHidden()) {
                    Arg = new PropertyValue();
                    Arg.Name = "Hidden";
                    Arg.Value = Boolean.TRUE;
                    aPropertyList.add(Arg);
                    this.showProperty(Arg);
                }
                if (_aGTA.getImportFilterName() != null && _aGTA.getImportFilterName().length() > 0) {
                    Arg = new PropertyValue();
                    Arg.Name = "FilterName";
                    Arg.Value = _aGTA.getImportFilterName();
                    aPropertyList.add(Arg);
                    this.showProperty(Arg);
                }
                PropertyValue ReadOnly = new PropertyValue();
                ReadOnly.Name = "ReadOnly";
                ReadOnly.Value = Boolean.TRUE;
                aPropertyList.add(ReadOnly);
                this.showProperty(ReadOnly);
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Load document");
                XComponentLoader aCompLoader = UnoRuntime.queryInterface(XComponentLoader.class, (Object)aDesktop);
                _aGTA.getPerformance().startTime(0);
                aDoc = aCompLoader.loadComponentFromURL(_sInputURL, "_blank", 23, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
                _aGTA.getPerformance().stopTime(0);
                if (aDoc != null) {
                    GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Load document done.");
                    this.showDocumentType(aDoc);
                    _aGTA.setDocumentType(this.getDocumentType(aDoc));
                } else {
                    GlobalLogWriter.get().println(" Load document failed.");
                    if (_aGTA.getImportFilterName() != null && _aGTA.getImportFilterName().length() > 0) {
                        GlobalLogWriter.get().println(" Please check FilterName := '" + _aGTA.getImportFilterName() + "'");
                    }
                    GlobalLogWriter.get().println("");
                }
            } else {
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop failed.");
            }
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            aDoc = null;
        }
        return aDoc;
    }

    private boolean exportToPDF(XComponent _xComponent, String _sDestinationName) {
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)_xComponent);
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        PropertyValue aFiltername = new PropertyValue();
        aFiltername.Name = "FilterName";
        aFiltername.Value = this.getFilterName_forPDF(xServiceInfo);
        aPropertyList.add(aFiltername);
        this.showProperty(aFiltername);
        boolean bWorked = true;
        try {
            XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)_xComponent);
            store.storeToURL(_sDestinationName, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("IO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            bWorked = false;
        }
        return bWorked;
    }

    private String getFilterName_forPDF(XServiceInfo xServiceInfo) {
        String filterName = "";
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            filterName = "writer_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            filterName = "calc_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            filterName = "draw_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            filterName = "impress_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.WebDocument")) {
            filterName = "writer_web_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.GlobalDocument")) {
            filterName = "writer_globaldocument_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.formulaFormulaProperties")) {
            filterName = "math_pdf_Export";
        }
        return filterName;
    }

    public boolean storeAsPDF(ParameterHelper _aGTA, XComponent _aDoc, String _sOutputURL) throws OfficeException {
        boolean bBack = true;
        _aGTA.getPerformance().startTime(4);
        bBack = this.exportToPDF(_aDoc, _sOutputURL);
        _aGTA.getPerformance().stopTime(4);
        if (!bBack) {
            GlobalLogWriter.get().println("Can't store document as PDF.");
            throw new OfficeException("Can't store document as PDF");
        }
        FileHelper.createInfoFile(_sOutputURL, _aGTA, "as pdf");
        return bBack;
    }

    private boolean impl_printToFileWithOOo(ParameterHelper _aGTA, XComponent _aDoc, String _sOutputURL, String _sPrintFileURL) {
        boolean bBack = false;
        boolean bFailed = true;
        if (_aDoc == null) {
            GlobalLogWriter.get().println("No document is given.");
            return bBack;
        }
        try {
            if (_sOutputURL != null) {
                if (this.isStoreAllowed()) {
                    XStorable aStorable = UnoRuntime.queryInterface(XStorable.class, (Object)_aDoc);
                    if (aStorable != null) {
                        PropertyValue[] szEmptyArgs = new PropertyValue[]{};
                        GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Store document.");
                        _aGTA.getPerformance().startTime(1);
                        aStorable.storeAsURL(_sOutputURL, szEmptyArgs);
                        _aGTA.getPerformance().stopTime(1);
                        GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Store document done.");
                        TimeHelper.waitInSeconds(1, "After store as URL to:" + _sOutputURL);
                        GlobalLogWriter.get().println("Reload stored file test.");
                        XComponent aDoc = this.loadFromURL(_aGTA, _sOutputURL);
                        if (aDoc == null) {
                            GlobalLogWriter.get().println("Reload stored file test failed, can't reload file: " + _sOutputURL);
                        } else {
                            XCloseable xClose = UnoRuntime.queryInterface(XCloseable.class, (Object)aDoc);
                            if (xClose != null) {
                                xClose.close(true);
                            } else {
                                aDoc.dispose();
                            }
                            TimeHelper.waitInSeconds(1, "after close temp document");
                        }
                    }
                } else {
                    String sOutputFilename = FileHelper.getSystemPathFromFileURL(_sOutputURL);
                    String sOutputPath = FileHelper.getPath(sOutputFilename);
                    File aFile = new File(sOutputPath);
                    aFile.mkdirs();
                }
            }
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            bBack = false;
        }
        try {
            GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Print document.");
            XPrintable aPrintable = UnoRuntime.queryInterface(XPrintable.class, (Object)_aDoc);
            if (aPrintable != null) {
                XMultiServiceFactory xMSF;
                Object aSettings;
                XServiceInfo xServiceInfo;
                if (OSHelper.isWindows() && _aGTA.getPrinterName() != null) {
                    ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
                    PropertyValue Arg = new PropertyValue();
                    Arg.Name = "Name";
                    Arg.Value = _aGTA.getPrinterName();
                    aPropertyList.add(Arg);
                    this.showProperty(Arg);
                    aPrintable.setPrinter(PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
                }
                if ((xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)_aDoc)).supportsService("com.sun.star.sheet.SpreadsheetDocument") && (aSettings = (xMSF = _aGTA.getMultiServiceFactory()).createInstance("com.sun.star.sheet.GlobalSheetSettings")) != null) {
                    XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, aSettings);
                    xPropSet.setPropertyValue("PrintAllSheets", new Boolean(true));
                }
                ArrayList<PropertyValue> aPrintProps = new ArrayList<PropertyValue>();
                GlobalLogWriter.get().println("Property FileName:=" + _sPrintFileURL);
                PropertyValue Arg = new PropertyValue();
                Arg.Name = "FileName";
                Arg.Value = _sPrintFileURL;
                aPrintProps.add(Arg);
                if (!_aGTA.printAllPages()) {
                    String sPages = "";
                    if (_aGTA.getMaxPages() > 0) {
                        sPages = "1-" + String.valueOf(_aGTA.getMaxPages());
                    }
                    if (_aGTA.getOnlyPages().length() != 0) {
                        if (sPages.length() != 0) {
                            sPages = sPages + ";";
                        }
                        sPages = sPages + String.valueOf(_aGTA.getOnlyPages());
                    }
                    Arg = new PropertyValue();
                    Arg.Name = "Pages";
                    Arg.Value = sPages;
                    aPrintProps.add(Arg);
                }
                this.showProperty(Arg);
                _aGTA.getPerformance().startTime(2);
                aPrintable.print(PropertyHelper.createPropertyValueArrayFormArrayList(aPrintProps));
                TimeHelper.waitInSeconds(1, "Start waiting for print ready.");
                GlobalLogWriter.get().println("Wait until document is printed.");
                boolean isBusy = true;
                int nPrintCount = 0;
                while (isBusy) {
                    PropertyValue[] aPrinterProps = aPrintable.getPrinter();
                    int nPropIndex = 0;
                    while (!"IsBusy".equals(aPrinterProps[nPropIndex].Name)) {
                        ++nPropIndex;
                    }
                    isBusy = aPrinterProps[nPropIndex].Value == Boolean.TRUE;
                    TimeHelper.waitInSeconds(1, "is print ready?");
                    if (++nPrintCount <= 3600) continue;
                    GlobalLogWriter.get().println("ERROR: Cancel print due to too long wait.");
                    throw new Exception("Convwatch exception, wait too long for printing.");
                }
                _aGTA.getPerformance().stopTime(2);
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Print document done.");
                FileHelper.createInfoFile(_sPrintFileURL, _aGTA);
            } else {
                GlobalLogWriter.get().println("Can't get XPrintable interface.");
            }
            bFailed = false;
            bBack = true;
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            bBack = false;
        }
        if (bFailed) {
            GlobalLogWriter.get().println("convwatch.OfficePrint: FAILED");
        } else {
            GlobalLogWriter.get().println("convwatch.OfficePrint: OK");
        }
        return bBack;
    }

    public boolean isReferenceExists(ParameterHelper _aGTA, String _sAbsoluteOutputPath, String _sAbsoluteInputFile) {
        String sInputFileBasename;
        String sPrintFilename;
        String sInputPath;
        if (!FileHelper.exists(_sAbsoluteInputFile)) {
            return false;
        }
        String sOutputPath = _sAbsoluteOutputPath != null ? _sAbsoluteOutputPath : (sInputPath = FileHelper.getPath(_sAbsoluteInputFile));
        String sAbsolutePrintFilename = FileHelper.appendPath(sOutputPath, (sPrintFilename = FileHelper.getNameNoSuffix(sInputFileBasename = FileHelper.getBasename(_sAbsoluteInputFile))) + ".prn");
        if (FileHelper.exists(sAbsolutePrintFilename) && !_aGTA.getOverwrite()) {
            GlobalLogWriter.get().println("Reference already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
            return true;
        }
        return false;
    }

    void showType(String _sInputURL, XMultiServiceFactory _xMSF) {
        if (_sInputURL.length() == 0) {
            return;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return;
        }
        XTypeDetection aTypeDetection = null;
        try {
            Object oObj = _xMSF.createInstance("com.sun.star.document.TypeDetection");
            aTypeDetection = UnoRuntime.queryInterface(XTypeDetection.class, oObj);
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return;
        }
        if (aTypeDetection != null) {
            String sType = aTypeDetection.queryTypeByURL(_sInputURL);
            GlobalLogWriter.get().println("Type is: " + sType);
        }
    }

    public String getInternalFilterName(String _sFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object aObj = null;
        try {
            aObj = _xMSF.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (aObj != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, aObj)) != null) {
            if (!aNameAccess.hasByName(_sFilterName)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + _sFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sFilterName);
                if (aElements != null) {
                    String sInternalFilterName = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        String sValue;
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("Type")) continue;
                        sInternalFilterName = sValue = (String)aPropertyValue.Value;
                    }
                    return sInternalFilterName;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    String getServiceNameFromFilterName(String _sFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object aObj = null;
        try {
            aObj = _xMSF.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (aObj != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, aObj)) != null) {
            if (!aNameAccess.hasByName(_sFilterName)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + _sFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sFilterName);
                if (aElements != null) {
                    String sServiceName = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        String sValue;
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("DocumentService")) continue;
                        sServiceName = sValue = (String)aPropertyValue.Value;
                        break;
                    }
                    return sServiceName;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    public static String getFileExtension(String _sInternalFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sInternalFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        XTypeDetection aTypeDetection = null;
        try {
            Object oObj = _xMSF.createInstance("com.sun.star.document.TypeDetection");
            aTypeDetection = UnoRuntime.queryInterface(XTypeDetection.class, oObj);
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return null;
        }
        if (aTypeDetection != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, (Object)aTypeDetection)) != null) {
            if (!aNameAccess.hasByName(_sInternalFilterName)) {
                GlobalLogWriter.get().println("TypeDetection.hasByName() says there exist no '" + _sInternalFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sInternalFilterName);
                if (aElements != null) {
                    String sExtension = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("Extensions")) continue;
                        String[] aExtensions = (String[])aPropertyValue.Value;
                        GlobalLogWriter.get().println("   Possible extensions are: " + String.valueOf(aExtensions.length));
                        if (aExtensions.length <= 0) continue;
                        for (int j = 0; j < aExtensions.length; ++j) {
                            GlobalLogWriter.get().println(" " + aExtensions[j]);
                        }
                        sExtension = aExtensions[0];
                        GlobalLogWriter.get().println("");
                    }
                    return sExtension;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sInternalFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    public void convertDocument(String _sInputFile, String _sOutputPath, ParameterHelper _aGTA) throws OfficeException {
        XMultiServiceFactory xMSF = _aGTA.getMultiServiceFactory();
        if (xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
            return;
        }
        String sInputURL = URLHelper.getFileURLFromSystemPath(_sInputFile);
        XComponent aDoc = this.loadFromURL(_aGTA, sInputURL);
        if (aDoc == null) {
            GlobalLogWriter.get().println("Can't load document '" + sInputURL + "'");
            return;
        }
        if (_sOutputPath == null) {
            GlobalLogWriter.get().println("Outputpath not set.");
            return;
        }
        if (!this.isStoreAllowed()) {
            GlobalLogWriter.get().println("It's not allowed to store, check Input/Output path.");
            return;
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)aDoc);
        XStorable xStorable = UnoRuntime.queryInterface(XStorable.class, (Object)aDoc);
        if (xStorable == null) {
            GlobalLogWriter.get().println("com.sun.star.frame.XStorable is null");
            return;
        }
        String sFilterName = _aGTA.getExportFilterName();
        boolean nPropertyCount = false;
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        String sExtension = "";
        if (sFilterName != null && sFilterName.length() > 0) {
            String sInternalFilterName = this.getInternalFilterName(sFilterName, xMSF);
            String sServiceName = this.getServiceNameFromFilterName(sFilterName, xMSF);
            GlobalLogWriter.get().println("Filter detection:");
            boolean bServiceFailed = false;
            if (sServiceName == null || sInternalFilterName == null) {
                GlobalLogWriter.get().println("Given FilterName '" + sFilterName + "' seems to be unknown.");
                bServiceFailed = true;
            }
            if (!xServiceInfo.supportsService(sServiceName)) {
                GlobalLogWriter.get().println("Service from FilterName '" + sServiceName + "' is not supported by loaded document.");
                bServiceFailed = true;
            }
            if (bServiceFailed) {
                GlobalLogWriter.get().println("Please check 'DOC_CONVERTER_EXPORT_FILTER_NAME' in the property file.");
                return;
            }
            if (sInternalFilterName != null && sInternalFilterName.length() > 0 && (sExtension = OpenOfficePostscriptCreator.getFileExtension(sInternalFilterName, xMSF)) == null) {
                GlobalLogWriter.get().println("Can't found an extension for filtername, take it from the source.");
            }
            PropertyValue Arg = new PropertyValue();
            Arg.Name = "FilterName";
            Arg.Value = sFilterName;
            aPropertyList.add(Arg);
            this.showProperty(Arg);
            GlobalLogWriter.get().println("FilterName is set to: " + sFilterName);
        }
        String sOutputURL = "";
        try {
            String sInputFileBasename = FileHelper.getBasename(_sInputFile);
            String sInputFileNameNoSuffix = FileHelper.getNameNoSuffix(sInputFileBasename);
            String fs = System.getProperty("file.separator");
            String sOutputFile = _sOutputPath;
            if (!sOutputFile.endsWith(fs)) {
                sOutputFile = sOutputFile + fs;
            }
            if (FileHelper.exists(sOutputFile = sExtension != null && sExtension.length() > 0 ? sOutputFile + sInputFileNameNoSuffix + "." + sExtension : sOutputFile + sInputFileBasename) && !_aGTA.getOverwrite()) {
                GlobalLogWriter.get().println("File already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
                return;
            }
            sOutputURL = URLHelper.getFileURLFromSystemPath(sOutputFile);
            GlobalLogWriter.get().println("Store document as '" + sOutputURL + "'");
            xStorable.storeAsURL(sOutputURL, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
            GlobalLogWriter.get().println("Document stored.");
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("Can't store document '" + sOutputURL + "'. Message is :'" + e.getMessage() + "'");
        }
    }

    private boolean shouldOfficeStart() {
        String sNoOffice = (String)this.m_aParameterHelper.getTestParameters().get("NoOffice");
        return sNoOffice == null || !sNoOffice.toLowerCase().startsWith("t") && !sNoOffice.toLowerCase().startsWith("y");
    }

    private void startOffice() {
        this.m_aParameterHelper.getTestParameters().put("DontBackupUserLayer", Boolean.TRUE);
        this.m_aParameterHelper.getPerformance().startTime(3);
        this.m_aProvider = new OfficeProvider();
        XMultiServiceFactory xMSF = (XMultiServiceFactory)this.m_aProvider.getManager(this.m_aParameterHelper.getTestParameters());
        this.m_aParameterHelper.getTestParameters().put("ServiceFactory", xMSF);
        this.m_aParameterHelper.getPerformance().stopTime(3);
        long nStartTime = this.m_aParameterHelper.getPerformance().getTime(3);
        this.m_aParameterHelper.getPerformance().setTime(3, nStartTime);
        GlobalLogWriter.get().println("Set office watcher");
        if (GlobalLogWriter.get().getWatcher() == null) {
            OfficeWatcher aWatcher = (OfficeWatcher)this.m_aParameterHelper.getTestParameters().get("Watcher");
            GlobalLogWriter.get().setWatcher(aWatcher);
        }
    }

    private void stopOffice() {
        if (this.m_aProvider != null) {
            this.m_aProvider.closeExistingOffice(this.m_aParameterHelper.getTestParameters(), true);
        }
    }

    public void disallowStore() {
        this.m_bStoreFile = false;
    }

    public void allowStore() {
        this.m_bStoreFile = true;
    }

    public boolean isStoreAllowed() {
        return false;
    }
}

